/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.HappinessData;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyHappinessManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IProgressManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IStatisticAchievementManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.ColonyState;
import com.minecolonies.coremod.colony.managers.BuildingManager;
import com.minecolonies.coremod.colony.managers.CitizenManager;
import com.minecolonies.coremod.colony.managers.ColonyHappinessManager;
import com.minecolonies.coremod.colony.managers.ColonyPackageManager;
import com.minecolonies.coremod.colony.managers.EventManager;
import com.minecolonies.coremod.colony.managers.ProgressManager;
import com.minecolonies.coremod.colony.managers.RaidManager;
import com.minecolonies.coremod.colony.managers.StatisticAchievementManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.pvp.AttackingPlayer;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.coremod.colony.workorders.WorkManager;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.coremod.permissions.ColonyPermissionEventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.server.permission.PermissionAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colony
implements IColony {
    private String style = "wooden";
    private final int id;
    private int dimensionId;
    private Set<Long> loadedChunks = new HashSet<Long>();
    private final Map<BlockPos, IBlockState> wayPoints = new HashMap<BlockPos, IBlockState>();
    private final WorkManager workManager = new WorkManager(this);
    private final IBuildingManager buildingManager = new BuildingManager(this);
    private final ICitizenManager citizenManager = new CitizenManager(this);
    private final IColonyHappinessManager colonyHappinessManager = new ColonyHappinessManager();
    private final IStatisticAchievementManager statsManager = new StatisticAchievementManager(this);
    private final IRaiderManager raidManager = new RaidManager(this);
    private final IEventManager eventManager = new EventManager(this);
    private final IColonyPackageManager packageManager = new ColonyPackageManager(this);
    private final IProgressManager progressManager = new ProgressManager(this);
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private ColonyPermissionEventHandler eventHandler;
    private boolean canColonyBeAutoDeleted = true;
    private boolean isDay = true;
    @Nullable
    private World world = null;
    private boolean manualHiring = false;
    private boolean manualHousing = false;
    private boolean moveIn = true;
    private String name = "ERROR(Wasn't placed by player)";
    private BlockPos center;
    @NotNull
    private Permissions permissions;
    private IRequestManager requestManager;
    private NBTTagCompound colonyTag;
    private final List<EntityPlayer> visitingPlayers = new ArrayList<EntityPlayer>();
    private final List<AttackingPlayer> attackingPlayers = new ArrayList<AttackingPlayer>();
    private final HappinessData happinessData = new HappinessData();
    private final ITickRateStateMachine<ColonyState> colonyStateMachine;
    private boolean needToMourn = false;
    private boolean mourning = false;
    private boolean isActive = true;
    private TextFormatting colonyTeamColor = TextFormatting.WHITE;
    private int boughtCitizenCost = 0;
    private long mercenaryLastUse = 0L;
    private int additionalChildTime = 0;
    private boolean hasChilds = false;

    Colony(int id, @Nullable World w, BlockPos c) {
        this(id, w);
        this.center = c;
        this.permissions = new Permissions(this);
        this.requestManager = new StandardRequestManager(this);
    }

    protected Colony(int id, @Nullable World world) {
        this.id = id;
        if (world != null) {
            this.dimensionId = world.field_73011_w.getDimension();
            this.onWorldLoad(world);
            this.checkOrCreateTeam();
        }
        this.permissions = new Permissions(this);
        for (String s : Configurations.gameplay.freeToInteractBlocks) {
            Block block = Block.func_149684_b((String)s);
            if (block == null) {
                BlockPos pos = BlockPosUtil.getBlockPosOfString(s);
                if (pos == null) continue;
                this.freePositions.add(pos);
                continue;
            }
            this.freeBlocks.add(block);
        }
        this.colonyStateMachine = new TickRateStateMachine<ColonyState>(ColonyState.INACTIVE, e -> {});
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.INACTIVE, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.UNLOADED, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<Object>(ColonyState.ACTIVE, () -> true, () -> {
            this.getCitizenManager().tickCitizenData();
            return null;
        }, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::updateSubscribers, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::tickRequests, () -> ColonyState.ACTIVE, 11));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::checkDayTime, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::updateWayPoints, () -> ColonyState.ACTIVE, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::worldTickSlow, () -> ColonyState.ACTIVE, 500));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.UNLOADED, this::worldTickUnloaded, () -> ColonyState.UNLOADED, 500));
    }

    private ColonyState updateState() {
        if (this.world == null) {
            return ColonyState.INACTIVE;
        }
        this.packageManager.updateAwayTime();
        if (!this.packageManager.getCloseSubscribers().isEmpty() || this.loadedChunks.size() > 40 && !this.packageManager.getImportantColonyPlayers().isEmpty()) {
            this.isActive = true;
            return ColonyState.ACTIVE;
        }
        if (!this.packageManager.getImportantColonyPlayers().isEmpty()) {
            this.isActive = true;
            return ColonyState.UNLOADED;
        }
        return ColonyState.INACTIVE;
    }

    private boolean updateSubscribers() {
        this.packageManager.updateSubscribers();
        return false;
    }

    private boolean tickRequests() {
        if (this.getRequestManager() != null) {
            this.getRequestManager().func_73660_a();
        }
        return false;
    }

    private boolean worldTickSlow() {
        this.buildingManager.cleanUpBuildings(this);
        this.raidManager.tryToRaidColony(this);
        this.citizenManager.onColonyTick(this);
        this.updateAttackingPlayers();
        this.eventManager.onColonyTick(this);
        this.buildingManager.onColonyTick(this);
        this.workManager.onColonyTick(this);
        this.updateChildTime();
        return false;
    }

    private boolean worldTickUnloaded() {
        this.updateChildTime();
        return false;
    }

    private boolean updateChildTime() {
        this.additionalChildTime = this.hasChilds ? (this.additionalChildTime += 500) : 0;
        return false;
    }

    private boolean checkDayTime() {
        if (this.isDay && !this.world.func_72935_r()) {
            this.isDay = false;
            this.eventManager.onNightFall();
            this.raidManager.onNightFall();
            if (!this.packageManager.getCloseSubscribers().isEmpty()) {
                this.citizenManager.checkCitizensForHappiness();
            }
            this.happinessData.processDeathModifiers();
            if (this.mourning) {
                this.mourning = false;
                this.citizenManager.updateCitizenMourn(false);
            }
        } else if (!this.isDay && this.world.func_72935_r()) {
            this.isDay = true;
            if (this.needToMourn) {
                this.needToMourn = false;
                this.mourning = true;
                this.citizenManager.updateCitizenMourn(true);
            }
        }
        return false;
    }

    public boolean updateAttackingPlayers() {
        ArrayList<EntityPlayer> visitors = new ArrayList<EntityPlayer>(this.visitingPlayers);
        for (EntityPlayer entityPlayer : visitors) {
            if (this.packageManager.getCloseSubscribers().contains(entityPlayer)) continue;
            this.visitingPlayers.remove(entityPlayer);
            this.attackingPlayers.remove(new AttackingPlayer(entityPlayer));
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (attackingPlayer.getGuards().isEmpty()) continue;
            attackingPlayer.refreshList(this);
            if (!attackingPlayer.getGuards().isEmpty()) continue;
            LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), "You successfully defended your colony against, " + attackingPlayer.getPlayer().func_70005_c_(), new Object[0]);
        }
        return false;
    }

    private void checkOrCreateTeam() {
        if (this.world.func_96441_U().func_96508_e("teamcolony" + this.id) == null) {
            this.world.func_96441_U().func_96527_f("teamcolony" + this.id);
            this.world.func_96441_U().func_96508_e("teamcolony" + this.id).func_96660_a(false);
        }
    }

    @Override
    public void setColonyColor(TextFormatting colonyColor) {
        if (this.world != null) {
            this.checkOrCreateTeam();
            this.colonyTeamColor = colonyColor;
            this.world.func_96441_U().func_96508_e("teamcolony" + this.id).func_178774_a(colonyColor);
            this.world.func_96441_U().func_96508_e("teamcolony" + this.id).func_96666_b(colonyColor.toString());
            this.markDirty();
        }
    }

    @Nullable
    public static Colony loadColony(@NotNull NBTTagCompound compound, @Nullable World world) {
        try {
            int id = compound.func_74762_e("id");
            Colony c = new Colony(id, world);
            c.name = compound.func_74779_i("name");
            c.center = BlockPosUtil.readFromNBT(compound, "center");
            c.setRequestManager();
            c.readFromNBT(compound);
            if (c.getProgressManager().isPrintingProgress() && (c.getBuildingManager().getBuildings().size() > 10 || c.getCitizenManager().getCitizens().size() > 20)) {
                c.getProgressManager().togglePrintProgress();
            }
            return c;
        }
        catch (Exception e) {
            Log.getLogger().warn("Something went wrong loading a colony, please report this to the administrators", (Throwable)e);
            return null;
        }
    }

    private void setRequestManager() {
        this.requestManager = new StandardRequestManager(this);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.manualHiring = compound.func_74767_n("manualHiring");
        this.dimensionId = compound.func_74762_e("dimension");
        if (compound.func_74764_b("needToMourn")) {
            this.needToMourn = compound.func_74767_n("needToMourn");
            this.mourning = compound.func_74767_n("mourning");
        } else {
            this.needToMourn = false;
            this.mourning = false;
        }
        this.boughtCitizenCost = compound.func_74762_e("bought_citizen");
        this.mercenaryLastUse = compound.func_74763_f("mercenaryUseTime");
        this.additionalChildTime = compound.func_74762_e("childTime");
        this.permissions.loadPermissions(compound);
        if (compound.func_74764_b("citizenManager")) {
            this.citizenManager.readFromNBT(compound.func_74775_l("citizenManager"));
        } else {
            this.citizenManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("buildingManager")) {
            this.buildingManager.readFromNBT(compound.func_74775_l("buildingManager"));
        } else {
            this.buildingManager.readFromNBT(compound);
        }
        this.citizenManager.calculateMaxCitizens();
        if (compound.func_74764_b("statsManager")) {
            this.statsManager.readFromNBT(compound.func_74775_l("statsManager"));
        } else {
            this.statsManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("progressManager")) {
            this.progressManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("happinessModifier")) {
            this.colonyHappinessManager.setLockedHappinessModifier(Optional.of(compound.func_74769_h("happinessModifier")));
        } else {
            this.colonyHappinessManager.setLockedHappinessModifier(Optional.empty());
        }
        this.eventManager.readFromNBT(compound);
        this.workManager.readFromNBT(compound.func_74775_l("work"));
        this.wayPoints.clear();
        NBTTagList wayPointTagList = compound.func_150295_c("waypoints", 10);
        for (int i = 0; i < wayPointTagList.func_74745_c(); ++i) {
            NBTTagCompound blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.readFromNBT(blockAtPos, "waypoints");
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)blockAtPos);
            this.wayPoints.put(pos, state);
        }
        this.freeBlocks.clear();
        NBTTagList freeBlockTagList = compound.func_150295_c("freeBlocks", 8);
        for (int i = 0; i < freeBlockTagList.func_74745_c(); ++i) {
            this.freeBlocks.add(Block.func_149684_b((String)freeBlockTagList.func_150307_f(i)));
        }
        this.freePositions.clear();
        NBTTagList freePositionTagList = compound.func_150295_c("freePositions", 10);
        for (int i = 0; i < freePositionTagList.func_74745_c(); ++i) {
            NBTTagCompound blockTag = freePositionTagList.func_150305_b(i);
            BlockPos block = BlockPosUtil.readFromNBT(blockTag, "freePositions");
            this.freePositions.add(block);
        }
        this.happinessData.readFromNBT(compound);
        this.packageManager.setLastContactInHours(compound.func_74762_e("abandoned"));
        this.manualHousing = compound.func_74767_n("manualHousing");
        if (compound.func_74764_b("moveIn")) {
            this.moveIn = compound.func_74767_n("moveIn");
        }
        if (compound.func_74764_b("style")) {
            this.style = compound.func_74779_i("style");
        }
        if (compound.func_74764_b("raidable")) {
            this.raidManager.setCanHaveRaiderEvents(compound.func_74767_n("raidable"));
        } else {
            this.raidManager.setCanHaveRaiderEvents(true);
        }
        this.canColonyBeAutoDeleted = compound.func_74764_b("autoDelete") ? compound.func_74767_n("autoDelete") : true;
        if (compound.func_74764_b("teamcolor")) {
            this.setColonyColor(TextFormatting.values()[compound.func_74762_e("teamcolor")]);
        }
        this.requestManager.reset();
        if (compound.func_74764_b("requestManager")) {
            this.requestManager.deserializeNBT((NBTBase)compound.func_74775_l("requestManager"));
        }
        this.colonyTag = compound;
    }

    public ColonyPermissionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a("id", this.id);
        compound.func_74768_a("dimension", this.dimensionId);
        compound.func_74778_a("name", this.name);
        BlockPosUtil.writeToNBT(compound, "center", this.center);
        compound.func_74757_a("manualHiring", this.manualHiring);
        compound.func_74757_a("needToMourn", this.needToMourn);
        compound.func_74757_a("mourning", this.mourning);
        compound.func_74768_a("bought_citizen", this.boughtCitizenCost);
        compound.func_74772_a("mercenaryUseTime", this.mercenaryLastUse);
        compound.func_74768_a("childTime", this.additionalChildTime);
        this.permissions.savePermissions(compound);
        NBTTagCompound buildingCompound = new NBTTagCompound();
        this.buildingManager.writeToNBT(buildingCompound);
        compound.func_74782_a("buildingManager", (NBTBase)buildingCompound);
        NBTTagCompound citizenCompound = new NBTTagCompound();
        this.citizenManager.writeToNBT(citizenCompound);
        compound.func_74782_a("citizenManager", (NBTBase)citizenCompound);
        this.colonyHappinessManager.getLockedHappinessModifier().ifPresent(d -> compound.func_74780_a("happinessModifier", d.doubleValue()));
        NBTTagCompound statsCompound = new NBTTagCompound();
        this.statsManager.writeToNBT(statsCompound);
        compound.func_74782_a("statsManager", (NBTBase)statsCompound);
        NBTTagCompound workManagerCompound = new NBTTagCompound();
        this.workManager.writeToNBT(workManagerCompound);
        compound.func_74782_a("work", (NBTBase)workManagerCompound);
        this.progressManager.writeToNBT(compound);
        this.eventManager.writeToNBT(compound);
        NBTTagList wayPointTagList = new NBTTagList();
        for (Map.Entry<BlockPos, IBlockState> entry : this.wayPoints.entrySet()) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, "waypoints", entry.getKey());
            NBTUtil.func_190009_a((NBTTagCompound)wayPointCompound, (IBlockState)entry.getValue());
            wayPointTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a("waypoints", (NBTBase)wayPointTagList);
        NBTTagList freeBlocksTagList = new NBTTagList();
        for (Block block : this.freeBlocks) {
            freeBlocksTagList.func_74742_a((NBTBase)new NBTTagString(block.getRegistryName().toString()));
        }
        compound.func_74782_a("freeBlocks", (NBTBase)freeBlocksTagList);
        NBTTagList nBTTagList = new NBTTagList();
        for (BlockPos pos : this.freePositions) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, "freePositions", pos);
            nBTTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a("freePositions", (NBTBase)nBTTagList);
        this.happinessData.writeToNBT(compound);
        compound.func_74768_a("abandoned", this.packageManager.getLastContactInHours());
        compound.func_74757_a("manualHousing", this.manualHousing);
        compound.func_74757_a("moveIn", this.moveIn);
        compound.func_74782_a("requestManager", this.getRequestManager().serializeNBT());
        compound.func_74778_a("style", this.style);
        compound.func_74757_a("raidable", this.raidManager.canHaveRaiderEvents());
        compound.func_74757_a("autoDelete", this.canColonyBeAutoDeleted);
        compound.func_74768_a("teamcolor", this.colonyTeamColor.ordinal());
        this.colonyTag = compound;
        this.isActive = false;
        return compound;
    }

    @Override
    public int getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public void onWorldLoad(@NotNull World w) {
        this.world = w;
        this.eventHandler = new ColonyPermissionEventHandler(this);
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
    }

    @Override
    public void onWorldUnload(@NotNull World w) {
        if (!w.equals(this.world)) {
            return;
        }
        if (this.eventHandler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.eventHandler);
        }
        this.world = null;
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
    }

    @Override
    @NotNull
    public IWorkManager getWorkManager() {
        return this.workManager;
    }

    public Set<BlockPos> getFreePositions() {
        return new HashSet<BlockPos>(this.freePositions);
    }

    public Set<Block> getFreeBlocks() {
        return new HashSet<Block>(this.freeBlocks);
    }

    @Override
    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
        this.markDirty();
    }

    @Override
    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
        this.markDirty();
    }

    @Override
    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
        this.markDirty();
    }

    @Override
    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
        this.markDirty();
    }

    @Override
    public HappinessData getHappinessData() {
        return this.happinessData;
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.world != this.getWorld()) {
            return;
        }
        this.colonyStateMachine.tick();
    }

    public static boolean shallUpdate(World world, int averageTicks) {
        return world.func_72820_D() % (long)(world.field_73012_v.nextInt(averageTicks * 2) + 1) == 0L;
    }

    @Override
    public boolean areAllColonyChunksLoaded() {
        float distanceFromCenter = Configurations.gameplay.workingRangeTownHallChunks;
        return (float)this.getLoadedChunkCount() / (distanceFromCenter * distanceFromCenter) >= 0.9f;
    }

    private boolean updateWayPoints() {
        BlockPos key;
        int stopAt;
        Object[] entries;
        Object obj;
        if (!this.wayPoints.isEmpty() && (obj = (entries = this.wayPoints.entrySet().toArray())[stopAt = this.world.field_73012_v.nextInt(entries.length)]) instanceof Map.Entry && ((Map.Entry)obj).getKey() instanceof BlockPos && ((Map.Entry)obj).getValue() instanceof IBlockState && this.world.func_175667_e(key = (BlockPos)((Map.Entry)obj).getKey())) {
            IBlockState value = (IBlockState)((Map.Entry)obj).getValue();
            Block worldBlock = this.world.func_180495_p(key).func_177230_c();
            if (worldBlock != value.func_177230_c() && worldBlock != ModBlocks.blockConstructionTape) {
                this.wayPoints.remove(key);
                this.markDirty();
            }
        }
        return false;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String n) {
        this.name = n;
        this.markDirty();
    }

    @Override
    @NotNull
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull World w, @NotNull BlockPos pos) {
        if (w.field_73011_w.getDimension() != this.dimensionId) {
            return false;
        }
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        return cap.getOwningColony() == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.buildingManager.hasTownHall();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.buildingManager.hasWarehouse();
    }

    @Override
    public int getLastContactInHours() {
        return this.packageManager.getLastContactInHours();
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public void markDirty() {
        this.packageManager.setDirty();
        this.isActive = true;
    }

    @Override
    public boolean canBeAutoDeleted() {
        return this.canColonyBeAutoDeleted;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.buildingManager.getBuilding(pos);
    }

    @Override
    @NotNull
    public Set<EntityPlayer> getMessageEntityPlayers() {
        HashSet<EntityPlayer> players = new HashSet<EntityPlayer>();
        for (EntityPlayerMP player : this.packageManager.getCloseSubscribers()) {
            if (!this.permissions.hasPermission((EntityPlayer)player, Action.RECEIVE_MESSAGES)) continue;
            players.add((EntityPlayer)player);
        }
        return players;
    }

    @Override
    @NotNull
    public Set<EntityPlayer> getImportantMessageEntityPlayers() {
        Set<EntityPlayer> playerList = this.getMessageEntityPlayers();
        for (EntityPlayerMP player : this.packageManager.getImportantColonyPlayers()) {
            if (!this.permissions.hasPermission((EntityPlayer)player, Action.RECEIVE_MESSAGES_FAR_AWAY)) continue;
            playerList.add((EntityPlayer)player);
        }
        return playerList;
    }

    @Override
    public boolean isManualHiring() {
        return this.manualHiring;
    }

    @Override
    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
        this.progressManager.progressEmploymentModeChange();
        this.markDirty();
    }

    @Override
    public boolean isManualHousing() {
        return this.manualHousing;
    }

    @Override
    public void setManualHousing(boolean manualHousing) {
        this.manualHousing = manualHousing;
        this.markDirty();
    }

    @Override
    public boolean canMoveIn() {
        return this.moveIn;
    }

    @Override
    public void setMoveIn(boolean newMoveIn) {
        this.moveIn = newMoveIn;
        this.markDirty();
    }

    public void removeWorkOrderInView(int orderId) {
        for (EntityPlayerMP player : this.packageManager.getCloseSubscribers()) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveWorkOrderMessage(this, orderId), player);
        }
    }

    @Override
    public void onBuildingUpgradeComplete(@Nullable IBuilding building, int level) {
        if (building != null) {
            building.onUpgradeComplete(level);
            this.getCitizenManager().calculateMaxCitizens();
            this.markDirty();
        }
    }

    @Override
    public void addWayPoint(BlockPos point, IBlockState block) {
        this.wayPoints.put(point, block);
        this.markDirty();
    }

    @Override
    public double getOverallHappiness() {
        if (this.citizenManager.getCitizens().size() <= 0) {
            return 5.5;
        }
        double happinesSum = 0.0;
        for (ICitizenData citizen : this.citizenManager.getCitizens()) {
            happinesSum += citizen.getCitizenHappinessHandler().getHappiness();
        }
        double happinessAverage = happinesSum / (double)this.citizenManager.getCitizens().size();
        return Math.min(happinessAverage + this.happinessData.getTotalHappinessModifier(), 10.0);
    }

    @Override
    public Map<BlockPos, IBlockState> getWayPoints() {
        return new HashMap<BlockPos, IBlockState>(this.wayPoints);
    }

    @Override
    public void setCanBeAutoDeleted(boolean canBeDeleted) {
        this.canColonyBeAutoDeleted = canBeDeleted;
        this.markDirty();
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public IBuildingManager getBuildingManager() {
        return this.buildingManager;
    }

    @Override
    public ICitizenManager getCitizenManager() {
        return this.citizenManager;
    }

    @Override
    public IColonyHappinessManager getColonyHappinessManager() {
        return this.colonyHappinessManager;
    }

    @Override
    public IStatisticAchievementManager getStatsManager() {
        return this.statsManager;
    }

    @Override
    public IRaiderManager getRaiderManager() {
        return this.raidManager;
    }

    @Override
    public IEventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public IColonyPackageManager getPackageManager() {
        return this.packageManager;
    }

    @Override
    public IProgressManager getProgressManager() {
        return this.progressManager;
    }

    public ImmutableList<EntityPlayer> getVisitingPlayers() {
        return ImmutableList.copyOf(this.visitingPlayers);
    }

    @Override
    public void addVisitingPlayer(EntityPlayer player) {
        Rank rank = this.getPermissions().getRank(player);
        if (rank != Rank.OWNER && rank != Rank.OFFICER && !this.visitingPlayers.contains(player) && Configurations.gameplay.sendEnteringLeavingMessages) {
            this.visitingPlayers.add(player);
            LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.enteringColony", this.getPermissions().getOwnerName());
            if (!PermissionAPI.hasPermission((EntityPlayer)player, (String)"minecolonies.colony.visitor.silent")) {
                LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), "com.minecolonies.coremod.enteringColonyNotify", player.func_70005_c_(), this.getName());
            }
        }
    }

    @Override
    public void removeVisitingPlayer(EntityPlayer player) {
        if (!this.getMessageEntityPlayers().contains(player) && Configurations.gameplay.sendEnteringLeavingMessages) {
            this.visitingPlayers.remove(player);
            LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.leavingColony", this.getPermissions().getOwnerName());
            if (!PermissionAPI.hasPermission((EntityPlayer)player, (String)"minecolonies.colony.visitor.silent")) {
                LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), "com.minecolonies.coremod.leavingColonyNotify", player.func_70005_c_(), this.getName());
            }
        }
    }

    @Override
    public NBTTagCompound getColonyTag() {
        try {
            if (this.colonyTag == null || this.isActive) {
                this.writeToNBT(new NBTTagCompound());
            }
        }
        catch (Exception e) {
            Log.getLogger().warn("Something went wrong persisting colony: " + this.id, (Throwable)e);
        }
        return this.colonyTag;
    }

    @Override
    public boolean isNeedToMourn() {
        return this.needToMourn;
    }

    @Override
    public void setNeedToMourn(boolean needToMourn, String name) {
        this.needToMourn = needToMourn;
        if (needToMourn) {
            LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), "com.minecolonies.coremod.mourning", name);
        }
    }

    @Override
    public boolean isMourning() {
        return this.mourning;
    }

    @Override
    public boolean isValidAttackingPlayer(EntityPlayer player) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            return attackingPlayer.isValidAttack(this);
        }
        return false;
    }

    @Override
    public boolean isValidAttackingGuard(AbstractEntityCitizen entity) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        return AttackingPlayer.isValidAttack(entity, this);
    }

    @Override
    public void addGuardToAttackers(AbstractEntityCitizen IEntityCitizen, EntityPlayer player) {
        if (player == null) {
            return;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            if (attackingPlayer.addGuard(IEntityCitizen)) {
                LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), "Beware, " + attackingPlayer.getPlayer().func_70005_c_() + " has now: " + attackingPlayer.getGuards().size() + " guards!", new Object[0]);
            }
            return;
        }
        for (EntityPlayer visitingPlayer : this.visitingPlayers) {
            if (!visitingPlayer.equals((Object)player)) continue;
            AttackingPlayer attackingPlayer = new AttackingPlayer(visitingPlayer);
            attackingPlayer.addGuard(IEntityCitizen);
            this.attackingPlayers.add(attackingPlayer);
            LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), "Beware, " + visitingPlayer.func_70005_c_() + " is attacking you and he brought guards.", new Object[0]);
        }
    }

    @Override
    public boolean isColonyUnderAttack() {
        return !this.attackingPlayers.isEmpty();
    }

    public TextFormatting getTeamColonyColor() {
        return this.colonyTeamColor;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public int getBoughtCitizenCost() {
        return this.boughtCitizenCost;
    }

    @Override
    public void increaseBoughtCitizenCost() {
        this.boughtCitizenCost = Math.min(1 + (int)Math.ceil((double)this.boughtCitizenCost * 1.5), 64);
        this.markDirty();
    }

    @Override
    public void usedMercenaries() {
        this.mercenaryLastUse = this.world.func_82737_E();
        this.markDirty();
    }

    @Override
    public long getMercenaryUseTime() {
        return this.mercenaryLastUse;
    }

    @Override
    public boolean useAdditionalChildTime(int amount) {
        if (this.additionalChildTime < amount) {
            return false;
        }
        this.additionalChildTime -= amount;
        return true;
    }

    @Override
    public void updateHasChilds() {
        for (ICitizenData data : this.getCitizenManager().getCitizens()) {
            if (!data.isChild()) continue;
            this.hasChilds = true;
            return;
        }
        this.hasChilds = false;
    }

    @Override
    public void addLoadedChunk(long chunkPos) {
        this.loadedChunks.add(chunkPos);
    }

    @Override
    public void removeLoadedChunk(long chunkPos) {
        this.loadedChunks.remove(chunkPos);
    }

    @Override
    public int getLoadedChunkCount() {
        return this.loadedChunks.size();
    }

    @Override
    public ColonyState getState() {
        return (ColonyState)this.colonyStateMachine.getState();
    }
}

