/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.client.model.ModelEntityCitizenFemaleCitizen;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RenderBipedCitizen<C extends EntityCitizen>
extends RenderBiped<C> {
    private static final ModelBiped defaultModelMale = new ModelBiped();
    private static final ModelBiped defaultModelFemale = new ModelEntityCitizenFemaleCitizen();
    private static final double SHADOW_SIZE = 0.5;
    private static final int THREE_QUARTERS = 270;
    public static boolean isItGhostTime = false;
    private static final ResourceLocation BLOCKING_RESOURCE = new ResourceLocation("minecolonies", "textures/icons/blocking.png");
    private static final ResourceLocation PENDING_RESOURCE = new ResourceLocation("minecolonies", "textures/icons/warning.png");

    public RenderBipedCitizen(RenderManager renderManagerIn) {
        super(renderManagerIn, defaultModelMale, 0.5f);
        super.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
    }

    public void doRender(@NotNull C citizen, double d, double d1, double d2, float f, float f1) {
        this.setupMainModelFrom(citizen);
        ModelBiped citizenModel = (ModelBiped)this.field_77045_g;
        ItemStack mainHandStack = citizen.func_184614_ca();
        ItemStack offHandStack = citizen.func_184592_cb();
        ModelBiped.ArmPose armPoseMainHand = this.getArmPoseFrom(citizen, mainHandStack, ModelBiped.ArmPose.EMPTY);
        ModelBiped.ArmPose armPoseOffHand = this.getArmPoseFrom(citizen, offHandStack, ModelBiped.ArmPose.EMPTY);
        this.updateArmPose(citizen, citizenModel, armPoseMainHand, armPoseOffHand);
        if (isItGhostTime) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            super.func_76986_a(citizen, d, d1, d2, f, f1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
        } else {
            super.func_76986_a(citizen, d, d1, d2, f, f1);
        }
    }

    private void setupMainModelFrom(@NotNull C citizen) {
        ModelBase modelBase = this.field_77045_g = ((AbstractEntityCitizen)((Object)citizen)).isFemale() ? (ModelBase)IModelTypeRegistry.getInstance().getFemaleMap().get(((AbstractEntityCitizen)((Object)citizen)).getModelType()) : (ModelBase)IModelTypeRegistry.getInstance().getMaleMap().get(((AbstractEntityCitizen)((Object)citizen)).getModelType());
        if (this.field_77045_g == null) {
            this.field_77045_g = ((AbstractEntityCitizen)((Object)citizen)).isFemale() ? defaultModelFemale : defaultModelMale;
        }
        this.field_77045_g.field_78091_s = ((EntityCitizen)((Object)citizen)).func_70631_g_();
    }

    protected void renderLivingLabel(C entityIn, String str, double x, double yIn, double z, int maxDistance) {
        double distance;
        double yOffset;
        super.func_147906_a(entityIn, str, x, yIn, z, maxDistance);
        double d = yOffset = this.field_77045_g.field_78091_s ? -0.8 : 0.0;
        if (entityIn instanceof EntityCitizen && ((EntityCitizen)((Object)entityIn)).getCitizenDataView() != null && ((EntityCitizen)((Object)entityIn)).getCitizenDataView().hasPendingInteractions() && !((distance = entityIn.func_70068_e(this.field_76990_c.field_78734_h)) > (double)(maxDistance * maxDistance))) {
            boolean isSneaking = entityIn.func_70093_af();
            double viewerYaw = this.field_76990_c.field_78735_i;
            double viewerPitch = this.field_76990_c.field_78732_j;
            double f2 = entityIn.func_70047_e() + 0.5f - (isSneaking ? 0.25f : 0.0f);
            double y = yIn + f2 + 0.3 + yOffset;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((EntityCitizen)((Object)entityIn)).getCitizenDataView().hasBlockingInteractions() ? BLOCKING_RESOURCE : PENDING_RESOURCE);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(-viewerYaw)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            if (!isSneaking) {
                GlStateManager.func_179097_i();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder r = tess.func_178180_c();
            r.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            r.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            r.func_181662_b(0.0, 10.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            r.func_181662_b(10.0, 10.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            r.func_181662_b(10.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179098_w();
            if (!isSneaking) {
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    private ModelBiped.ArmPose getArmPoseFrom(@NotNull C citizen, ItemStack mainHandStack, ModelBiped.ArmPose armPoseMainHand) {
        if (!mainHandStack.func_190926_b()) {
            armPoseMainHand = ModelBiped.ArmPose.ITEM;
            if (citizen.func_184605_cv() > 0) {
                EnumAction enumActionMainHand = mainHandStack.func_77975_n();
                if (enumActionMainHand == EnumAction.BLOCK) {
                    armPoseMainHand = ModelBiped.ArmPose.BLOCK;
                } else if (enumActionMainHand == EnumAction.BOW) {
                    armPoseMainHand = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        return armPoseMainHand;
    }

    private void updateArmPose(@NotNull C citizen, ModelBiped citizenModel, ModelBiped.ArmPose armPoseMainHand, ModelBiped.ArmPose armPoseOffHand) {
        if (citizen.func_184591_cq() == EnumHandSide.RIGHT) {
            citizenModel.field_187076_m = armPoseMainHand;
            citizenModel.field_187075_l = armPoseOffHand;
        } else {
            citizenModel.field_187076_m = armPoseOffHand;
            citizenModel.field_187075_l = armPoseMainHand;
        }
    }

    protected void renderLivingAt(C entityLivingBaseIn, double x, double y, double z) {
        if (entityLivingBaseIn.func_70089_S() && ((EntityCitizen)((Object)entityLivingBaseIn)).getCitizenSleepHandler().isAsleep()) {
            super.func_77039_a(entityLivingBaseIn, x + (double)((EntityCitizen)((Object)entityLivingBaseIn)).getCitizenSleepHandler().getRenderOffsetX(), y + 0.6875, z + (double)((EntityCitizen)((Object)entityLivingBaseIn)).getCitizenSleepHandler().getRenderOffsetZ());
        } else {
            super.func_77039_a(entityLivingBaseIn, x, y, z);
        }
    }

    protected void applyRotations(C entityLiving, float rotationHead, float rotationYaw, float partialTicks) {
        if (entityLiving.func_70089_S() && ((EntityCitizen)((Object)entityLiving)).getCitizenSleepHandler().isAsleep()) {
            GlStateManager.func_179114_b((float)((EntityCitizen)((Object)entityLiving)).getCitizenSleepHandler().getBedOrientationInDegrees(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.func_77037_a((EntityLivingBase)entityLiving), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.func_77043_a(entityLiving, rotationHead, rotationYaw, partialTicks);
        }
    }

    protected ResourceLocation getEntityTexture(@NotNull EntityCitizen entity) {
        return entity.getTexture();
    }
}

