/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.api;

import com.minecolonies.api.inventory.api.IWorldNameableModifiable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedItemHandler
implements IItemHandlerModifiable,
INBTSerializable<NBTTagCompound>,
IWorldNameableModifiable {
    private static final String NBT_KEY_HANDLERS = "Handlers";
    private static final String NBT_KEY_HANDLERS_INDEXLIST = "Index";
    private static final String NBT_KEY_NAME = "Name";
    private final IItemHandlerModifiable[] handlers;
    @NotNull
    private final String defaultName;
    @Nullable
    private String customName;

    public CombinedItemHandler(@NotNull String defaultName, IItemHandlerModifiable ... handlers) {
        this.handlers = handlers;
        this.defaultName = defaultName;
    }

    public CombinedItemHandler(@NotNull String defaultName, @NotNull String customName, IItemHandlerModifiable ... handlers) {
        this.handlers = handlers;
        this.customName = customName;
        this.defaultName = defaultName;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        int index = 0;
        NBTTagList handlerList = new NBTTagList();
        NBTTagList indexList = new NBTTagList();
        for (IItemHandlerModifiable handlerModifiable : this.handlers) {
            if (handlerModifiable instanceof INBTSerializable) {
                INBTSerializable serializable = (INBTSerializable)handlerModifiable;
                handlerList.func_74742_a(serializable.serializeNBT());
                indexList.func_74742_a((NBTBase)new NBTTagInt(index));
            }
            ++index;
        }
        compound.func_74782_a(NBT_KEY_HANDLERS, (NBTBase)handlerList);
        if (this.func_145818_k_()) {
            compound.func_74778_a(NBT_KEY_NAME, this.customName);
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList handlerList = nbt.func_150295_c(NBT_KEY_NAME, 10);
        NBTTagList indexList = nbt.func_150295_c(NBT_KEY_HANDLERS_INDEXLIST, 3);
        if (handlerList.func_74745_c() == this.handlers.length) {
            for (int i = 0; i < handlerList.func_74745_c(); ++i) {
                NBTTagCompound handlerCompound = handlerList.func_150305_b(i);
                IItemHandlerModifiable modifiable = this.handlers[indexList.func_186858_c(i)];
                if (!(modifiable instanceof INBTSerializable)) continue;
                INBTSerializable serializable = (INBTSerializable)modifiable;
                serializable.deserializeNBT((NBTBase)handlerCompound);
            }
        }
        this.setName(nbt.func_74764_b(NBT_KEY_NAME) ? nbt.func_74779_i(NBT_KEY_NAME) : null);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                modifiable.setStackInSlot(activeSlot, stack);
                return;
            }
            activeSlot -= modifiable.getSlots();
        }
    }

    public int getLastIndex(int slot) {
        int slots = 0;
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.getSlots() + slots;
            }
            slots += modifiable.getSlots();
            activeSlot -= modifiable.getSlots();
        }
        return 0;
    }

    public int getSlots() {
        int sum = 0;
        for (IItemHandlerModifiable handler : this.handlers) {
            if (handler == null) continue;
            sum += handler.getSlots();
        }
        return sum;
    }

    public ItemStack getStackInSlot(int slot) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.getStackInSlot(activeSlot);
            }
            activeSlot -= modifiable.getSlots();
        }
        return null;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.defaultName;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.insertItem(activeSlot, stack, simulate);
            }
            activeSlot -= modifiable.getSlots();
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int checkedSlots = 0;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (modifiable.getSlots() + checkedSlots <= slot) {
                checkedSlots += modifiable.getSlots();
                continue;
            }
            int activeSlot = slot - checkedSlots;
            if (activeSlot >= modifiable.getSlots()) continue;
            return modifiable.extractItem(activeSlot, amount, simulate);
        }
        return null;
    }

    public int getSlotLimit(int slot) {
        int slotIndex = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (slotIndex >= modifiable.getSlots()) {
                slotIndex -= modifiable.getSlots();
                continue;
            }
            return modifiable.getSlotLimit(slotIndex);
        }
        return 0;
    }

    protected IItemHandlerModifiable[] getHandlers() {
        return (IItemHandlerModifiable[])this.handlers.clone();
    }

    @Override
    public void setName(@Nullable String name) {
        this.customName = name;
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }
}

