/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.google.common.collect.Multimap;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.IArcherMobEntity;
import com.minecolonies.api.entity.mobs.IChiefMobEntity;
import com.minecolonies.api.entity.mobs.barbarians.IChiefBarbarianEntity;
import com.minecolonies.api.entity.mobs.barbarians.IMeleeBarbarianEntity;
import com.minecolonies.api.entity.mobs.pirates.ICaptainPirateEntity;
import com.minecolonies.api.entity.mobs.pirates.IPirateEntity;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class RaiderMobUtils {
    public static double MOB_SPAWN_DEVIATION_STEPS = 0.3;
    public static final IAttribute MOB_ATTACK_DAMAGE = new RangedAttribute(null, "mc_mob_damage", 2.0, 1.0, 20.0);
    public static int DAMAGE_PER_X_RAID_LEVEL = 200;
    public static int MAX_RAID_LEVEL_DAMAGE = 3;

    private RaiderMobUtils() {
        throw new IllegalStateException("Tried to initialize: MobSpawnUtils but this is a Utility class.");
    }

    public static void setupMobAi(AbstractEntityMinecoloniesMob mob) {
        Multimap<Integer, EntityAIBase> aiTasks = IMinecoloniesAPI.getInstance().getMobAIRegistry().getEntityAiTasksForMobs(mob);
        aiTasks.keySet().forEach(priority -> aiTasks.get(priority).forEach(task -> mob.field_70714_bg.func_75776_a(priority.intValue(), task)));
        Multimap<Integer, EntityAIBase> aiTargetTasks = IMinecoloniesAPI.getInstance().getMobAIRegistry().getEntityAiTargetTasksForMobs(mob);
        aiTargetTasks.keySet().forEach(priority -> aiTargetTasks.get(priority).forEach(task -> mob.field_70714_bg.func_75776_a(priority.intValue(), task)));
    }

    public static void setMobAttributes(EntityLiving mob, IColony colony) {
        mob.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        int raidLevel = colony.getRaiderManager().getColonyRaidLevel();
        double attackDamage = (double)((float)Configurations.gameplay.barbarianHordeDifficulty / 10.0f) + 1.0 + (double)Math.max(raidLevel / DAMAGE_PER_X_RAID_LEVEL, MAX_RAID_LEVEL_DAMAGE);
        mob.func_110148_a(MOB_ATTACK_DAMAGE).func_111128_a(attackDamage);
        if (mob instanceof IChiefMobEntity) {
            double chiefArmor = Configurations.gameplay.barbarianHordeDifficulty > 5 ? 16.0 : 8.0;
            mob.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(chiefArmor);
            mob.func_110148_a(MOB_ATTACK_DAMAGE).func_111128_a(attackDamage + 2.0);
        } else {
            double armor = (double)Configurations.gameplay.barbarianHordeDifficulty * 0.5;
            mob.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(armor);
        }
        mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(RaiderMobUtils.getHealthBasedOnRaidLevel(raidLevel));
        mob.func_70606_j(mob.func_110138_aP());
    }

    private static double getHealthBasedOnRaidLevel(int raidLevel) {
        return Math.max(15.0, (15.0 + (double)raidLevel * 0.2) * ((double)Configurations.gameplay.barbarianHordeDifficulty * 0.1));
    }

    public static void spawn(ResourceLocation entityToSpawn, int numberOfSpawns, BlockPos spawnLocation, World world, IColony colony, int eventID) {
        if (spawnLocation != null && entityToSpawn != null && world != null && numberOfSpawns > 0) {
            int x = spawnLocation.func_177958_n();
            int y = BlockPosUtil.getFloor(spawnLocation, world).func_177956_o();
            int z = spawnLocation.func_177952_p();
            double spawnDeviationX = 0.0;
            double spawnDeviationZ = 0.0;
            for (int i = 0; i < numberOfSpawns; ++i) {
                AbstractEntityMinecoloniesMob entity = (AbstractEntityMinecoloniesMob)EntityList.func_188429_b((ResourceLocation)entityToSpawn, (World)world);
                if (entity == null) continue;
                entity.func_70080_a((double)x + spawnDeviationX, (double)y + 1.0, (double)z + spawnDeviationZ, (float)MathHelper.func_76138_g((double)(world.field_73012_v.nextDouble() * 360.0)), 0.0f);
                CompatibilityUtils.spawnEntity(world, (Entity)entity);
                entity.setColony(colony);
                entity.setEventID(eventID);
                entity.registerWithColony();
                spawnDeviationZ += MOB_SPAWN_DEVIATION_STEPS;
                if (!(spawnDeviationZ > 2.0)) continue;
                spawnDeviationZ = 0.0;
                spawnDeviationX += MOB_SPAWN_DEVIATION_STEPS;
            }
        }
    }

    public static void setEquipment(AbstractEntityMinecoloniesMob mob) {
        if (mob instanceof IMeleeBarbarianEntity) {
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151049_t));
        } else if (mob instanceof IArcherMobEntity) {
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        } else if (mob instanceof IChiefBarbarianEntity) {
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.chiefSword));
            mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
            mob.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
            mob.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
            mob.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X));
        } else if (mob instanceof IPirateEntity) {
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.scimitar));
            if (mob instanceof ICaptainPirateEntity) {
                if (new Random().nextBoolean()) {
                    mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.pirateHelmet_1));
                    mob.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.pirateChest_1));
                    mob.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.pirateLegs_1));
                    mob.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.pirateBoots_1));
                } else {
                    mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModItems.pirateHelmet_2));
                    mob.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ModItems.pirateChest_2));
                    mob.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ModItems.pirateLegs_2));
                    mob.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ModItems.pirateBoots_2));
                }
            }
        }
    }

    public static List<AbstractEntityMinecoloniesMob> getBarbariansCloseToEntity(Entity entity, double distanceFromEntity) {
        return CompatibilityUtils.getWorldFromEntity(entity).func_175647_a(AbstractEntityMinecoloniesMob.class, entity.func_174813_aQ().func_72321_a(distanceFromEntity, 3.0, distanceFromEntity), Entity::func_70089_S);
    }
}

