/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.managers.interfaces;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICitizenManager {
    public void registerCitizen(AbstractEntityCitizen var1);

    public void unregisterCitizen(AbstractEntityCitizen var1);

    public void readFromNBT(@NotNull NBTTagCompound var1);

    public void writeToNBT(@NotNull NBTTagCompound var1);

    public void sendPackets(@NotNull Set<EntityPlayerMP> var1, @NotNull Set<EntityPlayerMP> var2);

    public void spawnOrCreateCitizen();

    @NotNull
    public Map<Integer, ICitizenData> getCitizenMap();

    public ICitizenData getCitizen(int var1);

    default public ICitizenData spawnOrCreateCitizen(ICitizenData data, @NotNull World world) {
        return this.spawnOrCreateCitizen(data, world, null, false);
    }

    default public ICitizenData spawnOrCreateCitizen(ICitizenData data, @NotNull World world, BlockPos spawnPos) {
        return this.spawnOrCreateCitizen(data, world, spawnPos, false);
    }

    public ICitizenData spawnOrCreateCitizen(ICitizenData var1, @NotNull World var2, BlockPos var3, boolean var4);

    public ICitizenData createAndRegisterNewCitizenData();

    public void removeCitizen(@NotNull ICitizenData var1);

    @Nullable
    public ICitizenData getJoblessCitizen();

    public void calculateMaxCitizens();

    public void markCitizensDirty();

    public void clearDirty();

    public List<ICitizenData> getCitizens();

    public int getMaxCitizens();

    public int getPotentialMaxCitizens();

    public int getCurrentCitizenCount();

    public void setMaxCitizens(int var1);

    public void setPotentialMaxCitizens(int var1);

    public void checkCitizensForHappiness();

    public void tickCitizenData();

    public void onColonyTick(IColony var1);

    public void updateCitizenMourn(boolean var1);
}

