/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.block.tileentity;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.darkhax.eplus.block.tileentity.TileEntityWithBook;
import net.darkhax.eplus.inventory.ItemStackHandlerEnchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityAdvancedTable
extends TileEntityWithBook {
    private final Map<UUID, ItemStackHandlerEnchant> inventories = new HashMap<UUID, ItemStackHandlerEnchant>();

    public ItemStackHandlerEnchant getInventory(EntityPlayer player) {
        ItemStackHandlerEnchant inventory = this.inventories.getOrDefault(player.getPersistentID(), new ItemStackHandlerEnchant((TileEntity)this));
        this.inventories.put(player.getPersistentID(), inventory);
        return inventory;
    }

    public Map<UUID, ItemStackHandlerEnchant> getInveotries() {
        return this.inventories;
    }

    public void writeNBT(NBTTagCompound dataTag) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, ItemStackHandlerEnchant> inventory : this.inventories.entrySet()) {
            NBTTagCompound invTag = new NBTTagCompound();
            invTag.func_186854_a("Owner", inventory.getKey());
            invTag.func_74782_a("Inventory", (NBTBase)inventory.getValue().serializeNBT());
            list.func_74742_a((NBTBase)invTag);
        }
        dataTag.func_74782_a("InvList", (NBTBase)list);
    }

    public void readNBT(NBTTagCompound dataTag) {
        this.inventories.clear();
        NBTTagList list = dataTag.func_150295_c("InvList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag == null) continue;
            UUID owner = tag.func_186857_a("Owner");
            ItemStackHandlerEnchant inv = new ItemStackHandlerEnchant((TileEntity)this);
            inv.deserializeNBT(tag.func_74775_l("Inventory"));
            this.inventories.put(owner, inv);
        }
    }
}

