/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.registry;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.entity.EntityLavaBall;
import net.tropicraft.core.common.entity.egg.EntitySeaTurtleEgg;
import net.tropicraft.core.common.entity.egg.EntitySeaUrchinEgg;
import net.tropicraft.core.common.entity.egg.EntityStarfishEgg;
import net.tropicraft.core.common.entity.egg.EntityTropiSpiderEgg;
import net.tropicraft.core.common.entity.hostile.EntityAshenHunter;
import net.tropicraft.core.common.entity.hostile.EntityEIH;
import net.tropicraft.core.common.entity.hostile.EntityIguana;
import net.tropicraft.core.common.entity.hostile.EntityLostMask;
import net.tropicraft.core.common.entity.hostile.EntityTreeFrog;
import net.tropicraft.core.common.entity.hostile.EntityTropiCreeper;
import net.tropicraft.core.common.entity.hostile.EntityTropiSkeleton;
import net.tropicraft.core.common.entity.hostile.EntityTropiSpider;
import net.tropicraft.core.common.entity.passive.EntityFailgull;
import net.tropicraft.core.common.entity.passive.EntityFishHook;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.passive.EntityVMonkey;
import net.tropicraft.core.common.entity.placeable.EntityBambooItemFrame;
import net.tropicraft.core.common.entity.placeable.EntityBeachFloat;
import net.tropicraft.core.common.entity.placeable.EntityChair;
import net.tropicraft.core.common.entity.placeable.EntityUmbrella;
import net.tropicraft.core.common.entity.placeable.EntityWallItem;
import net.tropicraft.core.common.entity.projectile.EntityCoconutGrenade;
import net.tropicraft.core.common.entity.projectile.EntityPoisonBlot;
import net.tropicraft.core.common.entity.underdasea.EntityManOWar;
import net.tropicraft.core.common.entity.underdasea.EntitySeaTurtle;
import net.tropicraft.core.common.entity.underdasea.EntitySeaUrchin;
import net.tropicraft.core.common.entity.underdasea.EntityStarfish;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityDolphin;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityEagleRay;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityHook;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityMarlin;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityPiranha;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityRiverSardine;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntitySeahorse;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityShark;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicalFish;

@Mod.EventBusSubscriber
public class EntityRegistry {
    private static int entityID = 0;
    private static ArrayList<String> registeredEntityNames = new ArrayList();
    private static ArrayList<Class<? extends Entity>> registeredEntityClasses = new ArrayList();

    @SubscribeEvent
    public static void init(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityEIH.class, "eih", 80, 3, true, EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityTropiCreeper.class, "tropicreeper", 80, 3, true, EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityIguana.class, "iguana", 80, 3, true, EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityTreeFrog.class, "treefrog", 80, 3, true, EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityTropiSkeleton.class, "tropiskelly", 80, 3, true, EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityVMonkey.class, "monkey", 80, 3, true, EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityPoisonBlot.class, "poisonblot", 32, 1, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityLavaBall.class, "lavaball", 120, 4, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityFailgull.class, "failgull", 80, 3, true, EntityLiving.SpawnPlacementType.IN_AIR);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityChair.class, "beach_chair", 120, 10, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityUmbrella.class, "beach_umbrella", 120, 10, false);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBeachFloat.class, "beach_float", 80, 3, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityCoconutGrenade.class, "coconut_bomb", 120, 5, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityAshenHunter.class, "ashen", 80, 3, true, EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityLostMask.class, "lost_mask", 64, 3, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityManOWar.class, "mow", 64, 3, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntitySeaUrchin.class, "seaurchin", 64, 3, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntitySeaUrchinEgg.class, "seaurchinegg", 64, 3, false);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityStarfish.class, "starfish", 64, 3, false, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityStarfishEgg.class, "starfishegg", 64, 3, false);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBambooItemFrame.class, "tc_item_frame", 64, 10, false);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityWallItem.class, "wall_item", 64, 10, false);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityKoaHunter.class, "koa", 64, 3, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntitySeaTurtleEgg.class, "sea_turtle_egg", 80, 5, false);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntitySeaTurtle.class, "turtle", 80, 1, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityTropicalFish.class, "fish", 80, 1, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntitySeahorse.class, "seahorse", 80, 1, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityEagleRay.class, "eagleray", 80, 1, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityMarlin.class, "marlin", 80, 1, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityPiranha.class, "piranha", 80, 1, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityRiverSardine.class, "sardine", 80, 1, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityDolphin.class, "dolphin", 80, 1, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityShark.class, "hammerhead", 80, 1, true, EntityLiving.SpawnPlacementType.IN_WATER);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityFishHook.class, "tropifishhook", 80, 1, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityHook.class, "tropihook", 80, 1, true);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityTropiSpider.class, "tropispider", 80, 3, true, EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityTropiSpiderEgg.class, "tropispideregg", 80, 5, false);
        if (TropicsConfigs.spawnPassiveTropicsLandMobsOverworld) {
            EntityRegistry.addSpawn(EntityDolphin.class, 5, 2, 5, EnumCreatureType.WATER_CREATURE, EntityRegistry.getOceanBiomes());
            EntityRegistry.addSpawn(EntitySeaTurtle.class, 10, 3, 6, EnumCreatureType.WATER_CREATURE, EntityRegistry.getOceanBiomes());
            EntityRegistry.addSpawn(EntityStarfish.class, 7, 2, 5, EnumCreatureType.WATER_CREATURE, EntityRegistry.getOceanBiomes());
            EntityRegistry.addSpawn(EntitySeaUrchin.class, 7, 2, 5, EnumCreatureType.WATER_CREATURE, EntityRegistry.getOceanBiomes());
        }
        if (TropicsConfigs.spawnHostileTropicsOceanMobsOverworld) {
            EntityRegistry.addSpawn(EntityShark.class, 1, 1, 1, EnumCreatureType.WATER_CREATURE, EntityRegistry.getOceanBiomes());
        }
        if (TropicsConfigs.spawnPassiveTropicsLandMobsOverworld) {
            EntityRegistry.addSpawn(EntityVMonkey.class, 5, 1, 4, EnumCreatureType.CREATURE, EntityRegistry.getJungleBiomes());
        }
        if (TropicsConfigs.spawnHostileTropicsLandMobsOverworld) {
            EntityRegistry.addSpawn(EntityEIH.class, 4, 4, 6, EnumCreatureType.CREATURE, EntityRegistry.getLandBiomes());
            EntityRegistry.addSpawn(EntityIguana.class, 8, 3, 7, EnumCreatureType.CREATURE, EntityRegistry.getLandBiomes());
        }
    }

    private static void addSpawn(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType creatureType, Biome ... biomes) {
        net.minecraftforge.fml.common.registry.EntityRegistry.addSpawn(entityClass, (int)weightedProb, (int)min, (int)max, (EnumCreatureType)creatureType, (Biome[])biomes);
    }

    private static void registerEntity(IForgeRegistry<EntityEntry> registry, Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        if (registeredEntityNames.contains(entityName) || registeredEntityClasses.contains(entityClass)) {
            EntityRegistry.notifyDuplicate(entityClass, entityName);
            return;
        }
        net.minecraftforge.fml.common.registry.EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("tropicraft:" + entityName), entityClass, (String)("tropicraft." + entityName), (int)entityID++, (Object)Tropicraft.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        registeredEntityNames.add(entityName);
        registeredEntityClasses.add(entityClass);
    }

    private static void registerEntity(IForgeRegistry<EntityEntry> registry, @Nonnull Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, @Nonnull EntityLiving.SpawnPlacementType spawnPlacementType) {
        EntityRegistry.registerEntity(registry, entityClass, entityName, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntitySpawnPlacementRegistry.setPlacementType(entityClass, (EntityLiving.SpawnPlacementType)spawnPlacementType);
    }

    private static void notifyDuplicate(Class<? extends Entity> clazz, String name) {
        System.err.println("Attempted to register duplicate entity: " + name + " : " + clazz.getSimpleName());
    }

    private static Biome[] getOceanBiomes() {
        return new Biome[]{Biomes.field_76771_b, Biomes.field_150575_M};
    }

    private static Biome[] getLandBiomes() {
        return new Biome[]{Biomes.field_76787_r, Biomes.field_76769_d, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_150589_Z, Biomes.field_150599_m, Biomes.field_150588_X, Biomes.field_76780_h};
    }

    private static Biome[] getJungleBiomes() {
        return new Biome[]{Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185446_X, Biomes.field_185447_Y};
    }
}

