/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.registry;

import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.tropicraft.Names;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.hostile.EntityTreeFrog;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.underdasea.EntitySeaTurtle;
import net.tropicraft.core.common.enums.AshenMasks;
import net.tropicraft.core.common.enums.TropicraftCorals;
import net.tropicraft.core.common.enums.TropicraftFlowers;
import net.tropicraft.core.common.enums.TropicraftSands;
import net.tropicraft.core.common.enums.TropicraftShells;
import net.tropicraft.core.encyclopedia.EntityPage;
import net.tropicraft.core.encyclopedia.ItemPage;
import net.tropicraft.core.encyclopedia.KoaPage;
import net.tropicraft.core.encyclopedia.LoveTropicsPage;
import net.tropicraft.core.encyclopedia.MultiEntityPage;
import net.tropicraft.core.encyclopedia.MultiItemPage;
import net.tropicraft.core.encyclopedia.SectionPage;
import net.tropicraft.core.encyclopedia.TropicalBook;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;
import net.tropicraft.core.registry.TropicraftRegistry;

public class EncyclopediaRegistry
extends TropicraftRegistry {
    public static void init() {
        TropicalBook enc = Tropicraft.encyclopedia;
        enc.addPage(new ItemPage("encyclopedia", new ItemStack(ItemRegistry.encyclopedia)));
        enc.addPage(new SectionPage("foods"));
        enc.addPage(new ItemPage("pineapple", new ItemStack(BlockRegistry.pineapple, 1, 0)));
        enc.addPage(new ItemPage("pineapplecubes", new ItemStack(ItemRegistry.pineappleCubes)));
        enc.addPage(new ItemPage("coconut", new ItemStack(BlockRegistry.coconut)));
        enc.addPage(new ItemPage("coconutchunks", new ItemStack(ItemRegistry.coconutChunk)));
        enc.addPage(new ItemPage("froglegs", new ItemStack(ItemRegistry.frogLeg)));
        enc.addPage(new ItemPage("froglegscooked", new ItemStack(ItemRegistry.cookedFrogLeg)));
        enc.addPage(new ItemPage("grapefruit", new ItemStack(ItemRegistry.grapefruit)));
        enc.addPage(new ItemPage("lemon", new ItemStack(ItemRegistry.lemon)));
        enc.addPage(new ItemPage("lime", new ItemStack(ItemRegistry.lime)));
        enc.addPage(new ItemPage("orange", new ItemStack(ItemRegistry.orange)));
        enc.addPage(new ItemPage("marlinmeat", new ItemStack(ItemRegistry.freshMarlin)));
        enc.addPage(new ItemPage("marlincooked", new ItemStack(ItemRegistry.searedMarlin)));
        enc.addPage(new ItemPage("seaurchinroe", new ItemStack(ItemRegistry.seaUrchinRoe)));
        enc.addPage(new ItemPage("rayraw", new ItemStack(ItemRegistry.rawRay)));
        enc.addPage(new ItemPage("raycooked", new ItemStack(ItemRegistry.cookedRay)));
        enc.addPage(new SectionPage("drinks"));
        enc.addPage(new ItemPage("mixer", new ItemStack(BlockRegistry.drinkMixer)));
        enc.addPage(new ItemPage("bamboomug", new ItemStack(ItemRegistry.bambooMug)));
        enc.addPage(new ItemPage("blackcoffee", MixerRecipes.getItemStack(Drink.blackCoffee)));
        enc.addPage(new ItemPage("caipirinha", MixerRecipes.getItemStack(Drink.caipirinha)));
        enc.addPage(new ItemPage("lemonade", MixerRecipes.getItemStack(Drink.lemonade)));
        enc.addPage(new ItemPage("limeade", MixerRecipes.getItemStack(Drink.limeade)));
        enc.addPage(new ItemPage("orangeade", MixerRecipes.getItemStack(Drink.orangeade)));
        enc.addPage(new ItemPage("pinacolada", MixerRecipes.getItemStack(Drink.pinaColada)));
        enc.addPage(new SectionPage("world"));
        enc.addPage(new ItemPage("azurite", new ItemStack(ItemRegistry.azurite)));
        enc.addPage(new ItemPage("zircon", new ItemStack(ItemRegistry.zircon)));
        enc.addPage(new ItemPage("eudialyte", new ItemStack(ItemRegistry.eudialyte)));
        for (TropicraftSands tropicraftSands : TropicraftSands.VALUES) {
            enc.addPage(new ItemPage(tropicraftSands.getSimpleName() + tropicraftSands.getTypeName(), tropicraftSands.makeStack(BlockRegistry.sands)));
        }
        enc.addPage(new SectionPage("tribes"));
        enc.addPage(new KoaPage(EntityKoaBase.Roles.FISHERMAN, new ItemStack((Item)Items.field_151112_aM)));
        enc.addPage(new KoaPage(EntityKoaBase.Roles.HUNTER, new ItemStack(ItemRegistry.dagger)));
        EncyclopediaRegistry.addEntityEggPage(enc, 9);
        enc.addPage(new MultiItemPage("ashenmask", (ItemStack[])Arrays.stream(AshenMasks.VALUES).map(v -> new ItemStack(ItemRegistry.maskMap.get(v))).toArray(ItemStack[]::new)));
        enc.addPage(new SectionPage("mobs.land"));
        EncyclopediaRegistry.addEntityEggPage(enc, 0);
        enc.addPage(new MultiEntityPage("treefrog", (ItemStack[])IntStream.range(2, 6).mapToObj(d -> new ItemStack(ItemRegistry.mobEgg, 1, d)).toArray(ItemStack[]::new)){

            @Override
            @Nonnull
            protected EntityLivingBase[] makeVariants() {
                EntityTreeFrog[] ret = new EntityTreeFrog[4];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = (EntityTreeFrog)this.makeEntity();
                    ret[i].setType(i);
                }
                return ret;
            }
        });
        EncyclopediaRegistry.addEntityEggPage(enc, 6);
        EncyclopediaRegistry.addEntityEggPage(enc, 12);
        EncyclopediaRegistry.addEntityEggPage(enc, 14);
        EncyclopediaRegistry.addEntityEggPage(enc, 15);
        EncyclopediaRegistry.addEntityEggPage(enc, 17);
        EncyclopediaRegistry.addEntityEggPage(enc, 24);
        enc.addPage(new SectionPage("mobs.water"));
        EncyclopediaRegistry.addEntityEggPage(enc, 1);
        EncyclopediaRegistry.addEntityEggPage(enc, 7);
        EncyclopediaRegistry.addEntityEggPage(enc, 8);
        enc.addPage(new EntityPage("turtle", new ItemStack(ItemRegistry.mobEgg, 1, 10)){

            @Override
            protected EntityLivingBase makeEntity() {
                EntitySeaTurtle ret = (EntitySeaTurtle)super.makeEntity();
                ret.setMature();
                return ret;
            }
        });
        EncyclopediaRegistry.addEntityEggPage(enc, 11);
        EncyclopediaRegistry.addEntityEggPage(enc, 16);
        EncyclopediaRegistry.addEntityEggPage(enc, 18);
        EncyclopediaRegistry.addEntityEggPage(enc, 19);
        EncyclopediaRegistry.addEntityEggPage(enc, 20);
        EncyclopediaRegistry.addEntityEggPage(enc, 21);
        EncyclopediaRegistry.addEntityEggPage(enc, 22);
        EncyclopediaRegistry.addEntityEggPage(enc, 23);
        enc.addPage(new SectionPage("tools"));
        enc.addPage(new ItemPage("dagger", new ItemStack(ItemRegistry.dagger)));
        enc.addPage(new ItemPage("bamboospear", new ItemStack(ItemRegistry.bambooSpear)));
        enc.addPage(new ItemPage("fishingrod", new ItemStack(ItemRegistry.fishingRod)));
        enc.addPage(new ItemPage("waterwand", new ItemStack(ItemRegistry.waterWand)));
        enc.addPage(new ItemPage("portalstarter", new ItemStack(ItemRegistry.portalEnchanter)));
        enc.addPage(new ItemPage("fishingnet", new ItemStack(ItemRegistry.fishingNet)));
        enc.addPage(new ItemPage("fishbucket", new ItemStack(ItemRegistry.fishBucket)));
        enc.addPage(new SectionPage("armor"));
        enc.addPage(new ItemPage("firehelm", new ItemStack(ItemRegistry.fireHelmet)));
        enc.addPage(new ItemPage("firechestplate", new ItemStack(ItemRegistry.fireChestplate)));
        enc.addPage(new ItemPage("fireleggings", new ItemStack(ItemRegistry.fireLeggings)));
        enc.addPage(new ItemPage("fireboots", new ItemStack(ItemRegistry.fireBoots)));
        enc.addPage(new ItemPage("scalehelm", new ItemStack(ItemRegistry.scaleHelmet)));
        enc.addPage(new ItemPage("scaleleggings", new ItemStack(ItemRegistry.scaleLeggings)));
        enc.addPage(new ItemPage("scalechestplate", new ItemStack(ItemRegistry.scaleChestplate)));
        enc.addPage(new ItemPage("scaleboots", new ItemStack(ItemRegistry.scaleBoots)));
        enc.addPage(new SectionPage("scuba"));
        enc.addPage(new MultiItemPage("scubaflippers", new ItemStack(ItemRegistry.pinkFlippers), new ItemStack(ItemRegistry.yellowFlippers)));
        enc.addPage(new MultiItemPage("scubachestplate", new ItemStack(ItemRegistry.pinkChestplateGear), new ItemStack(ItemRegistry.yellowChestplateGear)));
        enc.addPage(new MultiItemPage("scubagoggles", new ItemStack(ItemRegistry.pinkScubaGoggles), new ItemStack(ItemRegistry.yellowScubaGoggles)));
        enc.addPage(new ItemPage("divecomputer", new ItemStack(ItemRegistry.diveComputer)));
        enc.addPage(new MultiItemPage("weightbelt", new ItemStack(ItemRegistry.yellowWeightBelt), new ItemStack(ItemRegistry.pinkWeightBelt)));
        enc.addPage(new MultiItemPage("ponybottle", new ItemStack(ItemRegistry.yellowPonyBottle), new ItemStack(ItemRegistry.pinkPonyBottle)));
        enc.addPage(new MultiItemPage("bcd", new ItemStack(ItemRegistry.pinkBCD), new ItemStack(ItemRegistry.yellowBCD)));
        enc.addPage(new MultiItemPage("regulator", new ItemStack(ItemRegistry.yellowRegulator), new ItemStack(ItemRegistry.pinkRegulator)));
        enc.addPage(new MultiItemPage("scubatank", new ItemStack(ItemRegistry.pinkScubaTank), new ItemStack(ItemRegistry.yellowScubaTank)));
        enc.addPage(new ItemPage("trimix", new ItemStack(ItemRegistry.trimix)));
        enc.addPage(new SectionPage("beach_accessories"));
        enc.addPage(new MultiItemPage("beachchair", (ItemStack[])IntStream.range(0, 16).mapToObj(i -> new ItemStack((Item)ItemRegistry.chair, 1, i)).toArray(ItemStack[]::new)));
        enc.addPage(new MultiItemPage("beachfloat", (ItemStack[])IntStream.range(0, 16).mapToObj(i -> new ItemStack((Item)ItemRegistry.beach_float, 1, i)).toArray(ItemStack[]::new)));
        enc.addPage(new MultiItemPage("beachumbrella", (ItemStack[])IntStream.range(0, 16).mapToObj(i -> new ItemStack((Item)ItemRegistry.umbrella, 1, i)).toArray(ItemStack[]::new)));
        enc.addPage(new SectionPage("nature"));
        enc.addPage(new ItemPage("reeds", new ItemStack(Items.field_151120_aE)));
        enc.addPage(new ItemPage("bamboo", new ItemStack((Block)BlockRegistry.bambooShoot)));
        enc.addPage(new ItemPage("coffeebean", new ItemStack(ItemRegistry.coffeeBeans, 1, 0)));
        enc.addPage(new MultiItemPage("coral", (ItemStack[])Arrays.stream(TropicraftCorals.VALUES).map(v -> new ItemStack(BlockRegistry.coral, 1, v.getMeta())).toArray(ItemStack[]::new)));
        enc.addPage(new ItemPage("kapok", new ItemStack(BlockRegistry.leaves, 1, 2)));
        enc.addPage(new ItemPage("mahogany", new ItemStack(BlockRegistry.logs, 1, 1)));
        enc.addPage(new ItemPage("lemonsapling", new ItemStack(BlockRegistry.saplings, 1, 2)));
        enc.addPage(new ItemPage("limesapling", new ItemStack(BlockRegistry.saplings, 1, 4)));
        enc.addPage(new ItemPage("orangesapling", new ItemStack(BlockRegistry.saplings, 1, 3)));
        enc.addPage(new ItemPage("grapefruitsapling", new ItemStack(BlockRegistry.saplings, 1, 1)));
        enc.addPage(new ItemPage("palmsapling", new ItemStack(BlockRegistry.saplings, 1, 0)));
        enc.addPage(new ItemPage("palmwood", new ItemStack(BlockRegistry.logs, 1, 0)));
        enc.addPage(new SectionPage("decor"));
        enc.addPage(new ItemPage("palmplanks", new ItemStack(BlockRegistry.planks, 1, 0)));
        enc.addPage(new ItemPage("palmfence", new ItemStack(BlockRegistry.palmFence)));
        enc.addPage(new ItemPage("palmfencegate", new ItemStack((Block)BlockRegistry.palmFenceGate)));
        enc.addPage(new ItemPage("mahoganyfence", new ItemStack(BlockRegistry.mahoganyFence)));
        enc.addPage(new ItemPage("mahoganyfencegate", new ItemStack((Block)BlockRegistry.mahoganyFenceGate)));
        enc.addPage(new ItemPage("bambooblock", new ItemStack(BlockRegistry.bundles, 1, 1)));
        enc.addPage(new ItemPage("bamboochest", new ItemStack(BlockRegistry.bambooChest)));
        enc.addPage(new ItemPage("bamboodoor", new ItemStack(ItemRegistry.bambooDoor)));
        enc.addPage(new ItemPage("bamboofence", new ItemStack(BlockRegistry.bambooFence)));
        enc.addPage(new ItemPage("bamboofencegate", new ItemStack((Block)BlockRegistry.bambooFenceGate)));
        enc.addPage(new ItemPage("bamboostick", new ItemStack(ItemRegistry.bambooStick)));
        enc.addPage(new ItemPage("bamboo_ladder", new ItemStack(BlockRegistry.bambooLadder)));
        enc.addPage(new ItemPage("tropiframe", new ItemStack(ItemRegistry.bambooItemFrame)));
        enc.addPage(new ItemPage("chunkohead", new ItemStack(BlockRegistry.chunk)));
        enc.addPage(new ItemPage("chunkfence", new ItemStack(BlockRegistry.chunkFence)));
        enc.addPage(new ItemPage("chunkfencegate", new ItemStack((Block)BlockRegistry.chunkFenceGate)));
        enc.addPage(new ItemPage("tikitorch", new ItemStack(BlockRegistry.tikiTorch)));
        enc.addPage(new ItemPage("thatchblock", new ItemStack(BlockRegistry.bundles, 1, 0)));
        enc.addPage(new ItemPage("thatchfence", new ItemStack(BlockRegistry.thatchFence)));
        enc.addPage(new ItemPage("thatchfencegate", new ItemStack((Block)BlockRegistry.thatchFenceGate)));
        enc.addPage(new SectionPage("flowers"));
        for (Enum enum_ : TropicraftFlowers.VALUES) {
            enc.addPage(new ItemPage(enum_.getSimpleName(), enum_.makeStack((Block)BlockRegistry.flowers)));
        }
        enc.addPage(new ItemPage("flowerpot", new ItemStack(ItemRegistry.flowerPot)));
        enc.addPage(new SectionPage("shells"));
        for (Enum enum_ : TropicraftShells.values()) {
            enc.addPage(new ItemPage(enum_.getSimpleName() + ((TropicraftShells)enum_).getTypeName(), enum_.makeStack(ItemRegistry.shell)));
        }
        enc.addPage(new ItemPage("pearlb", new ItemStack(ItemRegistry.blackPearl)));
        enc.addPage(new ItemPage("pearlw", new ItemStack(ItemRegistry.whitePearl)));
        enc.addPage(new SectionPage("music"));
        enc.addPage(new ItemPage("easternisles", new ItemStack(ItemRegistry.recordEasternIsles)));
        enc.addPage(new ItemPage("summering", new ItemStack(ItemRegistry.recordSummering)));
        enc.addPage(new ItemPage("thetribe", new ItemStack(ItemRegistry.recordTheTribe)));
        enc.addPage(new ItemPage("tradewinds", new ItemStack(ItemRegistry.recordTradeWinds)));
        enc.addPage(new ItemPage("lowtide", new ItemStack(ItemRegistry.recordLowTide)));
        enc.addPage(new SectionPage("misc"));
        enc.addPage(new ItemPage("coconutbomb", new ItemStack(ItemRegistry.coconutBomb)));
        enc.addPage(new ItemPage("fertilizer", new ItemStack(ItemRegistry.fertilizer)));
        enc.addPage(new ItemPage("frogskin", new ItemStack(ItemRegistry.poisonFrogSkin)));
        enc.addPage(new ItemPage("iggyscale", new ItemStack(ItemRegistry.scale)));
        enc.addPage(new ItemPage("iguana_leather", new ItemStack(ItemRegistry.iguanaLeather)));
        enc.addPage(new ItemPage("sifter", new ItemStack(BlockRegistry.sifter)));
        enc.addPage(new SectionPage("lovetropics"));
        enc.addPage(new LoveTropicsPage("ltinfo"));
        enc.addPage(new LoveTropicsPage.Names("lt17", Names.LT17_NAMES));
        enc.addPage(new LoveTropicsPage.Names("lt18", Names.LT18_NAMES));
        enc.dumpSections();
    }

    private static void addEntityEggPage(TropicalBook book, int id) {
        book.addPage(new EntityPage(Names.EGG_NAMES[id], new ItemStack(ItemRegistry.mobEgg, 1, id)));
    }
}

