/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.encyclopedia;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;

public class RecipeEntry {
    private final int width;
    private final int height;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;

    public RecipeEntry(int width, int height, NonNullList<Ingredient> items, ItemStack output) {
        this.width = width;
        this.height = height;
        this.ingredients = items;
        while (this.ingredients.size() < width * height) {
            this.ingredients.add((Object)Ingredient.field_193370_a);
        }
        this.output = output;
    }

    @Nonnull
    public ItemStack getCycledStack(int index, float cycle) {
        if (index >= this.ingredients.size() || index < 0) {
            return ItemStack.field_190927_a;
        }
        Ingredient ing = (Ingredient)this.ingredients.get(index);
        int i = MathHelper.func_76141_d((float)(cycle / 30.0f));
        ItemStack[] stacks = ing.func_193365_a();
        if (i < 0 || stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = stacks[i % stacks.length];
        if (ret == null) {
            ret = ItemStack.field_190927_a;
        }
        return ret;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

