/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.encyclopedia;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.encyclopedia.RecipeEntry;

@ParametersAreNonnullByDefault
public interface Page {
    public String getId();

    @SideOnly(value=Side.CLIENT)
    public void drawHeader(int var1, int var2, float var3, float var4, float var5);

    @SideOnly(value=Side.CLIENT)
    public void drawIcon(int var1, int var2, float var3);

    public int getHeaderHeight();

    default public String getTitle() {
        return "tropicraft.encyclopedia." + this.getId() + ".title";
    }

    @SideOnly(value=Side.CLIENT)
    default public String getLocalizedTitle() {
        return I18n.func_135052_a((String)this.getTitle(), (Object[])new Object[0]);
    }

    default public String getDescription() {
        return "tropicraft.encyclopedia." + this.getId() + ".desc";
    }

    @SideOnly(value=Side.CLIENT)
    default public String getLocalizedDescription() {
        return I18n.func_188566_a((String)this.getDescription()) ? "  " + I18n.func_135052_a((String)this.getDescription(), (Object[])new Object[0]) : "???";
    }

    default public boolean isBookmark() {
        return false;
    }

    default public boolean hasContent() {
        return !this.isBookmark();
    }

    default public boolean hasIcon() {
        return !this.isBookmark();
    }

    public List<RecipeEntry> getRelevantRecipes();

    public boolean discover(World var1, EntityPlayer var2);
}

