/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.encyclopedia;

import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.encyclopedia.MultiEntityPage;
import net.tropicraft.core.registry.ItemRegistry;

@ParametersAreNonnullByDefault
public class KoaPage
extends MultiEntityPage {
    private final EntityKoaBase.Roles role;
    private final ItemStack inHand;

    public KoaPage(EntityKoaBase.Roles role, ItemStack inHand) {
        super("koa." + role.toString().toLowerCase(Locale.ROOT), new ResourceLocation("tropicraft", "koa"), new ItemStack[]{inHand});
        this.role = role;
        this.inHand = inHand;
    }

    @Override
    public void drawIcon(int x, int y, float cycle) {
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack(ItemRegistry.mobEgg, 1, 13), x, y);
        Minecraft.func_71410_x().func_175599_af().func_175042_a(this.inHand, x, y);
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    @Override
    protected EntityLivingBase[] makeVariants() {
        EntityKoaBase.Genders[] genders = EntityKoaBase.Genders.values();
        EntityLivingBase[] ret = new EntityLivingBase[genders.length];
        for (int i = 0; i < genders.length; ++i) {
            ret[i] = this.makeEntity();
            if (ret[i] == null) continue;
            ((EntityKoaBase)ret[i]).setGender(genders[i]);
            ret[i].func_184201_a(EntityEquipmentSlot.MAINHAND, this.inHand);
        }
        return ret;
    }

    @Override
    public boolean discover(World world, EntityPlayer player) {
        Vec3d pos = player.func_174791_d();
        List inRange = world.func_72872_a(EntityKoaBase.class, new AxisAlignedBB(pos.func_72441_c(-5.0, -5.0, -5.0), pos.func_72441_c(5.0, 5.0, 5.0)));
        return inRange.stream().filter(e -> e.getRole() == this.role).count() > 0L;
    }
}

