/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen.village;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.build.world.BuildDirectionHelper;
import net.tropicraft.core.common.capability.WorldDataInstance;
import net.tropicraft.core.common.town.ManagedLocation;
import net.tropicraft.core.common.worldgen.village.TownKoaVillage;

public class TownKoaVillageGenHelper {
    public static int areaLength = 76;
    public static int areaWidth = 86;
    public static int areaHeight = 16;
    public static boolean debugVillageGen = false;

    public static boolean hookTryGenVillage(BlockPos parCoords, World parWorld) {
        int directionTry = TownKoaVillageGenHelper.getBestGenDirection(parCoords, parWorld);
        if (directionTry != -1) {
            TownKoaVillageGenHelper.dbg("test success! dir: " + directionTry);
            BlockPos centerCoords = TownKoaVillageGenHelper.getCoordsFromAdjustedDirection(parCoords, directionTry);
            TownKoaVillageGenHelper.dbg("centerCoords: " + centerCoords);
            centerCoords = new BlockPos(centerCoords.func_177958_n(), 64, centerCoords.func_177952_p());
            TownKoaVillage village = new TownKoaVillage();
            WorldDataInstance storage = (WorldDataInstance)parWorld.getCapability(Tropicraft.WORLD_DATA_INSTANCE, null);
            if (storage != null) {
                int minDistBetweenVillages = 512;
                for (ManagedLocation managedLocation : storage.lookupTickingManagedLocations.values()) {
                    if (!(Math.sqrt(managedLocation.spawn.func_177951_i((Vec3i)parCoords)) < (double)minDistBetweenVillages)) continue;
                    return false;
                }
                int n = storage.getAndIncrementKoaIDVillage();
                village.initData(n, parWorld.field_73011_w.getDimension(), centerCoords);
                village.direction = directionTry;
                village.initFirstTime();
                village.genStructure();
                storage.addTickingLocation(village);
                return true;
            }
        }
        return false;
    }

    public static int getBestGenDirection(BlockPos parCoords, World parWorld) {
        if (TownKoaVillageGenHelper.isClear(parCoords, parWorld, 1, 0)) {
            return 0;
        }
        if (TownKoaVillageGenHelper.isClear(parCoords, parWorld, 0, -1)) {
            return 1;
        }
        if (TownKoaVillageGenHelper.isClear(parCoords, parWorld, -1, 0)) {
            return 2;
        }
        if (TownKoaVillageGenHelper.isClear(parCoords, parWorld, 0, 1)) {
            return 3;
        }
        return -1;
    }

    public static boolean isClear(BlockPos parCoords, World parWorld, int scanX, int scanZ) {
        int sizeHorizMax = areaWidth;
        int sizeMiddle = areaWidth / 2;
        int topYBeach = 63;
        IBlockState state = parWorld.func_180495_p(new BlockPos(parCoords.func_177958_n(), topYBeach, parCoords.func_177952_p()));
        Block blockScanBeach = state.func_177230_c();
        if (state.func_185904_a() == Material.field_151595_p) {
            int topYMiddle = 63;
            IBlockState state2 = parWorld.func_180495_p(new BlockPos(parCoords.func_177958_n() + sizeMiddle * scanX, topYMiddle, parCoords.func_177952_p() + sizeMiddle * scanZ));
            Block blockScanMiddle = state2.func_177230_c();
            if (state2.func_185904_a() == Material.field_151586_h) {
                IBlockState state3 = parWorld.func_180495_p(new BlockPos(parCoords.func_177958_n() + sizeHorizMax * scanX, topYMiddle, parCoords.func_177952_p() + sizeHorizMax * scanZ));
                Block blockScanEnd = state3.func_177230_c();
                if (state3.func_185904_a() == Material.field_151586_h) {
                    int steps = 16;
                    for (int out = 10; out <= areaWidth - 10; ++out) {
                        int side = 10;
                        while (side <= areaLength / 2 - 10) {
                            int outStep = out;
                            int sideStep = side++;
                            int x = outStep * scanX + sideStep * scanZ;
                            int z = outStep * scanZ + sideStep * scanX;
                            int x2 = outStep * scanX + sideStep * scanZ * -1;
                            int z2 = outStep * scanZ + sideStep * scanX * -1;
                            IBlockState stateCheckOutLeft = parWorld.func_180495_p(new BlockPos(parCoords.func_177958_n() + x, topYMiddle, parCoords.func_177952_p() + z));
                            IBlockState stateCheckOutRight = parWorld.func_180495_p(new BlockPos(parCoords.func_177958_n() + x2, topYMiddle, parCoords.func_177952_p() + z2));
                            if (stateCheckOutLeft.func_185904_a() == Material.field_151586_h && stateCheckOutRight.func_185904_a() == Material.field_151586_h) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static BlockPos getCoordsFromAdjustedDirection(BlockPos parCoords, int parDirection) {
        return new BlockPos(parCoords.func_177958_n() + areaWidth / 2 * BuildDirectionHelper.getDirectionToCoords(parDirection).func_177958_n(), parCoords.func_177956_o(), parCoords.func_177952_p() + areaWidth / 2 * BuildDirectionHelper.getDirectionToCoords(parDirection).func_177952_p());
    }

    public static void dbg(String str) {
        if (debugVillageGen) {
            System.out.println(str);
        }
    }
}

