/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSurfaceClump
extends WorldGenerator {
    private final float chance;
    private final int range;
    private final double maxDistanceSq;
    private final Predicate<IBlockState> bottomBlock;
    private final Predicate<IBlockState> topBlock;
    private final Function<Random, IBlockState> stateFunc;
    private final boolean replaceBottom;

    public WorldGenSurfaceClump(float chance, int range, Predicate<IBlockState> bottomBlock, Predicate<IBlockState> topBlock, Function<Random, IBlockState> stateFunc, boolean replaceBottom) {
        this.chance = chance;
        this.range = range;
        this.maxDistanceSq = range * range + range * range;
        this.bottomBlock = bottomBlock;
        this.topBlock = topBlock;
        this.stateFunc = stateFunc;
        this.replaceBottom = replaceBottom;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        boolean ret = false;
        if (rand.nextFloat() < this.chance) {
            BlockPos center = position.func_177982_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8);
            int range = rand.nextInt(this.range + 1);
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)center.func_177982_a(-range, 0, -range), (BlockPos)center.func_177982_a(range, 0, range))) {
                BlockPos toPlace;
                double chance = Math.pow(MathHelper.func_151237_a((double)((this.maxDistanceSq - pos.func_177951_i((Vec3i)center)) / this.maxDistanceSq), (double)0.0, (double)1.0), 2.0);
                if (!(rand.nextDouble() < chance) || !this.canPlaceBlock(worldIn, toPlace = worldIn.func_175672_r(pos))) continue;
                this.func_175903_a(worldIn, this.replaceBottom ? toPlace.func_177977_b() : toPlace, this.stateFunc.apply(rand));
                ret = true;
            }
        }
        return ret;
    }

    protected boolean canPlaceBlock(World world, BlockPos pos) {
        return this.bottomBlock.test(world.func_180495_p(pos.func_177977_b())) && this.topBlock.test(world.func_180495_p(pos));
    }
}

