/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tropicraft.core.common.item.scuba.api.IScubaGear;
import net.tropicraft.core.common.item.scuba.api.IScubaTank;

public class ScubaCapabilities {
    @CapabilityInject(value=IScubaTank.class)
    @Nonnull
    private static Capability<IScubaTank> tankCapability;
    @CapabilityInject(value=IScubaGear.class)
    @Nonnull
    private static Capability<IScubaGear> gearCapability;

    @Nonnull
    public static Capability<IScubaTank> getTankCapability() {
        return tankCapability;
    }

    @Nonnull
    public static Capability<IScubaGear> getGearCapability() {
        return gearCapability;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IScubaTank.class, (Capability.IStorage)new Capability.IStorage<IScubaTank>(){

            public NBTBase writeNBT(Capability<IScubaTank> capability, IScubaTank instance, EnumFacing side) {
                System.out.println("Writing to scuba tank nbt");
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IScubaTank> capability, IScubaTank instance, EnumFacing side, NBTBase nbt) {
                System.out.println("Reading from scuba tank nbt");
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, IScubaTank.ScubaTank::new);
        CapabilityManager.INSTANCE.register(IScubaGear.class, (Capability.IStorage)new Capability.IStorage<IScubaGear>(){

            public NBTBase writeNBT(Capability<IScubaGear> capability, IScubaGear instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IScubaGear> capability, IScubaGear instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, IScubaGear.ScubaGear::new);
    }

    public static <C> ICapabilityProvider getProvider(final Capability<C> cap, final Supplier<C> factory) {
        return new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == cap;
            }

            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(this.hasCapability(capability, facing) ? cap.cast(factory.get()) : null);
            }
        };
    }
}

