/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tropicraft.core.common.item.scuba.ItemScubaHelmet;
import net.tropicraft.core.common.item.scuba.ScubaHelper;

public class ItemDiveComputer
extends ItemMap {
    public static final int UPDATE_RATE = 20;
    public int ticksUntilUpdate = 20;
    private static String tagDiveTime = "DiveTime";

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K) {
            return;
        }
        if (this.ticksUntilUpdate <= 0) {
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            if (!ScubaHelper.isFullyUnderwater(world, player)) {
                return;
            }
            ItemStack helmetStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack chestplateStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack leggingsStack = player.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack flippersStack = player.func_184582_a(EntityEquipmentSlot.FEET);
            this.addDiveTime(itemstack, 1L);
            if (helmetStack != null && helmetStack.func_77973_b() instanceof ItemScubaHelmet) {
                int waterBlocksAbove = 0;
                int waterBlocksBelow = 0;
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int y = MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.field_70131_O - 0.5));
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                while (world.func_180495_p(new BlockPos(x, y + waterBlocksAbove + 1, z)).func_185904_a().func_76224_d()) {
                    ++waterBlocksAbove;
                }
                while (world.func_180495_p(new BlockPos(x, y - waterBlocksBelow - 1, z)).func_185904_a().func_76224_d()) {
                    ++waterBlocksBelow;
                }
                NBTTagCompound tag = this.getTagCompound(helmetStack);
                tag.func_74768_a("WaterBlocksAbove", waterBlocksAbove);
                tag.func_74768_a("WaterBlocksBelow", waterBlocksBelow);
                if (waterBlocksAbove > tag.func_74762_e("MaxDepth") || tag.func_74762_e("MaxDepth") == 0) {
                    tag.func_74768_a("MaxDepth", waterBlocksAbove);
                }
            }
            this.ticksUntilUpdate = 20;
        } else {
            --this.ticksUntilUpdate;
        }
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public long getDiveTime(ItemStack stack) {
        return this.getTagCompound(stack).func_74763_f(tagDiveTime);
    }

    public void setDiveTime(ItemStack stack, long val) {
        NBTTagCompound nbt = this.getTagCompound(stack);
        nbt.func_74772_a(tagDiveTime, val);
    }

    public void addDiveTime(ItemStack stack, long val) {
        NBTTagCompound nbt = this.getTagCompound(stack);
        nbt.func_74772_a(tagDiveTime, nbt.func_74763_f(tagDiveTime) + val);
    }
}

