/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.armor;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.item.armor.ItemTropicraftArmor;
import net.tropicraft.core.registry.ItemRegistry;

public class ItemFireArmor
extends ItemTropicraftArmor {
    public ItemFireArmor(ItemArmor.ArmorMaterial material, int renderIndex, EntityEquipmentSlot slot) {
        super(material, renderIndex, slot);
        this.func_77656_e(300);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            this.clientTick(player);
        } else {
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
            int factor = (int)(40.0 / (0.001 + (double)world.getSunBrightnessFactor(1.0f)));
            if (world.func_72820_D() % (long)factor == 0L && world.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + 1.0)), MathHelper.func_76128_c((double)player.field_70161_v)))) {
                itemStack.func_77972_a(-1, (EntityLivingBase)player);
            }
        }
    }

    @Override
    public void damageArmor(EntityLivingBase player, ItemStack stack, DamageSource source, int damage, int slot) {
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76371_c) {
            stack.func_77972_a(damage, player);
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76371_c) {
            return new ISpecialArmor.ArmorProperties(10, 1.0, Integer.MAX_VALUE);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @SideOnly(value=Side.CLIENT)
    public void clientTick(EntityPlayer player) {
        int particleSetting;
        if (player.func_70090_H()) {
            return;
        }
        float range = 0.2f;
        float speed = 0.08f;
        Random rand = new Random();
        World worldRef = player.field_70170_p;
        int extraRand = 0;
        double plSpeed = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y);
        if (plSpeed < (double)0.1f) {
            extraRand = 7;
        }
        if ((particleSetting = Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 2) {
            return;
        }
        if (this == ItemRegistry.fireBoots) {
            IBlockState block2;
            IBlockState state;
            boolean onLava = false;
            boolean inLava = false;
            boolean x = false;
            boolean z = false;
            if (player.field_70181_x < 0.0 && (state = player.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(player.field_70165_t + (double)x)), MathHelper.func_76128_c((double)(player.field_70163_u - 2.0)), MathHelper.func_76128_c((double)(player.field_70161_v + (double)z))))) != null && state.func_185904_a() == Material.field_151587_i) {
                onLava = true;
            }
            if ((block2 = player.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(player.field_70165_t + (double)x)), MathHelper.func_76128_c((double)(player.field_70163_u - 1.0)), MathHelper.func_76128_c((double)(player.field_70161_v + (double)z))))) != null && block2.func_185904_a() == Material.field_151587_i) {
                inLava = true;
            }
            if (onLava && !inLava) {
                player.field_70181_x = 0.0;
                player.field_70122_E = true;
            }
            if (inLava && plSpeed < 0.4) {
                player.field_70159_w *= 1.5;
                player.field_70181_x *= 1.5;
                player.field_70179_y *= 1.5;
            }
            float look = player.field_70170_p.func_72820_D() * (long)(10 + (onLava ? 10 : 0));
            double dist = 1.0;
            double gatherX = player.field_70165_t;
            double gatherY = player.func_174813_aQ().field_72338_b;
            double gatherZ = player.field_70161_v;
            double motionX = rand.nextFloat() * speed - speed / 2.0f;
            double motionZ = rand.nextFloat() * speed - speed / 2.0f;
            int numFeetParticles = particleSetting == 1 ? 2 : 11;
            for (int i = 0; i < numFeetParticles + (onLava ? 5 : 0); ++i) {
                motionX = -Math.sin(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.nextDouble());
                motionZ = Math.cos(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.nextDouble());
                EnumParticleTypes particle = EnumParticleTypes.FLAME;
                if (rand.nextInt(22) == 0) {
                    particle = EnumParticleTypes.SMOKE_LARGE;
                }
                if (!onLava && rand.nextInt(1 + extraRand) != 0) continue;
                player.field_70170_p.func_175688_a(particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), gatherY + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), player.field_70159_w + motionX, (double)0.01f, player.field_70179_y + motionZ, new int[0]);
                player.field_70170_p.func_175688_a(particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), gatherY + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), player.field_70159_w - motionX, (double)0.01f, player.field_70179_y - motionZ, new int[0]);
            }
        } else if (this == ItemRegistry.fireLeggings) {
            EnumParticleTypes particle = EnumParticleTypes.FLAME;
            if (rand.nextInt(2) == 0) {
                particle = EnumParticleTypes.SMOKE_LARGE;
            }
            if (rand.nextInt(3 + extraRand) == 0) {
                player.field_70170_p.func_175688_a(particle, player.field_70165_t + (double)(rand.nextFloat() * range - range / 2.0f), player.field_70163_u - (double)0.8f + (double)(rand.nextFloat() * range - range / 2.0f), player.field_70161_v + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.05f, (double)(rand.nextFloat() * speed - speed / 2.0f), new int[0]);
            }
        } else if (this == ItemRegistry.fireChestplate) {
            float look = -180.0f;
            double dist = 0.5;
            double gatherX = player.field_70165_t + -Math.sin((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI) * dist;
            double gatherZ = player.field_70161_v + Math.cos((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI) * dist;
            EnumParticleTypes particle = EnumParticleTypes.FLAME;
            if (rand.nextInt(2) == 0) {
                particle = EnumParticleTypes.SMOKE_LARGE;
            }
            if (rand.nextInt(1 + extraRand) == 0) {
                player.field_70170_p.func_175688_a(particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), player.field_70163_u - (double)0.4f + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.01f, (double)(rand.nextFloat() * speed - speed / 2.0f), new int[0]);
            }
        } else if (this == ItemRegistry.fireHelmet) {
            float look = -180.0f;
            double dist = 0.5;
            range = 2.0f;
            double gatherX = player.field_70165_t + -Math.sin((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI) * dist;
            double gatherZ = player.field_70161_v + Math.cos((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI) * dist;
            EnumParticleTypes particle = EnumParticleTypes.FLAME;
            if (rand.nextInt(2) == 0) {
                particle = EnumParticleTypes.SMOKE_LARGE;
            }
            if (rand.nextInt(2) == 0) {
                player.field_70170_p.func_175688_a(particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), player.field_70163_u + (double)0.7f, gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.01f, (double)(rand.nextFloat() * speed - speed / 2.0f), new int[0]);
            }
        }
    }
}

