/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.tropicraft.core.common.entity.egg.EntityEgg;
import net.tropicraft.core.common.entity.egg.EntityStarfishEgg;
import net.tropicraft.core.common.entity.underdasea.EntityEchinoderm;
import net.tropicraft.core.common.entity.underdasea.StarfishType;
import net.tropicraft.core.common.enums.TropicraftShells;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityStarfish
extends EntityEchinoderm
implements IEntityAdditionalSpawnData {
    public static final float BABY_WIDTH = 0.25f;
    public static final float ADULT_WIDTH = 1.0f;
    public static final float BABY_HEIGHT = 0.1f;
    public static final float ADULT_HEIGHT = 0.2f;
    public static final float BABY_YOFFSET = 0.03125f;
    public static final float ADULT_YOFFSET = 0.03125f;
    private StarfishType starfishType;

    public EntityStarfish(World world) {
        super(world);
        this.setStarfishType(StarfishType.values()[this.field_70146_Z.nextInt(StarfishType.values().length)]);
        this.field_70728_aV = 5;
    }

    public EntityStarfish(World world, boolean baby) {
        super(world, baby);
        this.setStarfishType(StarfishType.values()[this.field_70146_Z.nextInt(StarfishType.values().length)]);
        this.field_70728_aV = 5;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public StarfishType getStarfishType() {
        return this.starfishType;
    }

    public void setStarfishType(StarfishType starfishType) {
        this.starfishType = starfishType;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("StarfishType", (byte)this.getStarfishType().ordinal());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setStarfishType(StarfishType.values()[nbt.func_74771_c("StarfishType")]);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.starfishType.ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.starfishType = StarfishType.values()[additionalData.readByte()];
    }

    @Override
    public EntityEgg createEgg() {
        return new EntityStarfishEgg(this.field_70170_p, this.starfishType);
    }

    @Override
    public float getBabyWidth() {
        return 0.25f;
    }

    @Override
    public float getAdultWidth() {
        return 1.0f;
    }

    @Override
    public float getBabyHeight() {
        return 0.1f;
    }

    @Override
    public float getAdultHeight() {
        return 0.2f;
    }

    @Override
    public float getBabyYOffset() {
        return 0.03125f;
    }

    @Override
    public float getAdultYOffset() {
        return 0.03125f;
    }

    @Override
    public boolean isPotentialMate(EntityEchinoderm other) {
        return super.isPotentialMate(other) && ((EntityStarfish)other).getStarfishType() == this.getStarfishType();
    }

    public void func_70645_a(DamageSource d) {
        super.func_70645_a(d);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70099_a(new ItemStack((Item)ItemRegistry.shell, 1, TropicraftShells.STARFISH.getMeta()), 0.0f);
        }
    }
}

