/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.entity.placeable.EntityPlaceableColored;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityBeachFloat
extends EntityPlaceableColored
implements IEntityAdditionalSpawnData {
    @Nonnull
    private static final Random rand = new Random(298457L);
    @Nonnull
    private static final NoiseGeneratorPerlin windNoise = new NoiseGeneratorPerlin(rand, 1);
    private double windModifier = 0.0;
    public boolean isEmpty;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    public float rotationSpeed;
    private double prevMotionY;

    public EntityBeachFloat(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 0.175f);
        this.field_70158_ak = true;
        this.isEmpty = true;
        this.field_70156_m = true;
        this.field_70144_Y = 0.95f;
        this.func_145769_d(this.func_145782_y());
    }

    public EntityBeachFloat(World world, double x, double y, double z, int color, EntityPlayer player) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setColor(color);
        this.field_70177_z = this.getAngleToPlayer(player);
        this.lerpYaw = this.field_70177_z;
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        rand.setSeed(id);
        this.windModifier = 1.0 + rand.nextGaussian() * 0.1 - 0.05;
    }

    @Override
    protected float getAngleToPlayer(EntityPlayer player) {
        return MathHelper.func_76142_g((float)(super.getAngleToPlayer(player) + 180.0f));
    }

    public void func_70030_z() {
        double eps;
        double center;
        double water;
        super.func_70030_z();
        this.tickLerp();
        Entity rider = this.func_184179_bs();
        if (this.field_70170_p.field_72995_K && rider instanceof EntityPlayer) {
            EntityPlayer controller = (EntityPlayer)rider;
            float move = controller.field_191988_bg;
            float rot = -controller.field_70702_br;
            this.rotationSpeed += rot * 0.25f;
            float ang = this.field_70177_z;
            float moveX = MathHelper.func_76126_a((float)(-ang * ((float)Math.PI / 180))) * move * 0.0035f;
            float moveZ = MathHelper.func_76134_b((float)(ang * ((float)Math.PI / 180))) * move * 0.0035f;
            this.field_70159_w += (double)moveX;
            this.field_70179_y += (double)moveZ;
        }
        if (this.field_70171_ac) {
            double yaw;
            double windAng = (windNoise.func_151601_a(this.field_70165_t / 1000.0, this.field_70161_v / 1000.0) + 1.0) * Math.PI;
            double windX = Math.sin(windAng) * 5.0E-4 * this.windModifier;
            double windZ = Math.cos(windAng) * 5.0E-4 * this.windModifier;
            this.field_70159_w += windX;
            this.field_70179_y += windZ;
            double targetYaw = Math.toDegrees(windAng) + (this.windModifier - 1.0) * 45.0;
            double angleDiff = targetYaw - (yaw = (double)((MathHelper.func_76142_g((float)this.field_70177_z) + 180.0f - 35.0f) % 360.0f));
            this.rotationSpeed = angleDiff > 0.0 ? (float)((double)this.rotationSpeed + Math.min(0.005 * this.windModifier, angleDiff)) : (float)((double)this.rotationSpeed + Math.max(-0.005 * this.windModifier, angleDiff));
        }
        if ((water = (double)this.getWaterLevel()) < (center = this.getCenterY()) - (eps = 0.0625)) {
            this.field_70181_x -= MathHelper.func_151237_a((double)(center - water), (double)0.0, (double)0.04);
        } else if (water > center + eps) {
            double floatpush = MathHelper.func_151237_a((double)(water - center), (double)0.0, (double)0.02);
            this.field_70181_x += floatpush;
        } else if (Math.abs(this.field_70163_u - this.field_70167_r) < 1.0E-5) {
            if (this.field_70181_x != 0.0) {
                this.lerpY = water - 0.011;
            }
            this.field_70181_x = 0.0;
            this.prevMotionY = 0.0;
        }
        this.field_70177_z += this.rotationSpeed;
        this.func_70091_d(MoverType.PLAYER, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.9f;
        this.field_70181_x *= (double)0.9f;
        this.field_70179_y *= (double)0.9f;
        this.rotationSpeed *= 0.9f;
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f));
            if (list != null && !list.isEmpty()) {
                for (int k1 = 0; k1 < list.size(); ++k1) {
                    Entity entity = (Entity)list.get(k1);
                    if (entity == this.func_184179_bs() || !entity.func_70104_M()) continue;
                    entity.func_70108_f((Entity)this);
                }
            }
            if (this.func_184179_bs() != null && this.func_184179_bs().field_70128_L) {
                this.func_184226_ay();
            }
        }
    }

    private double getCenterY() {
        AxisAlignedBB bb = this.func_174813_aQ();
        return bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * 0.5;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.prevMotionY = this.field_70181_x;
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public boolean func_70072_I() {
        AxisAlignedBB temp = this.func_174813_aQ();
        this.func_174826_a(temp.func_191195_a(1.0, 0.0, 1.0).func_191195_a(-1.0, -0.125, -1.0));
        if (this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70171_ac = true;
        } else {
            this.field_70171_ac = false;
        }
        this.func_174826_a(temp);
        return this.field_70171_ac;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (teleport) {
            super.func_180426_a(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        } else {
            this.lerpX = x;
            this.lerpY = y;
            this.lerpZ = z;
            if (yaw != this.field_70177_z) {
                this.lerpYaw = yaw;
            }
            this.lerpSteps = 10;
            this.field_70125_A = pitch;
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? 0.001 : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            float len = 0.6f;
            double x = this.field_70165_t + (double)(-MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * len);
            double z = this.field_70161_v + (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * len);
            passenger.func_70107_b(x, this.field_70163_u + (double)f1, z);
            passenger.field_70177_z += this.rotationSpeed;
            passenger.func_70034_d(passenger.func_70079_am() + this.rotationSpeed);
            this.applyYawToEntity(passenger);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
            if (passenger instanceof EntityPlayer) {
                ((EntityPlayer)passenger).func_174826_a(this.func_174813_aQ().func_72321_a(0.0, 0.3, 0.0).func_191195_a(0.0, -0.1875, 0.0));
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        if (!entityToUpdate.field_70170_p.field_72995_K || this.isClientFirstPerson()) {
            entityToUpdate.func_181013_g(this.field_70177_z);
            float yaw = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
            float pitch = MathHelper.func_76142_g((float)(entityToUpdate.field_70125_A - this.field_70125_A));
            float clampedYaw = MathHelper.func_76131_a((float)yaw, (float)-105.0f, (float)105.0f);
            float clampedPitch = MathHelper.func_76131_a((float)pitch, (float)-100.0f, (float)-10.0f);
            entityToUpdate.field_70126_B += clampedYaw - yaw;
            entityToUpdate.field_70177_z += clampedYaw - yaw;
            entityToUpdate.field_70127_C += clampedPitch - pitch;
            entityToUpdate.field_70125_A += clampedPitch - pitch;
            entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(@Nonnull Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isClientFirstPerson() {
        return Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getWaterLevel() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int minY = MathHelper.func_76128_c((double)(axisalignedbb.field_72338_b - this.prevMotionY));
        int maxY = minY + 1;
        int minZ = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            float waterHeight = minY - 1;
            for (int y = maxY; y >= minY; --y) {
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        pos.func_181079_c(x, y, z);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)pos);
                        if (iblockstate.func_185904_a() == Material.field_151586_h) {
                            waterHeight = Math.max(waterHeight, (float)pos.func_177956_o() + BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)pos));
                        }
                        if (!(waterHeight >= (float)maxY)) continue;
                        float f = waterHeight;
                        return f;
                    }
                }
            }
            float f = waterHeight;
            return f;
        }
        finally {
            pos.func_185344_t();
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource damageSource, float par2) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamage(this.getDamage() + par2 * 10.0f);
            this.func_70018_K();
            boolean bl = flag = damageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damageSource.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag) {
                    this.func_70099_a(new ItemStack((Item)ItemRegistry.beach_float, 1, this.getDamageFromColor()), 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70033_W() {
        return 0.0;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 1.1;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public EnumFacing func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.lerpYaw);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.lerpYaw = additionalData.readDouble();
    }
}

