/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHarvestFarmland;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPlay;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.capability.WorldDataInstance;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.entity.ai.EntityAIAvoidEntityOnLowHealth;
import net.tropicraft.core.common.entity.ai.EntityAIChillAtFire;
import net.tropicraft.core.common.entity.ai.EntityAIEatToHeal;
import net.tropicraft.core.common.entity.ai.EntityAIGoneFishin;
import net.tropicraft.core.common.entity.ai.EntityAIKoaMate;
import net.tropicraft.core.common.entity.ai.EntityAIPartyTime;
import net.tropicraft.core.common.entity.ai.EntityAIPlayKoa;
import net.tropicraft.core.common.entity.ai.EntityAITemptHelmet;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.hostile.EntityAshen;
import net.tropicraft.core.common.entity.hostile.EntityIguana;
import net.tropicraft.core.common.entity.hostile.EntityTropiSkeleton;
import net.tropicraft.core.common.entity.passive.EntityFishHook;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicalFish;
import net.tropicraft.core.common.item.ItemRiverFish;
import net.tropicraft.core.common.item.scuba.ItemDiveComputer;
import net.tropicraft.core.common.town.ISimulationTickable;
import net.tropicraft.core.common.worldgen.village.TownKoaVillage;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityKoaBase
extends EntityVillager {
    public long lastTimeFished = 0L;
    public BlockPos posLastFireplaceFound = null;
    public List<BlockPos> listPosDrums = new ArrayList<BlockPos>();
    public static int MAX_DRUMS = 12;
    public InventoryBasic inventory;
    private static final DataParameter<Integer> ROLE = EntityDataManager.func_187226_a(EntityKoaBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GENDER = EntityDataManager.func_187226_a(EntityKoaBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ORIENTATION = EntityDataManager.func_187226_a(EntityKoaBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityKoaBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(EntityKoaBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LURE_ID = EntityDataManager.func_187226_a(EntityKoaBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityAIBase taskFishing = new EntityAIGoneFishin(this);
    private float clientHealthLastTracked = 0.0f;
    public static int MAX_HOME_DISTANCE = 128;
    private static final int INVALID_DIM = Integer.MAX_VALUE;
    private int villageID = -1;
    private int villageDimID = Integer.MAX_VALUE;
    private EntityFishHook lure;
    private boolean wasInWater = false;
    private boolean wasNightLastTick = false;
    private boolean wantsToParty = false;
    public boolean jumpingOutOfWater = false;
    public int hitIndex = 0;
    public int hitIndex2 = 0;
    public int hitIndex3 = 0;
    public int hitDelay = 0;
    private long lastTradeTime = 0L;
    private static int TRADE_COOLDOWN = 72000;
    private static int DIVE_TIME_NEEDED = 3600;
    public boolean debug = false;
    public int druggedTime = 0;
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ItemRegistry.nigelStache});
    public static Predicate<Entity> ENEMY_PREDICATE = input -> input instanceof EntityMob && !(input instanceof EntityCreeper) || input instanceof EntityTropiSkeleton || input instanceof EntityIguana || input instanceof EntityAshen;
    private static final Field _buyingPlayer = ReflectionHelper.findField(EntityVillager.class, (String[])new String[]{"field_70962_h", "buyingPlayer"});
    private static final Field _buyingList = ReflectionHelper.findField(EntityVillager.class, (String[])new String[]{"field_70963_i", "buyingList"});

    public EntityKoaBase(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.field_70178_ae = true;
        this.inventory = new InventoryBasic("koa.inventory", false, 9);
    }

    public long getLastTradeTime() {
        return this.lastTradeTime;
    }

    public void setLastTradeTime(long lastTradeTime) {
        this.lastTradeTime = lastTradeTime;
    }

    public Genders getGender() {
        return Genders.get((Integer)this.func_184212_Q().func_187225_a(GENDER));
    }

    public void setGender(Genders gender) {
        this.func_184212_Q().func_187227_b(GENDER, (Object)gender.ordinal());
    }

    public Roles getRole() {
        return Roles.get((Integer)this.func_184212_Q().func_187225_a(ROLE));
    }

    public Orientations getOrientation() {
        return Orientations.get((Integer)this.func_184212_Q().func_187225_a(ORIENTATION));
    }

    public boolean isSitting() {
        return (Boolean)this.func_184212_Q().func_187225_a(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.func_184212_Q().func_187227_b(SITTING, (Object)sitting);
    }

    public boolean isDancing() {
        return (Boolean)this.func_184212_Q().func_187225_a(DANCING);
    }

    public void setDancing(boolean val) {
        this.func_184212_Q().func_187227_b(DANCING, (Object)val);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ROLE, (Object)0);
        this.func_184212_Q().func_187214_a(GENDER, (Object)0);
        this.func_184212_Q().func_187214_a(ORIENTATION, (Object)0);
        this.func_184212_Q().func_187214_a(SITTING, (Object)false);
        this.func_184212_Q().func_187214_a(DANCING, (Object)false);
        this.func_184212_Q().func_187214_a(LURE_ID, (Object)-1);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        if (key == LURE_ID) {
            int id = (Integer)this.func_184212_Q().func_187225_a(LURE_ID);
            if (id != -1) {
                this.scheduleEntityLookup(this, id);
            } else {
                this.setLure(null);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void scheduleEntityLookup(EntityKoaBase koa, int id) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            Entity ent = this.field_70170_p.func_73045_a(id);
            if (ent instanceof EntityFishHook) {
                this.setLure((EntityFishHook)ent);
                ((EntityFishHook)ent).angler = koa;
            }
        });
    }

    protected void func_184651_r() {
    }

    public void initTrades() {
        MerchantRecipeList list = new MerchantRecipeList();
        if (this.getRole() == Roles.FISHERMAN) {
            int i;
            this.addTradeForCurrencies(list, new ItemStack(Items.field_151115_aP, 5));
            this.addTradeForCurrencies(list, new ItemStack(ItemRegistry.fishingNet, 1));
            this.addTradeForCurrencies(list, new ItemStack(ItemRegistry.fishingRod, 1));
            this.addTradeForCurrencies(list, new ItemStack(ItemRegistry.freshMarlin, 3));
            this.addTradeForCurrencies(list, new ItemStack(ItemRegistry.fertilizer, 5));
            for (i = 0; i < EntityTropicalFish.NAMES.length; ++i) {
                this.addTradeForCurrencies(list, new ItemStack((Item)ItemRegistry.rawTropicalFish, 1, i));
            }
            for (i = 0; i < ItemRiverFish.FISH_COLORS.length; ++i) {
                this.addTradeForCurrencies(list, new ItemStack((Item)ItemRegistry.rawRiverFish, 1, i));
            }
        } else if (this.getRole() == Roles.HUNTER) {
            this.addTradeForCurrencies(list, new ItemStack(ItemRegistry.frogLeg, 5));
            this.addTradeForCurrencies(list, new ItemStack(ItemRegistry.iguanaLeather, 2));
            this.addTradeForCurrencies(list, new ItemStack(ItemRegistry.scale, 5));
        }
        try {
            _buyingList.set((Object)this, list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addTradeForCurrencies(MerchantRecipeList list, ItemStack sell) {
        double pearlWhiteWorth = 1.0;
        double pearlBlackWorth = 1.5;
        ArrayList listTradeCosts = new ArrayList();
        ItemStack stack1 = sell.func_77946_l();
        stack1.func_190920_e((int)Math.round((double)sell.func_190916_E() * pearlWhiteWorth));
        list.add((Object)new MerchantRecipe(new ItemStack(ItemRegistry.whitePearl), stack1));
        ItemStack stack2 = sell.func_77946_l();
        stack2.func_190920_e((int)Math.round((double)sell.func_190916_E() * pearlBlackWorth));
        list.add((Object)new MerchantRecipe(new ItemStack(ItemRegistry.blackPearl), stack2));
    }

    public void updateUniqueEntityAI() {
        Set executingTaskEntries2;
        Set executingTaskEntries = (Set)ReflectionHelper.getPrivateValue(EntityAITasks.class, (Object)this.field_70714_bg, (String[])new String[]{"field_75780_b", "executingTaskEntries"});
        if (executingTaskEntries != null) {
            for (Object entry : this.field_70714_bg.field_75782_a) {
                ((EntityAITasks.EntityAITaskEntry)entry).field_75733_a.func_75251_c();
            }
            executingTaskEntries.clear();
        }
        if ((executingTaskEntries2 = (Set)ReflectionHelper.getPrivateValue(EntityAITasks.class, (Object)this.field_70715_bh, (String[])new String[]{"field_75780_b", "executingTaskEntries"})) != null) {
            for (EntityAITasks.EntityAITaskEntry entry : this.field_70715_bh.field_75782_a) {
                entry.field_75733_a.func_75251_c();
            }
            executingTaskEntries2.clear();
        }
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
        int curPri = 0;
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(curPri++, new EntityAIAvoidEntityOnLowHealth<Entity>((EntityCreature)this, EntityLivingBase.class, ENEMY_PREDICATE, 12.0f, 1.4, 1.4, 15.0f));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIEatToHeal(this));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAITradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true){

            public void func_75249_e() {
                super.func_75249_e();
                if (this.field_75441_b instanceof EntityKoaBase) {
                    ((EntityKoaBase)this.field_75441_b).setFightingItem();
                }
            }

            protected double func_179512_a(EntityLivingBase attackTarget) {
                return this.field_75441_b.field_70130_N * 2.5f * this.field_75441_b.field_70130_N * 2.5f + attackTarget.field_70130_N;
            }
        });
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAITemptHelmet((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIKoaMate(this));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIChillAtFire(this));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIPartyTime(this));
        if (this.canFish()) {
            this.field_70714_bg.func_75776_a(curPri++, this.taskFishing);
        }
        if (this.func_70631_g_()) {
            this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIPlayKoa(this, 1.2));
        }
        this.field_70714_bg.func_75776_a(curPri, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIWanderNotLazy((EntityCreature)this, 1.0, 40));
        this.field_70714_bg.func_75776_a(curPri++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        if (this.canHunt()) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, ENEMY_PREDICATE));
        }
    }

    public EntityVillager func_90011_a(EntityAgeable ageable) {
        EntityKoaHunter entityvillager = new EntityKoaHunter(this.field_70170_p);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    protected void func_175500_n() {
        super.func_175500_n();
        this.updateUniqueEntityAI();
    }

    public boolean canFish() {
        return ((Integer)this.func_184212_Q().func_187225_a(ROLE)).intValue() == Roles.FISHERMAN.ordinal();
    }

    public boolean canHunt() {
        return ((Integer)this.func_184212_Q().func_187225_a(ROLE)).intValue() == Roles.HUNTER.ordinal() && !this.func_70631_g_();
    }

    public void setHunter() {
        this.func_184212_Q().func_187227_b(ROLE, (Object)Roles.HUNTER.ordinal());
        this.setFightingItem();
    }

    public void setFisher() {
        this.func_184212_Q().func_187227_b(ROLE, (Object)Roles.FISHERMAN.ordinal());
        this.setFishingItem();
    }

    protected void func_70619_bc() {
        Util.removeTask((EntityCreature)this, EntityAIHarvestFarmland.class);
        Util.removeTask((EntityCreature)this, EntityAIPlay.class);
        this.monitorHomeVillage();
        this.findAndSetHomeToCloseChest(false);
        this.findAndSetFireSource(false);
        this.findAndSetDrums(false);
        this.findAndSetTownID(false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        boolean ret = false;
        try {
            boolean doTrade = true;
            if (!this.field_70170_p.field_72995_K) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.poisonFrogSkin) {
                    doTrade = false;
                    this.dbg("koa drugged, zapping memory");
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    this.zapMemory();
                    this.druggedTime += 2400;
                    this.func_70690_d(new PotionEffect(MobEffects.field_76431_k, this.druggedTime));
                    this.findAndSetDrums(true);
                } else if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.diveComputer) {
                    long diveTime = 0L;
                    doTrade = false;
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stackScan = player.field_71071_by.func_70301_a(i);
                        if (Util.isEmpty(stackScan) || stackScan.func_77973_b() != ItemRegistry.diveComputer) continue;
                        diveTime = ((ItemDiveComputer)stackScan.func_77973_b()).getDiveTime(stackScan);
                        break;
                    }
                    if (diveTime >= (long)DIVE_TIME_NEEDED) {
                        if (this.field_70170_p.func_82737_E() > this.lastTradeTime + (long)TRADE_COOLDOWN) {
                            if (player.field_71071_by.func_70441_a(new ItemStack(ItemRegistry.trimix, 1))) {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.tropicraft.koa.trade.give", new Object[0]));
                                this.lastTradeTime = this.field_70170_p.func_82737_E();
                            } else {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.tropicraft.koa.trade.space", new Object[0]));
                            }
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.tropicraft.koa.trade.cooldown", new Object[0]));
                        }
                    } else {
                        int timeLeft = (int)((long)DIVE_TIME_NEEDED - diveTime) / 60;
                        if (timeLeft == 0) {
                            timeLeft = 1;
                        }
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.tropicraft.koa.trade.not_enough_time", new Object[]{timeLeft}));
                    }
                }
                if (doTrade) {
                    ret = super.func_184645_a(player, hand);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_175449_a(this.func_180425_c(), MAX_HOME_DISTANCE);
        this.rollDiceChild();
        this.rollDiceRoleAndGender();
        this.rollDiceOrientation();
        this.updateUniqueEntityAI();
        this.findAndSetHomeToCloseChest(true);
        this.findAndSetFireSource(true);
        this.findAndSetDrums(true);
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.initTrades();
        return data;
    }

    public void rollDiceChild() {
        int childChance = 20;
        if (childChance >= this.field_70170_p.field_73012_v.nextInt(100)) {
            this.func_70873_a(-24000);
        }
    }

    public void rollDiceRoleAndGender() {
        int randValRole = this.field_70170_p.field_73012_v.nextInt(Roles.values().length);
        if (randValRole == Roles.FISHERMAN.ordinal()) {
            this.setFisher();
        } else if (randValRole == Roles.HUNTER.ordinal()) {
            this.setHunter();
        }
        int randValGender = this.field_70170_p.field_73012_v.nextInt(Genders.values().length);
        this.func_184212_Q().func_187227_b(GENDER, (Object)randValGender);
    }

    public void rollDiceOrientation() {
        this.func_184212_Q().func_187227_b(ORIENTATION, (Object)Orientations.STRAIT.ordinal());
        int chance = 5;
        if (chance >= this.field_70170_p.field_73012_v.nextInt(100)) {
            this.func_184212_Q().func_187227_b(ORIENTATION, (Object)Orientations.GAY.ordinal());
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        int i;
        super.func_70014_b(compound);
        compound.func_74768_a("home_X", this.func_180486_cf().func_177958_n());
        compound.func_74768_a("home_Y", this.func_180486_cf().func_177956_o());
        compound.func_74768_a("home_Z", this.func_180486_cf().func_177952_p());
        if (this.posLastFireplaceFound != null) {
            compound.func_74768_a("fireplace_X", this.posLastFireplaceFound.func_177958_n());
            compound.func_74768_a("fireplace_Y", this.posLastFireplaceFound.func_177956_o());
            compound.func_74768_a("fireplace_Z", this.posLastFireplaceFound.func_177952_p());
        }
        compound.func_74772_a("lastTimeFished", this.lastTimeFished);
        NBTTagList nbttaglist = new NBTTagList();
        for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("koa_inventory", (NBTBase)nbttaglist);
        compound.func_74768_a("role_id", ((Integer)this.func_184212_Q().func_187225_a(ROLE)).intValue());
        compound.func_74768_a("gender_id", ((Integer)this.func_184212_Q().func_187225_a(GENDER)).intValue());
        compound.func_74768_a("orientation_id", ((Integer)this.func_184212_Q().func_187225_a(ORIENTATION)).intValue());
        compound.func_74768_a("village_id", this.villageID);
        compound.func_74768_a("village_dim_id", this.villageDimID);
        compound.func_74772_a("lastTradeTime", this.lastTradeTime);
        for (i = 0; i < this.listPosDrums.size(); ++i) {
            compound.func_74768_a("drum_" + i + "_X", this.listPosDrums.get(i).func_177958_n());
            compound.func_74768_a("drum_" + i + "_Y", this.listPosDrums.get(i).func_177956_o());
            compound.func_74768_a("drum_" + i + "_Z", this.listPosDrums.get(i).func_177952_p());
        }
        compound.func_74768_a("druggedTime", this.druggedTime);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("home_X")) {
            this.func_175449_a(new BlockPos(compound.func_74762_e("home_X"), compound.func_74762_e("home_Y"), compound.func_74762_e("home_Z")), MAX_HOME_DISTANCE);
        }
        if (compound.func_74764_b("fireplace_X")) {
            this.setFirelacePos(new BlockPos(compound.func_74762_e("fireplace_X"), compound.func_74762_e("fireplace_Y"), compound.func_74762_e("fireplace_Z")));
        }
        this.lastTimeFished = compound.func_74763_f("lastTimeFished");
        if (compound.func_150297_b("koa_inventory", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("koa_inventory", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.inventory.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        }
        this.villageID = compound.func_74762_e("village_id");
        this.villageDimID = !compound.func_74764_b("village_dim_id") ? TropicsConfigs.tropicsDimensionID : compound.func_74762_e("village_dim_id");
        this.func_184212_Q().func_187227_b(ROLE, (Object)compound.func_74762_e("role_id"));
        this.func_184212_Q().func_187227_b(GENDER, (Object)compound.func_74762_e("gender_id"));
        this.func_184212_Q().func_187227_b(ORIENTATION, (Object)compound.func_74762_e("orientation_id"));
        this.lastTradeTime = compound.func_74763_f("lastTradeTime");
        for (int i = 0; i < MAX_DRUMS; ++i) {
            if (!compound.func_74764_b("drum_" + i + "_X")) continue;
            this.listPosDrums.add(new BlockPos(compound.func_74762_e("drum_" + i + "_X"), compound.func_74762_e("drum_" + i + "_Y"), compound.func_74762_e("drum_" + i + "_Z")));
        }
        this.druggedTime = compound.func_74762_e("druggedTime");
        this.updateUniqueEntityAI();
    }

    public void setFishingItem() {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151112_aM));
    }

    public void setFightingItem() {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemRegistry.dagger));
    }

    public void monitorHomeVillage() {
        if (this.villageDimID != Integer.MAX_VALUE && this.field_70170_p.field_73011_w.getDimension() != this.villageDimID) {
            this.dbg("koa detected different dimension, zapping memory");
            this.zapMemory();
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 5));
        }
        this.findOrCreateNewVillage();
    }

    public void findOrCreateNewVillage() {
        if ((this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 100L != 0L) {
            return;
        }
        if (this.getVillage() == null) {
            TownKoaVillage village = this.getVillageWithinRange(64);
            if (village != null) {
                this.dbg("Koa found a village to join: " + village.locationID);
                this.setVillageAndDimID(village.locationID, village.dimID);
            } else {
                TileEntity tile = this.field_70170_p.func_175625_s(this.func_180486_cf());
                if (tile instanceof TileEntityChest) {
                    village = this.createNewVillage(this.func_180486_cf());
                    if (village != null) {
                        this.setVillageAndDimID(village.locationID, village.dimID);
                        this.dbg("Koa created a new village!");
                    } else {
                        this.dbg("village wasnt created, critical error!");
                    }
                } else {
                    this.dbg("no village near and no chest!");
                }
            }
        }
    }

    public TownKoaVillage createNewVillage(BlockPos pos) {
        WorldDataInstance storage = (WorldDataInstance)this.field_70170_p.getCapability(Tropicraft.WORLD_DATA_INSTANCE, null);
        if (storage != null) {
            TownKoaVillage village = new TownKoaVillage();
            int newID = storage.getAndIncrementKoaIDVillage();
            village.initData(newID, this.field_70170_p.field_73011_w.getDimension(), pos);
            village.isCustomVillage = true;
            village.minEntitiesToKeepAlive = 0;
            village.initFirstTime();
            village.generateSpawnCoords();
            storage.addTickingLocation(village);
            return village;
        }
        return null;
    }

    public void findAndSetHomeToCloseChest(boolean force) {
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.func_180486_cf() == null) {
            tryFind = true;
        } else {
            TileEntity tile = this.field_70170_p.func_175625_s(this.func_180486_cf());
            if (!(tile instanceof TileEntityChest)) {
                tryFind = true;
            }
        }
        if (tryFind) {
            int range = 20;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.func_180425_c().func_177982_a(x, y, z);
                        TileEntity tile = this.field_70170_p.func_175625_s(pos);
                        if (!(tile instanceof TileEntityChest)) continue;
                        this.dbg("found chest, updating home position to " + pos);
                        this.func_175449_a(pos, MAX_HOME_DISTANCE);
                        return;
                    }
                }
            }
        }
    }

    public boolean findAndSetTownID(boolean force) {
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return false;
        }
        boolean tryFind = false;
        if (this.villageID == -1 || this.villageDimID == Integer.MAX_VALUE) {
            tryFind = true;
            this.villageID = -1;
        }
        if (tryFind) {
            List listEnts = this.field_70170_p.func_72872_a(EntityKoaBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(20.0, 20.0, 20.0));
            Collections.shuffle(listEnts);
            for (EntityKoaBase ent : listEnts) {
                if (ent.villageID == -1 || ent.villageDimID == Integer.MAX_VALUE) continue;
                this.setVillageAndDimID(ent.villageID, ent.villageDimID);
                break;
            }
        }
        return this.villageID != -1;
    }

    public void findAndSetFireSource(boolean force) {
        IBlockState state;
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.posLastFireplaceFound == null) {
            tryFind = true;
        } else if (this.posLastFireplaceFound != null && (state = this.field_70170_p.func_180495_p(this.posLastFireplaceFound)).func_185904_a() != Material.field_151581_o) {
            this.posLastFireplaceFound = null;
            tryFind = true;
        }
        if (tryFind) {
            int range = 20;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.func_180425_c().func_177982_a(x, y, z);
                        IBlockState state2 = this.field_70170_p.func_180495_p(pos);
                        if (state2.func_185904_a() != Material.field_151581_o) continue;
                        this.dbg("found fire place spot to chill");
                        this.setFirelacePos(pos);
                        return;
                    }
                }
            }
            List listEnts = this.field_70170_p.func_72872_a(EntityKoaBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(20.0, 20.0, 20.0));
            Collections.shuffle(listEnts);
            for (EntityKoaBase ent : listEnts) {
                IBlockState state3;
                if (ent.posLastFireplaceFound == null || (state3 = this.field_70170_p.func_180495_p(ent.posLastFireplaceFound)).func_185904_a() != Material.field_151581_o) continue;
                this.posLastFireplaceFound = new BlockPos((Vec3i)ent.posLastFireplaceFound);
                this.dbg("found fire place spot to chill from entity");
                return;
            }
        }
    }

    public void syncBPM() {
        if ((this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 20L != 0L) {
            return;
        }
        List listEnts = this.field_70170_p.func_72872_a(EntityKoaBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(10.0, 5.0, 10.0));
        for (EntityKoaBase ent : listEnts) {
            if (this.hitDelay == ent.hitDelay) continue;
            this.hitDelay = ent.hitDelay;
            this.hitIndex = ent.hitIndex;
            this.hitIndex2 = ent.hitIndex2;
            this.hitIndex3 = ent.hitIndex3;
            return;
        }
    }

    public boolean isInstrument(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_177230_c() == BlockRegistry.bongo) {
            return true;
        }
        TileEntity tEnt = this.field_70170_p.func_175625_s(pos);
        return tEnt instanceof TileEntityNote;
    }

    public void findAndSetDrums(boolean force) {
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        Iterator<BlockPos> it = this.listPosDrums.iterator();
        while (it.hasNext()) {
            BlockPos pos = it.next();
            if (this.isInstrument(pos)) continue;
            it.remove();
        }
        if (this.listPosDrums.size() >= MAX_DRUMS) {
            return;
        }
        List listEnts = this.field_70170_p.func_72872_a(EntityKoaBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(20.0, 20.0, 20.0));
        Collections.shuffle(listEnts);
        for (EntityKoaBase ent : listEnts) {
            if (this.listPosDrums.size() >= MAX_DRUMS) {
                return;
            }
            for (BlockPos pos : ent.listPosDrums) {
                boolean match = false;
                for (BlockPos pos2 : this.listPosDrums) {
                    if (!pos.equals((Object)pos2)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    this.listPosDrums.add(pos);
                }
                if (this.listPosDrums.size() < MAX_DRUMS) continue;
                return;
            }
        }
        int range = 20;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range / 2; y <= range / 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos = this.func_180425_c().func_177982_a(x, y, z);
                    if (!this.isInstrument(pos)) continue;
                    boolean match = false;
                    for (BlockPos pos2 : this.listPosDrums) {
                        if (!pos.equals((Object)pos2)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        this.listPosDrums.add(pos);
                    }
                    if (this.listPosDrums.size() < MAX_DRUMS) continue;
                    return;
                }
            }
        }
    }

    public boolean tryDumpInventoryIntoHomeChest() {
        TileEntity tile = this.field_70170_p.func_175625_s(this.func_180486_cf());
        if (tile instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, this.addItem(chest, itemstack));
            }
        }
        return true;
    }

    @Nullable
    public ItemStack addItem(TileEntityChest chest, ItemStack stack) {
        ItemStack itemstack = stack.func_77946_l();
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack itemstack1 = chest.func_70301_a(i);
            if (itemstack1.func_190926_b()) {
                chest.func_70299_a(i, itemstack);
                chest.func_70296_d();
                return ItemStack.field_190927_a;
            }
            if (!ItemStack.func_179545_c((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(chest.func_70297_j_(), itemstack1.func_77976_d());
            int k = Math.min(itemstack.func_190916_E(), j - itemstack1.func_190916_E());
            if (k <= 0) continue;
            itemstack1.func_190917_f(k);
            itemstack.func_190918_g(k);
            if (itemstack.func_190916_E() > 0) continue;
            chest.func_70296_d();
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_190916_E() != stack.func_190916_E()) {
            chest.func_70296_d();
        }
        return itemstack;
    }

    public void setFirelacePos(BlockPos pos) {
        this.posLastFireplaceFound = pos;
    }

    public int func_70086_ai() {
        return super.func_70086_ai();
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
        if (this.wasInWater && !this.func_70090_H() && this.field_70123_F) {
            this.field_70181_x += (double)0.4f;
            this.jumpingOutOfWater = true;
        }
        if (this.jumpingOutOfWater && this.field_70122_E) {
            this.jumpingOutOfWater = false;
            this.func_70661_as().func_75499_g();
        }
        if (this.func_70090_H()) {
            if (this.func_70631_g_()) {
                if (this.field_70181_x < (double)-0.1f) {
                    this.field_70181_x += 0.25;
                }
            } else if (this.field_70181_x < (double)-0.2f) {
                this.field_70181_x += (double)0.15f;
            }
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        }
        this.wasInWater = this.func_70090_H();
        if (!this.wasNightLastTick && !this.field_70170_p.func_72935_r()) {
            this.rollDiceParty();
        }
        boolean bl = this.wasNightLastTick = !this.field_70170_p.func_72935_r();
        if (!this.field_70170_p.field_72995_K && this.druggedTime > 0) {
            --this.druggedTime;
        }
        if (this.field_70170_p.field_72995_K && this.clientHealthLastTracked != this.func_110143_aJ()) {
            if (this.func_110143_aJ() > this.clientHealthLastTracked) {
                this.field_70170_p.func_175682_a(EnumParticleTypes.HEART, false, this.field_70165_t, this.field_70163_u + 2.2, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
            this.clientHealthLastTracked = this.func_110143_aJ();
        }
    }

    public void func_70691_i(float healAmount) {
        super.func_70691_i(healAmount);
    }

    public boolean func_175550_n(boolean updateFirst) {
        this.func_175549_o(true);
        return true;
    }

    public boolean willBone(EntityKoaBase bonie) {
        EntityKoaBase boner = this;
        if (!bonie.func_175550_n(true)) {
            return false;
        }
        if (boner.func_70631_g_() || bonie.func_70631_g_()) {
            return false;
        }
        return !(boner.getOrientation() == Orientations.STRAIT ? boner.getGender() == bonie.getGender() : boner.getOrientation() == Orientations.GAY && boner.getGender() != bonie.getGender());
    }

    public int getVillageID() {
        return this.villageID;
    }

    public void setVillageAndDimID(int villageID, int villageDimID) {
        this.villageID = villageID;
        this.villageDimID = villageDimID;
    }

    public int getVillageDimID() {
        return this.villageDimID;
    }

    public TownKoaVillage getVillage() {
        ISimulationTickable sim;
        WorldDataInstance data;
        if (this.villageDimID == Integer.MAX_VALUE || this.villageID == -1) {
            return null;
        }
        WorldServer world = DimensionManager.getWorld((int)this.villageDimID);
        if (world != null && (data = (WorldDataInstance)world.getCapability(Tropicraft.WORLD_DATA_INSTANCE, null)) != null && (sim = data.getLocationByID(this.villageID)) instanceof TownKoaVillage) {
            return (TownKoaVillage)sim;
        }
        return null;
    }

    public TownKoaVillage getVillageWithinRange(int range) {
        WorldDataInstance data;
        World world = this.field_70170_p;
        double distSq = range * range;
        double closestDist = 99999.0;
        TownKoaVillage closestVillage = null;
        if (world != null && (data = (WorldDataInstance)world.getCapability(Tropicraft.WORLD_DATA_INSTANCE, null)) != null) {
            for (ISimulationTickable entry : data.lookupTickingManagedLocations.values()) {
                double dist;
                TownKoaVillage village;
                if (!(entry instanceof TownKoaVillage) || (village = (TownKoaVillage)entry).getPopulationSize() >= village.getMaxPopulationSize() || !((dist = village.getOrigin().func_177951_i((Vec3i)this.func_190671_u_())) < distSq) || !(dist < closestDist)) continue;
                closestDist = dist;
                closestVillage = village;
            }
        }
        return closestVillage;
    }

    public void func_70106_y() {
        TownKoaVillage village;
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K && (village = this.getVillage()) != null) {
            village.hookEntityDied((EntityLivingBase)this);
        }
    }

    public void hookUnloaded() {
        TownKoaVillage village;
        if (!this.field_70170_p.field_72995_K && (village = this.getVillage()) != null) {
            village.hookEntityDestroyed((EntityLivingBase)this);
        }
    }

    public EntityFishHook getLure() {
        return this.lure;
    }

    public void setLure(EntityFishHook lure) {
        this.lure = lure;
        if (!this.field_70170_p.field_72995_K) {
            if (lure != null) {
                this.func_184212_Q().func_187227_b(LURE_ID, (Object)this.lure.func_145782_y());
            } else {
                this.func_184212_Q().func_187227_b(LURE_ID, (Object)-1);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean result = super.func_70097_a(source, amount);
        if (!(this.func_110143_aJ() <= 0.0f) || source.func_76346_g() instanceof EntityLivingBase) {
            // empty if block
        }
        return result;
    }

    public void postSpawnGenderFix() {
        TownKoaVillage village = this.getVillage();
        if (village != null) {
            int maleCount = 0;
            int femaleCount = 0;
            Iterator iterator = village.lookupEntityToGender.values().iterator();
            while (iterator.hasNext()) {
                int ordinal = (Integer)iterator.next();
                if (Genders.MALE.ordinal() == ordinal) {
                    ++maleCount;
                    continue;
                }
                if (Genders.FEMALE.ordinal() != ordinal) continue;
                ++femaleCount;
            }
            if (maleCount < femaleCount) {
                this.setGender(Genders.MALE);
            } else {
                this.setGender(Genders.FEMALE);
            }
        }
    }

    public boolean isPartyNight() {
        long time = this.field_70170_p.func_72820_D();
        long day = time / 24000L;
        return day % 3L == 0L;
    }

    public void rollDiceParty() {
        int chance;
        if (this.isPartyNight() && (chance = 90) >= this.field_70170_p.field_73012_v.nextInt(100)) {
            this.wantsToParty = true;
            return;
        }
        this.wantsToParty = false;
    }

    public boolean getWantsToParty() {
        return this.wantsToParty;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("entity.tropicraft.koa." + this.getGender().toString().toLowerCase(Locale.ROOT) + "." + this.getRole().toString().toLowerCase(Locale.ROOT) + ".name", new Object[0]);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    public void zapMemory() {
        this.listPosDrums.clear();
        this.func_175449_a(BlockPos.field_177992_a, -1);
        this.setFirelacePos(null);
        this.villageDimID = Integer.MAX_VALUE;
        this.villageID = -1;
    }

    public void dbg(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.field_187915_go || soundIn == SoundEvents.field_187913_gm) {
            return;
        }
        super.func_184185_a(soundIn, volume, pitch);
    }

    public static enum Orientations {
        STRAIT,
        GAY;

        private static final Map<Integer, Orientations> lookup;

        public static Orientations get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Orientations>();
            for (Orientations e : EnumSet.allOf(Orientations.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }

    public static enum Roles {
        HUNTER,
        FISHERMAN;

        private static final Map<Integer, Roles> lookup;

        public static Roles get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Roles>();
            for (Roles e : EnumSet.allOf(Roles.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }

    public static enum Genders {
        MALE,
        FEMALE;

        private static final Map<Integer, Genders> lookup;

        public static Genders get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Genders>();
            for (Genders e : EnumSet.allOf(Genders.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }
}

