/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.build.world;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.tropicraft.core.common.build.ICustomGen;
import net.tropicraft.core.common.build.world.Build;

public class BuildJob {
    public int id = 0;
    public Build build;
    public int offset = 0;
    public int build_rate = 1500;
    public int build_rand = 20;
    public int timeout = 0;
    public int pass = 0;
    public List<Block> blockIDsSkipFirstPass = new ArrayList<Block>();
    public List<Block> blockIDsNoBuildOver = new ArrayList<Block>();
    public boolean build_active = false;
    public int build_currentTick = 0;
    public int build_loopTickX = 0;
    public int build_loopTickY = 0;
    public int build_loopTickZ = 0;
    public int build_startX = 0;
    public int build_startY = 0;
    public int build_startZ = 0;
    public int curLayerCount = 0;
    public int curLayerCountMax = 0;
    public boolean doRandomBuild = false;
    public boolean useRotationBuild = false;
    public boolean centerBuildIfNoRotate = true;
    public int direction = 0;
    public float rotation = 0.0f;
    public boolean useFirstPass = true;
    public boolean neverPlaceAir = false;
    public ICustomGen customGenCallback = null;
    public int customGenOffset = 0;
    public int buildRate = 99999999;
    public int notifyFlag = 2;
    public int curTick = 0;
    public int maxTicks = 0;
    public boolean[][][] build_blockPlaced;

    public BuildJob(int parID, int x, int y, int z, String parFile) {
        this.id = parID;
        this.build_startX = x;
        this.build_startY = y;
        this.build_startZ = z;
        this.build = new Build(x, y, z, parFile);
    }

    public BuildJob(int parID, int x, int y, int z, Build parBuild) {
        this.id = parID;
        this.build_startX = x;
        this.build_startY = y;
        this.build_startZ = z;
        this.build = parBuild;
    }

    public BuildJob(int parID, Build parBuild) {
        this.id = parID;
        this.build_startX = parBuild.map_coord_minX;
        this.build_startY = parBuild.map_coord_minY;
        this.build_startZ = parBuild.map_coord_minZ;
        this.build = parBuild;
    }

    public void setDirection(int dir) {
        this.direction = dir;
        this.rotation = dir * 90;
    }

    public void load() {
    }

    public void start() {
    }

    public void updateTick() {
    }

    public void newBuild(int x, int y, int z) {
        this.blockIDsSkipFirstPass = new LinkedList<Block>();
        this.blockIDsSkipFirstPass.add(Blocks.field_150335_W);
        this.blockIDsSkipFirstPass.add((Block)Blocks.field_150413_aR);
        this.blockIDsSkipFirstPass.add((Block)Blocks.field_150416_aS);
        this.blockIDsSkipFirstPass.add((Block)Blocks.field_150441_bU);
        this.blockIDsSkipFirstPass.add((Block)Blocks.field_150455_bV);
        this.blockIDsSkipFirstPass.add((Block)Blocks.field_150488_af);
        this.blockIDsSkipFirstPass.add(Blocks.field_150429_aA);
        this.blockIDsSkipFirstPass.add(Blocks.field_150437_az);
        this.blockIDsSkipFirstPass.add(Blocks.field_150478_aa);
        int offset = 0;
        y += offset;
        this.build_active = true;
        this.build_currentTick = 0;
        this.build_loopTickX = 0;
        this.build_loopTickY = 0;
        this.build_loopTickZ = 0;
        this.pass = 0;
        this.build_startX = x;
        this.build_startY = y;
        this.build_startZ = z;
    }

    public void buildStart() {
        this.resetBuildState();
        this.newBuild(this.build_startX, this.build_startY, this.build_startZ);
        int n = this.pass = this.useFirstPass ? 0 : 1;
        if (this.customGenCallback != null) {
            this.customGenCallback.genPassPre((World)DimensionManager.getWorld((int)this.build.dim), this, this.pass);
        }
    }

    public void buildComplete() {
        this.build_active = false;
        this.doRandomBuild = true;
    }

    public void resetBuildState() {
        this.build_blockPlaced = new boolean[this.build.map_sizeX][this.build.map_sizeY][this.build.map_sizeZ];
        for (int xx = 0; xx < this.build.map_sizeX; ++xx) {
            for (int yy = 0; yy < this.build.map_sizeY; ++yy) {
                for (int zz = 0; zz < this.build.map_sizeZ; ++zz) {
                    int index = yy * this.build.map_sizeX * this.build.map_sizeZ + zz * this.build.map_sizeX + xx;
                    this.build_blockPlaced[xx][yy][zz] = false;
                }
            }
        }
        this.curTick = 0;
        this.maxTicks = this.build.map_sizeX * this.build.map_sizeY * this.build.map_sizeZ * 3;
    }
}

