/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity.message;

import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tropicraft.Tropicraft;

public abstract class MessageTileEntity<T extends TileEntity>
implements IMessage {
    private long pos;
    @Deprecated
    protected int x;
    @Deprecated
    protected int y;
    @Deprecated
    protected int z;

    protected MessageTileEntity() {
    }

    protected MessageTileEntity(T tile) {
        this.pos = tile.func_174877_v().func_177986_g();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readLong();
        BlockPos bp = this.getPos();
        this.x = bp.func_177958_n();
        this.y = bp.func_177956_o();
        this.z = bp.func_177952_p();
    }

    public BlockPos getPos() {
        return BlockPos.func_177969_a((long)this.pos);
    }

    protected T getClientTileEntity() {
        return this.getTileEntity(Tropicraft.proxy.getClientWorld());
    }

    protected T getTileEntity(World worldObj) {
        if (worldObj == null || !worldObj.func_175667_e(this.getPos())) {
            return null;
        }
        TileEntity te = worldObj.func_175625_s(this.getPos());
        if (te == null) {
            return null;
        }
        TypeToken teType = TypeToken.of(this.getClass()).resolveType(MessageTileEntity.class.getTypeParameters()[0]);
        if (teType.isSubtypeOf(te.getClass())) {
            return (T)te;
        }
        return null;
    }

    protected World getWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.func_130014_f_();
    }
}

