/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity.message;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tropicraft.core.common.block.tileentity.TileEntityDrinkMixer;
import net.tropicraft.core.common.block.tileentity.message.MessageTileEntity;

public class MessageMixerInventory
extends MessageTileEntity<TileEntityDrinkMixer> {
    @Nonnull
    private NonNullList<ItemStack> inventory;
    @Nonnull
    private ItemStack result = ItemStack.field_190927_a;

    public MessageMixerInventory() {
    }

    public MessageMixerInventory(TileEntityDrinkMixer mixer) {
        super(mixer);
        this.inventory = mixer.ingredients;
        this.result = mixer.result;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.inventory.size());
        for (ItemStack i : this.inventory) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)i);
        }
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.result);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.inventory = NonNullList.func_191197_a((int)buf.readByte(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ByteBufUtils.readItemStack((ByteBuf)buf));
        }
        this.result = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static final class Handler
    implements IMessageHandler<MessageMixerInventory, IMessage> {
        public IMessage onMessage(MessageMixerInventory message, MessageContext ctx) {
            TileEntityDrinkMixer mixer = (TileEntityDrinkMixer)message.getClientTileEntity();
            if (mixer != null) {
                mixer.ingredients = message.inventory;
                mixer.result = message.result;
            }
            return null;
        }
    }
}

