/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.entity.EntityLavaBall;
import net.tropicraft.core.common.volcano.VolcanoState;
import net.tropicraft.core.registry.BlockRegistry;

public class TileEntityVolcano
extends TileEntity
implements ITickable {
    private static final int RAND_DORMANT_DURATION = 4000;
    private static final int MAX_LAVA_LEVEL_DURING_RISE = 113;
    private static final int MAX_LAVA_LEVEL_DURING_ERUPTION = 115;
    private static final int LAVA_BASE_LEVEL = 79;
    private int ticksUntilEruption = VolcanoState.getTimeBefore(VolcanoState.ERUPTING);
    private int ticksUntilSmoking = VolcanoState.getTimeBefore(VolcanoState.SMOKING);
    private int ticksUntilRetreating = VolcanoState.getTimeBefore(VolcanoState.RETREATING);
    private int ticksUntilDormant = VolcanoState.getTimeBefore(VolcanoState.DORMANT);
    private int ticksUntilRising = VolcanoState.getTimeBefore(VolcanoState.RISING);
    private int lavaLevel = -1;
    private int radius = -1;
    private VolcanoState state = VolcanoState.DORMANT;

    public void func_73660_a() {
        if (!TropicsConfigs.allowVolcanoEruption) {
            return;
        }
        if (!this.func_145831_w().field_72995_K) {
            // empty if block
        }
        if (this.radius == -1) {
            this.radius = this.findRadius();
        }
        if (this.lavaLevel == -1) {
            this.setLavaLevel();
        }
        this.updateStates();
        switch (this.state) {
            case DORMANT: {
                break;
            }
            case ERUPTING: {
                if (this.func_145831_w().field_72995_K) break;
                if (this.func_145831_w().field_73012_v.nextInt(15) == 0) {
                    this.throwLavaFromCaldera(0.05 + Math.abs(this.func_145831_w().field_73012_v.nextGaussian()) * (this.lavaLevel > 90 ? 1.0 : 0.75));
                }
                if (this.func_145831_w().field_73012_v.nextInt(15) != 0) break;
                this.throwLavaFromCaldera(0.05 + Math.abs(this.func_145831_w().field_73012_v.nextGaussian()) * (this.lavaLevel > 90 ? 1.0 : 0.75));
                break;
            }
            case RETREATING: {
                if (this.ticksUntilDormant % 30 != 0) break;
                this.lowerLavaLevels();
                break;
            }
            case RISING: {
                if (this.func_145831_w().field_72995_K) {
                    this.spewSmoke();
                }
                if (this.ticksUntilEruption % 20 != 0) break;
                if (this.lavaLevel < 115) {
                    this.raiseLavaLevels();
                    break;
                }
                this.ticksUntilEruption = 0;
                this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), 73.0, (double)this.field_174879_c.func_177956_o(), SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 1.0f, this.func_145831_w().field_73012_v.nextFloat() / 4.0f + 0.825f, false);
                int balls = this.func_145831_w().field_73012_v.nextInt(25) + 15;
                for (int i = 0; i < balls; ++i) {
                    this.throwLavaFromCaldera(this.func_145831_w().field_73012_v.nextDouble() * 0.5 + 1.25);
                }
                break;
            }
            case SMOKING: {
                if (!this.func_145831_w().field_72995_K) break;
                this.spewSmoke();
                break;
            }
        }
    }

    public void cleanUpFromEruption() {
        int xPos = this.field_174879_c.func_177958_n();
        int zPos = this.field_174879_c.func_177952_p();
        for (int x = xPos - this.radius * 2; x < xPos + this.radius * 2; ++x) {
            for (int z = zPos - this.radius * 2; z < zPos + this.radius * 2; ++z) {
                for (int y = 79; y < 140; ++y) {
                    BlockPos outBlockPos = new BlockPos(x, y, z);
                    if (this.func_145831_w().func_180495_p(outBlockPos).func_177230_c() != Blocks.field_150353_l) continue;
                    this.func_145831_w().func_175698_g(outBlockPos);
                }
            }
        }
    }

    public void throwLavaFromCaldera(double force) {
        Vec3d pos = new Vec3d((this.func_145831_w().field_73012_v.nextDouble() / 2.0 + 0.3) * (double)this.radius, (double)(this.lavaLevel + 2), 0.0);
        float angle = this.func_145831_w().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        pos = pos.func_178785_b(angle).func_178787_e(new Vec3d((Vec3i)this.func_174877_v()));
        double motX = force * Math.cos(angle);
        double motZ = force * Math.sin(-angle);
        this.throwLava(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, motX, 0.86, motZ);
    }

    public void throwLava(double i, double j, double k, double xMot, double yMot, double zMot) {
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_72838_d((Entity)new EntityLavaBall(this.func_145831_w(), i, j, k, xMot, yMot, zMot));
        }
    }

    private void raiseLavaLevels() {
        if (this.lavaLevel < 115) {
            ++this.lavaLevel;
            this.setBlocksOnLavaLevel(Blocks.field_150353_l.func_176223_P(), 3);
        }
    }

    private void lowerLavaLevels() {
        if (this.lavaLevel > 79) {
            this.setBlocksOnLavaLevel(Blocks.field_150350_a.func_176223_P(), 3);
            --this.lavaLevel;
        }
    }

    private void setBlocksOnLavaLevel(IBlockState state, int updateFlag) {
        int xPos = this.field_174879_c.func_177958_n();
        int zPos = this.field_174879_c.func_177952_p();
        for (int x = xPos - this.radius; x < xPos + this.radius; ++x) {
            for (int z = zPos - this.radius; z < zPos + this.radius; ++z) {
                if (!(Math.sqrt(Math.pow(x - xPos, 2.0) + Math.pow(z - zPos, 2.0)) < (double)(this.radius + 3))) continue;
                BlockPos botPos = new BlockPos(x, 10, z);
                if (this.func_145831_w().func_180495_p(botPos).func_177230_c() != Blocks.field_150353_l) continue;
                BlockPos pos2 = new BlockPos(x, this.lavaLevel, z);
                if (this.lavaLevel >= 113 && this.lavaLevel < 115) {
                    if (this.func_145831_w().func_180495_p(pos2).func_177230_c() == BlockRegistry.chunk) continue;
                    this.func_145831_w().func_180501_a(pos2, state, updateFlag);
                    continue;
                }
                this.func_145831_w().func_180501_a(pos2, state, updateFlag);
            }
        }
    }

    public void spewSmoke() {
        int n = this.func_145831_w().field_73012_v.nextInt(100) + 4;
        for (int i = 0; i < n; ++i) {
            int x = this.field_174879_c.func_177958_n() + this.func_145831_w().field_73012_v.nextInt(this.radius) * (this.func_145831_w().field_73012_v.nextBoolean() ? -1 : 1);
            int y = this.lavaLevel + this.func_145831_w().field_73012_v.nextInt(6);
            int z = this.field_174879_c.func_177952_p() + this.func_145831_w().field_73012_v.nextInt(this.radius) * (this.func_145831_w().field_73012_v.nextBoolean() ? -1 : 1);
            this.func_145831_w().func_175682_a(EnumParticleTypes.SMOKE_LARGE, true, (double)x, (double)y, (double)z, 0.0, 0.7, 0.0, new int[]{0});
        }
    }

    private void updateStates() {
        switch (this.state) {
            case DORMANT: {
                --this.ticksUntilSmoking;
                if (this.ticksUntilSmoking > 0) break;
                this.state = VolcanoState.SMOKING;
                this.ticksUntilSmoking = VolcanoState.getTimeBefore(VolcanoState.SMOKING);
                break;
            }
            case SMOKING: {
                --this.ticksUntilRising;
                if (this.ticksUntilRising > 0) break;
                this.state = VolcanoState.RISING;
                this.ticksUntilRising = VolcanoState.getTimeBefore(VolcanoState.RISING);
                break;
            }
            case RISING: {
                --this.ticksUntilEruption;
                if (this.ticksUntilEruption > 0) break;
                this.state = VolcanoState.ERUPTING;
                this.ticksUntilEruption = VolcanoState.getTimeBefore(VolcanoState.ERUPTING);
                break;
            }
            case ERUPTING: {
                --this.ticksUntilRetreating;
                if (this.ticksUntilRetreating > 0) break;
                this.state = VolcanoState.RETREATING;
                this.ticksUntilRetreating = VolcanoState.getTimeBefore(VolcanoState.RETREATING);
                break;
            }
            case RETREATING: {
                --this.ticksUntilDormant;
                if (this.ticksUntilDormant > 0) break;
                this.state = VolcanoState.DORMANT;
                this.ticksUntilDormant = VolcanoState.getTimeBefore(VolcanoState.DORMANT) + this.func_145831_w().field_73012_v.nextInt(4000);
                break;
            }
        }
    }

    private void setLavaLevel() {
        for (int y = 79; y < 128; ++y) {
            BlockPos pos2 = new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p());
            if (this.func_145831_w().func_180495_p(pos2).func_185904_a() == Material.field_151587_i) continue;
            this.lavaLevel = y - 1;
            return;
        }
    }

    private int findRadius() {
        for (int x = 0; x < 20; ++x) {
            if (this.func_145831_w().func_180495_p(new BlockPos(x + this.field_174879_c.func_177958_n(), 10, this.field_174879_c.func_177952_p())).func_177230_c() == Blocks.field_150353_l) continue;
            return x;
        }
        return -1;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = VolcanoState.valueOf(nbt.func_74779_i("state"));
        this.ticksUntilDormant = nbt.func_74762_e("ticksUntilDormant");
        this.ticksUntilSmoking = nbt.func_74762_e("ticksUntilSmoking");
        this.ticksUntilRising = nbt.func_74762_e("ticksUntilRising");
        this.ticksUntilEruption = nbt.func_74762_e("ticksUntilEruption");
        this.ticksUntilRetreating = nbt.func_74762_e("ticksUntilRetreating");
        this.lavaLevel = nbt.func_74762_e("lavaLevel");
        this.radius = nbt.func_74762_e("radius");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("state", this.state.name());
        nbt.func_74768_a("ticksUntilDormant", this.ticksUntilDormant);
        nbt.func_74768_a("ticksUntilSmoking", this.ticksUntilSmoking);
        nbt.func_74768_a("ticksUntilRising", this.ticksUntilRising);
        nbt.func_74768_a("ticksUntilEruption", this.ticksUntilEruption);
        nbt.func_74768_a("ticksUntilRetreating", this.ticksUntilRetreating);
        nbt.func_74768_a("lavaLevel", this.lavaLevel);
        nbt.func_74768_a("radius", this.radius);
        return nbt;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean func_145842_c(int id, int type) {
        return super.func_145842_c(id, type);
    }
}

