/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.ChatUtil;
import net.tropicraft.core.common.dimension.TropicraftWorldUtils;

public class BlockTropicsPortal
extends BlockFluidClassic {
    public static final PropertyBool TELEPORTABLE = PropertyBool.func_177716_a((String)"teleportable");
    private static final int TIME_UNTIL_TELEPORT = 20;

    public BlockTropicsPortal(Fluid fluid, Material material, boolean canTeleport) {
        super(fluid, material);
        this.func_149647_a(null);
        this.func_149675_a(true);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)TELEPORTABLE, (Comparable)Boolean.valueOf(canTeleport)));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{LEVEL, TELEPORTABLE}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            entity.func_70050_g(300);
            ++player.field_71088_bW;
            if (player.field_71088_bW > 20 && ((Boolean)state.func_177229_b((IProperty)TELEPORTABLE)).booleanValue()) {
                if (player.func_70644_a(MobEffects.field_76431_k)) {
                    player.field_71088_bW = 0;
                    player.func_184589_d(MobEffects.field_76431_k);
                    TropicraftWorldUtils.teleportPlayer(player);
                } else {
                    player.field_71088_bW = 0;
                    if (world.func_82737_E() % 20L == 0L) {
                        ChatUtil.sendNoSpamUnloc(player, "tropicraft.chat.teleport.unable");
                    }
                }
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity entity, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.field_72995_K) {
            this.sparkle(state, world, pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void sparkle(IBlockState state, World world, BlockPos pos) {
        double gz;
        double gy;
        double gx;
        int count;
        Random random = world.field_73012_v;
        int maxCount = 2;
        if (!((Boolean)state.func_177229_b((IProperty)TELEPORTABLE)).booleanValue() && world.field_72995_K) {
            for (count = 0; count < maxCount; ++count) {
                gx = (double)pos.func_177958_n() + random.nextDouble();
                gy = (double)pos.func_177956_o() + random.nextDouble();
                gz = (double)pos.func_177952_p() + random.nextDouble();
                world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, gx, gy, gz, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (world.func_175623_d(pos.func_177984_a()) && world.field_72995_K) {
            for (count = 0; count < maxCount; ++count) {
                gx = (double)pos.func_177958_n() + random.nextDouble();
                gy = (double)pos.func_177956_o() + 0.9;
                gz = (double)pos.func_177952_p() + random.nextDouble();
                world.func_175688_a(EnumParticleTypes.WATER_SPLASH, gx, gy, gz, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Nonnull
    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return motion.func_178787_e(this.getFlow((IBlockAccess)worldIn, pos, worldIn.func_180495_p(pos)));
    }

    protected Vec3d getFlow(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int i = this.getRenderedDepth(state);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing);
            int j = this.getRenderedDepth(worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos));
            if (j < 0) {
                if (worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_185904_a().func_76230_c() || (j = this.getRenderedDepth(worldIn.func_180495_p(blockpos$pooledmutableblockpos.func_177977_b()))) < 0) continue;
                int k = j - (i - 8);
                d0 += (double)(enumfacing.func_82601_c() * k);
                d1 += (double)(enumfacing.func_96559_d() * k);
                d2 += (double)(enumfacing.func_82599_e() * k);
                continue;
            }
            if (j < 0) continue;
            int l = j - i;
            d0 += (double)(enumfacing.func_82601_c() * l);
            d1 += (double)(enumfacing.func_96559_d() * l);
            d2 += (double)(enumfacing.func_82599_e() * l);
        }
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        if ((Integer)state.func_177229_b((IProperty)LEVEL) >= 8) {
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing1);
                if (!this.causesDownwardCurrent(worldIn, (BlockPos)blockpos$pooledmutableblockpos, enumfacing1) && !this.causesDownwardCurrent(worldIn, blockpos$pooledmutableblockpos.func_177984_a(), enumfacing1)) continue;
                vec3d = vec3d.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                break;
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return vec3d.func_72432_b();
    }

    protected int getDepth(IBlockState state) {
        return state.func_185904_a() == this.field_149764_J ? (Integer)state.func_177229_b((IProperty)LEVEL) : -1;
    }

    protected int getRenderedDepth(IBlockState state) {
        int i = this.getDepth(state);
        return i >= 8 ? 0 : i;
    }

    private boolean causesDownwardCurrent(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        Material material = iblockstate.func_185904_a();
        if (material == this.field_149764_J) {
            return false;
        }
        if (side == EnumFacing.UP) {
            return true;
        }
        if (material == Material.field_151588_w) {
            return false;
        }
        boolean flag = BlockTropicsPortal.func_193382_c((Block)block) || block instanceof BlockStairs;
        return !flag && iblockstate.func_193401_d(worldIn, pos, side) == BlockFaceShape.SOLID;
    }
}

