/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.common.enums.TropicraftSlabs;
import net.tropicraft.core.registry.BlockRegistry;

public class BlockTropicraftSlab
extends BlockSlab
implements ITropicraftBlock {
    public static final PropertyEnum<TropicraftSlabs> VARIANT = PropertyEnum.func_177709_a((String)"variant", TropicraftSlabs.class);
    public boolean isDoubleSlab;

    public BlockTropicraftSlab(Material material, boolean isDoubleSlab) {
        super(material);
        this.isDoubleSlab = isDoubleSlab;
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(iblockstate.func_177226_a(VARIANT, (Comparable)((Object)TropicraftSlabs.BAMBOO)));
        this.field_149783_u = true;
    }

    @Deprecated
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((TropicraftSlabs)((Object)blockState.func_177229_b(this.func_176551_l()))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((TropicraftSlabs)((Object)world.func_180495_p(pos).func_177229_b(this.func_176551_l()))).getResistance();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((TropicraftSlabs)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockRegistry.slabs);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)BlockRegistry.slabs, 1, ((TropicraftSlabs)((Object)state.func_177229_b(VARIANT))).getMeta());
    }

    public boolean func_176552_j() {
        return this.isDoubleSlab;
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + TropicraftSlabs.byMetadata(meta).func_176610_l();
    }

    public IProperty<TropicraftSlabs> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return TropicraftSlabs.byMetadata(stack.func_77960_j() & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this != BlockRegistry.doubleSlabs) {
            for (TropicraftSlabs slab : TropicraftSlabs.VALUES) {
                list.add((Object)new ItemStack((Block)this, 1, slab.getMeta()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TropicraftSlabs.byMetadata(meta & 7)));
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((TropicraftSlabs)((Object)state.func_177229_b(VARIANT))).getMeta();
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((TropicraftSlabs)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((TropicraftSlabs)((Object)state.func_177229_b(VARIANT))).func_176610_l();
    }

    @Override
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    public IItemColor getItemColor() {
        return null;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        if (this.func_176552_j()) {
            return iblockstate;
        }
        if (facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5)) {
            return iblockstate;
        }
        return iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        TropicraftSlabs slabType = (TropicraftSlabs)((Object)state.func_177229_b(VARIANT));
        if (slabType == TropicraftSlabs.BAMBOO || slabType == TropicraftSlabs.THATCH) {
            return SoundType.field_185850_c;
        }
        if (slabType == TropicraftSlabs.MAHOGANY || slabType == TropicraftSlabs.PALM) {
            return SoundType.field_185848_a;
        }
        return this.func_185467_w();
    }
}

