/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.tropicraft.core.common.block.ITropicraftBlock;
import net.tropicraft.core.registry.ItemRegistry;

public class BlockCoffeeBush
extends BlockCrops
implements ITropicraftBlock {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)6);
    public static final int MAX_HEIGHT = 3;
    public static final int GROWTH_RATE_FERTILE = 10;
    public static final int GROWTH_RATE_INFERTILE = 20;

    public BlockCoffeeBush() {
        this.func_149711_c(0.15f);
        this.func_149713_g(2);
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    public int func_185526_g() {
        return 6;
    }

    protected Item func_149866_i() {
        return ItemRegistry.coffeeBeans;
    }

    protected Item func_149865_P() {
        return null;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Integer)state.func_177229_b((IProperty)AGE)).intValue() == this.func_185526_g()) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
            ItemStack stack = new ItemStack(ItemRegistry.coffeeBeans, 1, 2);
            BlockCoffeeBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            BlockPos ground = pos;
            int height = 1;
            while (worldIn.func_180495_p(ground = ground.func_177977_b()).func_177230_c() == this) {
                ++height;
            }
            if (height < 3 && worldIn.field_73012_v.nextInt(worldIn.func_180495_p(ground).func_177230_c().isFertile(worldIn, ground) ? 10 : 20) == 0) {
                worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
            }
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return super.canSustainPlant(state, world, pos, direction, plantable) || state.func_177230_c() == this;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List ret = super.getDrops(world, pos, state, fortune);
        if (((Integer)state.func_177229_b((IProperty)AGE)).intValue() == this.func_185526_g()) {
            ret.add(new ItemStack(ItemRegistry.coffeeBeans, 1, 2));
        }
        return ret;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((Integer)state.func_177229_b((IProperty)AGE)).toString();
    }
}

