/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common;

import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Util {
    public static BlockPos findBlock(EntityLiving entity, int scanRange, BiPredicate<World, BlockPos> predicate) {
        int scanSize = scanRange;
        int scanSizeY = scanRange / 2;
        int adjustRangeY = 10;
        int tryY = MathHelper.func_76128_c((double)entity.field_70163_u) - 1;
        for (int ii = 0; ii <= 10; ++ii) {
            int tryMax;
            if (ii <= 3) {
                scanSize = 20;
                scanSizeY = 5;
            } else {
                scanSize = scanRange;
                scanSizeY = scanRange / 2;
            }
            int tryX = MathHelper.func_76128_c((double)entity.field_70165_t) + (entity.field_70170_p.field_73012_v.nextInt(scanSize) - scanSize / 2);
            int i = tryY + entity.field_70170_p.field_73012_v.nextInt(scanSizeY) - scanSizeY / 2;
            int tryZ = MathHelper.func_76128_c((double)entity.field_70161_v) + entity.field_70170_p.field_73012_v.nextInt(scanSize) - scanSize / 2;
            BlockPos posTry = new BlockPos(tryX, tryY, tryZ);
            boolean foundBlock = false;
            int newY = i;
            if (!entity.field_70170_p.func_175623_d(posTry)) {
                tryMax = adjustRangeY;
                while (!entity.field_70170_p.func_175623_d(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, ++newY, tryZ);
                }
                if (entity.field_70170_p.func_175623_d(posTry) && predicate.test(entity.field_70170_p, posTry.func_177982_a(0, -1, 0))) {
                    foundBlock = true;
                }
            } else {
                tryMax = adjustRangeY;
                while (entity.field_70170_p.func_175623_d(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, --newY, tryZ);
                }
                if (entity.field_70170_p.func_175623_d(posTry.func_177982_a(0, 1, 0)) && predicate.test(entity.field_70170_p, posTry)) {
                    foundBlock = true;
                }
            }
            if (!foundBlock) continue;
            return posTry;
        }
        return null;
    }

    public static boolean isWater(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    public static boolean isDeepWater(World world, BlockPos pos) {
        boolean clearAbove = world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(3));
        boolean deep = world.func_180495_p(pos).func_185904_a() == Material.field_151586_h && world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h;
        boolean notUnderground = false;
        if (deep) {
            int height = world.func_175725_q(pos).func_177956_o() - 1;
            notUnderground = height == pos.func_177956_o();
        }
        return deep && notUnderground && clearAbove;
    }

    public static boolean isLand(World world, BlockPos pos) {
        return world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
    }

    public static boolean isFire(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151581_o;
    }

    public static boolean tryMoveToEntityLivingLongDist(EntityLiving entSource, Entity entityTo, double moveSpeedAmp) {
        return Util.tryMoveToXYZLongDist(entSource, entityTo.func_180425_c(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(EntityLiving ent, BlockPos pos, double moveSpeedAmp) {
        return Util.tryMoveToXYZLongDist(ent, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(EntityLiving ent, int x, int y, int z, double moveSpeedAmp) {
        World world = ent.field_70170_p;
        boolean success = false;
        if (ent.func_70661_as().func_75500_f()) {
            double followDist;
            double distToPlayer = ent.func_70011_f((double)x, (double)y, (double)z);
            if (distToPlayer <= (followDist = ent.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e())) {
                success = ent.func_70661_as().func_75492_a((double)x, (double)y, (double)z, moveSpeedAmp);
            } else {
                int tries;
                int gatherZ;
                int gatherY;
                double d = (double)((float)x + 0.5f) - ent.field_70165_t;
                double d2 = (double)((float)z + 0.5f) - ent.field_70161_v;
                double d1 = (double)((float)y + 0.5f) - (ent.field_70163_u + (double)ent.func_70047_e());
                double d3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                EntityLiving center = ent;
                Random rand = world.field_73012_v;
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.field_70165_t + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                BlockPos pos = new BlockPos(gatherX, gatherY = (int)center.field_70163_u, gatherZ = (int)Math.floor(center.field_70161_v + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist));
                if (!world.func_175667_e(pos)) {
                    return false;
                }
                Block block = world.func_180495_p(pos).func_177230_c();
                if (!world.func_175623_d(pos)) {
                    for (tries = 0; !(tries >= 30 || world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a())); ++tries) {
                        pos = new BlockPos(gatherX, ++gatherY, gatherZ);
                        block = world.func_180495_p(pos).func_177230_c();
                    }
                } else {
                    while (tries < 30 && (world.func_175623_d(pos) || !block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, new BlockPos(gatherX, gatherY, gatherZ), EnumFacing.UP) && world.func_180495_p(pos).func_185904_a() != Material.field_151586_h)) {
                        pos = new BlockPos(gatherX, --gatherY, gatherZ);
                        block = world.func_180495_p(pos).func_177230_c();
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = ent.func_70661_as().func_75492_a((double)gatherX, (double)gatherY, (double)gatherZ, moveSpeedAmp);
                }
            }
        }
        return success;
    }

    public static boolean removeTask(EntityCreature ent, Class taskToReplace) {
        for (EntityAITasks.EntityAITaskEntry entry : ent.field_70714_bg.field_75782_a) {
            if (!taskToReplace.isAssignableFrom(entry.field_75733_a.getClass())) continue;
            ent.field_70714_bg.func_85156_a(entry.field_75733_a);
            return true;
        }
        return false;
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack.func_190926_b();
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean isBiomeTropical(Biome biome) {
        return Util.isBiomeHot(biome) && Util.isBiomeWet(biome);
    }

    public static boolean isBiomeHot(Biome biome) {
        return biome.func_185353_n() >= 0.8f;
    }

    public static boolean isBiomeWet(Biome biome) {
        return biome.func_76727_i() > 0.3f;
    }
}

