/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tropicraft.core.common.biome.BiomeTropicraft;
import net.tropicraft.core.common.block.BlockTropicraftFence;
import net.tropicraft.core.common.item.scuba.ItemScubaHelmet;
import net.tropicraft.core.registry.BlockRegistry;

public class TropicraftWaterRenderFixer {
    private static final ResourceLocation RES_UNDERWATER_OVERLAY = new ResourceLocation("tropicraft", "textures/misc/underwater.png");
    private static final Set<IBlockState> tropicalOverlayBlocks = new HashSet<IBlockState>();
    private static final float FOG_OCEAN = 0.0115f;
    private static final float FOG_KELP_FOREST = 0.125f;
    private static final float FOG_DELTA = 0.0025f;
    private float lastTickFogDensity = 0.0115f;
    private float fogDensity = 0.0115f;

    private static void addOverlayAll(Block block) {
        tropicalOverlayBlocks.addAll((Collection<IBlockState>)block.func_176194_O().func_177619_a());
    }

    private static void addOverlayMatching(Block block, Predicate<IBlockState> pred) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            if (!pred.apply((Object)state)) continue;
            TropicraftWaterRenderFixer.addOverlay(state);
        }
    }

    private static void addOverlay(IBlockState state) {
        tropicalOverlayBlocks.add(state);
    }

    @SubscribeEvent
    public void onBlockOverlay(RenderBlockOverlayEvent event) {
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            double d0 = event.getPlayer().field_70163_u + (double)event.getPlayer().func_70047_e();
            BlockPos blockpos = new BlockPos(event.getPlayer().field_70165_t, d0, event.getPlayer().field_70161_v);
            IBlockState atPos = event.getPlayer().func_130014_f_().func_180495_p(blockpos);
            if (tropicalOverlayBlocks.contains(atPos)) {
                event.setCanceled(true);
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_110434_K().func_110577_a(RES_UNDERWATER_OVERLAY);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer = tessellator.func_178180_c();
                float f = mc.field_71439_g.func_70013_c();
                GlStateManager.func_179131_c((float)f, (float)f, (float)f, (float)0.6f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                float f7 = -mc.field_71439_g.field_70177_z / 64.0f;
                float f8 = mc.field_71439_g.field_70125_A / 64.0f;
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vertexbuffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
                vertexbuffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
                vertexbuffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
                vertexbuffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        IBlockState state;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71441_e != null && mc.func_175606_aa() != null && tropicalOverlayBlocks.contains(state = ActiveRenderInfo.func_186703_a((World)mc.field_71441_e, (Entity)mc.func_175606_aa(), (float)mc.func_184121_ak()))) {
            float fogTarget;
            BlockPos pos = mc.func_175606_aa().func_180425_c();
            double y = mc.func_175606_aa().field_70167_r + (mc.func_175606_aa().field_70163_u - mc.func_175606_aa().field_70167_r) * (double)mc.func_184121_ak();
            if (mc.field_71441_e.func_180494_b(pos) == BiomeTropicraft.kelpForest) {
                float diff = 0.1135f;
                double scale = 1.0 - MathHelper.func_151237_a((double)((y - 45.0) / 20.0), (double)0.0, (double)1.0);
                fogTarget = (float)((double)0.0115f + (double)diff * scale);
            } else {
                fogTarget = 0.0115f;
            }
            this.lastTickFogDensity = this.fogDensity;
            if (this.fogDensity < fogTarget) {
                this.fogDensity = Math.min(this.fogDensity + 0.0025f, fogTarget);
            } else if (this.fogDensity > fogTarget) {
                this.fogDensity = Math.max(this.fogDensity - 0.0025f, fogTarget);
            }
        }
    }

    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (tropicalOverlayBlocks.contains(event.getState())) {
            EntityPlayer player;
            ItemStack goggles;
            event.setCanceled(true);
            Entity ent = event.getEntity();
            if (ent instanceof EntityPlayer && (goggles = (player = (EntityPlayer)ent).func_184582_a(EntityEquipmentSlot.HEAD)) != null && goggles.func_77973_b() != null && goggles.func_77973_b() instanceof ItemScubaHelmet) {
                this.fogDensity = 0.009f;
            }
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            double partialDelta = (double)0.0025f * event.getRenderPartialTicks();
            event.setDensity((float)(this.lastTickFogDensity > this.fogDensity ? (double)this.lastTickFogDensity - partialDelta : (this.lastTickFogDensity < this.fogDensity ? (double)this.lastTickFogDensity + partialDelta : (double)this.fogDensity)));
        }
    }

    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        if (tropicalOverlayBlocks.contains(event.getState())) {
            event.setRed(0.02f);
            event.setGreen(0.02f);
            event.setBlue(0.2f);
        }
    }

    static {
        TropicraftWaterRenderFixer.addOverlayAll((Block)BlockRegistry.tropicsWater);
        TropicraftWaterRenderFixer.addOverlayAll((Block)BlockRegistry.tropicsPortal);
        TropicraftWaterRenderFixer.addOverlayAll((Block)BlockRegistry.tropicsPortalTeleporter);
        TropicraftWaterRenderFixer.addOverlayAll(BlockRegistry.coral);
        Predicate waterPred = s -> s.func_177229_b(BlockTropicraftFence.WATER) != BlockTropicraftFence.WaterState.NONE;
        TropicraftWaterRenderFixer.addOverlayMatching(BlockRegistry.bambooFence, (Predicate<IBlockState>)waterPred);
        TropicraftWaterRenderFixer.addOverlayMatching(BlockRegistry.chunkFence, (Predicate<IBlockState>)waterPred);
        TropicraftWaterRenderFixer.addOverlayMatching(BlockRegistry.mahoganyFence, (Predicate<IBlockState>)waterPred);
        TropicraftWaterRenderFixer.addOverlayMatching(BlockRegistry.palmFence, (Predicate<IBlockState>)waterPred);
        TropicraftWaterRenderFixer.addOverlayMatching(BlockRegistry.thatchFence, (Predicate<IBlockState>)waterPred);
    }
}

