/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.agriseasons;

import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.SSBlocks;
import sereneseasons.config.FertilityConfig;
import sereneseasons.init.ModFertility;

public class AgriSeasonsHelper {
    private static final Logger log = LogManager.getLogger((String)"AgriSeasons");
    private static final Set<String> missingPlants = new HashSet<String>();

    private static boolean isGreenhouseGlassAboveBlock(World world, BlockPos cropPos) {
        for (int i = 0; i < FertilityConfig.general_category.greenhouse_glass_max_height; ++i) {
            if (!world.func_180495_p(cropPos.func_177982_a(0, i + 1, 0)).func_177230_c().equals(SSBlocks.greenhouse_glass)) continue;
            return true;
        }
        return false;
    }

    private static IPlantable getPlantable(TileEntityCrop crop) {
        if (crop.getSeed() == null) {
            return null;
        }
        return crop.getSeed().getPlant().getSeedItems().stream().map(FuzzyStack::toStack).map(ItemStack::func_77973_b).map(item -> {
            if (item instanceof ItemBlock) {
                return ((ItemBlock)item).func_179223_d();
            }
            if (item instanceof ItemBlockSpecial) {
                return ((ItemBlockSpecial)item).getBlock();
            }
            return item;
        }).filter(object -> object instanceof IPlantable).map(item -> (IPlantable)item).findFirst().orElse(null);
    }

    public static boolean onGrowthTickPre(TileEntityCrop crop) {
        IPlantable plantable = AgriSeasonsHelper.getPlantable(crop);
        if (plantable == null) {
            if (crop.getSeed() != null) {
                AgriSeasonsHelper.printMissingPlantable(crop.getSeed().getPlant());
            }
            return false;
        }
        Block block = plantable.getPlant((IBlockAccess)crop.getCropWorld(), crop.getCropPos()).func_177230_c();
        boolean isFertile = ModFertility.isCropFertile((String)block.getRegistryName().toString(), (World)crop.getCropWorld(), (BlockPos)crop.getCropPos());
        if (FertilityConfig.general_category.seasonal_crops && !isFertile && !AgriSeasonsHelper.isGreenhouseGlassAboveBlock(crop.getCropWorld(), crop.getCropPos())) {
            if (FertilityConfig.general_category.crops_break) {
                crop.getCropWorld().func_175655_b(crop.getCropPos(), true);
            }
            return true;
        }
        return false;
    }

    private static void printMissingPlantable(IAgriPlant plant) {
        if (!missingPlants.add(plant.getId())) {
            return;
        }
        log.warn("Unable to find valid plantable for AgriCraft plant " + plant + ". Is it misconfigured?");
        log.warn("Plant identification:");
        log.warn("  ID: " + plant.getId());
        log.warn("  Plant Name: " + plant.getPlantName());
        log.warn("  Seed Name: " + plant.getSeedName());
        log.warn("  Seed Items:");
        plant.getSeedItems().forEach(stack -> log.warn("    - " + stack.toString() + " (" + stack.toStack().func_77973_b().getClass().getCanonicalName() + ")"));
    }
}

