/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestconstruct.worldgen;

import java.util.Random;
import maxhyper.dynamictreestconstruct.ModContent;
import maxhyper.dynamictreestconstruct.worldgen.DynamicSlimeIslandGenerator;
import maxhyper.dynamictreestconstruct.worldgen.DynamicSlimeTreeGenerator;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockSlime;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.worldgen.SlimeLakeGenerator;
import slimeknights.tconstruct.world.worldgen.SlimePlantGenerator;

public class DynamicMagmaSlimeIslandGenerator
extends DynamicSlimeIslandGenerator {
    public static DynamicMagmaSlimeIslandGenerator INSTANCE = new DynamicMagmaSlimeIslandGenerator();
    protected SlimeLakeGenerator lakeGenMagma;
    protected SlimePlantGenerator plantGenMagma;
    protected DynamicSlimeTreeGenerator treeGenMagma;
    protected IBlockState dirtMagma;
    protected IBlockState grassMagma;

    public DynamicMagmaSlimeIslandGenerator() {
        this.air = Blocks.field_150353_l.func_176223_P();
        IBlockState slimeMagma = TinkerCommons.blockSlimeCongealed.func_176223_P().func_177226_a((IProperty)BlockSlime.TYPE, (Comparable)BlockSlime.SlimeType.MAGMA);
        IBlockState slimeBlood = TinkerCommons.blockSlimeCongealed.func_176223_P().func_177226_a((IProperty)BlockSlime.TYPE, (Comparable)BlockSlime.SlimeType.BLOOD);
        this.dirtMagma = TinkerWorld.slimeDirt.func_176223_P().func_177226_a((IProperty)BlockSlimeDirt.TYPE, (Comparable)BlockSlimeDirt.DirtType.MAGMA);
        this.grassMagma = TinkerWorld.slimeGrass.getStateFromDirt(this.dirtMagma).func_177226_a((IProperty)BlockSlimeGrass.FOLIAGE, (Comparable)BlockSlimeGrass.FoliageType.ORANGE);
        this.lakeGenMagma = new SlimeLakeGenerator(Blocks.field_150353_l.func_176223_P(), slimeMagma, new IBlockState[]{slimeMagma, slimeMagma, slimeMagma, slimeMagma, slimeBlood});
        this.treeGenMagma = new DynamicSlimeTreeGenerator(DynamicSlimeTreeGenerator.slimeType.MAGMA, 1);
        this.plantGenMagma = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.ORANGE, false);
    }

    @Override
    protected String getDataName() {
        return "MagmaIslandsDynamic";
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!ModContent.genSlimeIslands) {
            return;
        }
        if (world.func_175624_G() == WorldType.field_77138_c && !Config.genIslandsInSuperflat) {
            return;
        }
        if (!(world.field_73011_w instanceof WorldProviderHell)) {
            return;
        }
        this.markChunkForIslandGenerationAndGenerateMarked(random, chunkX, chunkZ, world, chunkProvider);
    }

    @Override
    protected int getGenerationChance() {
        return Config.magmaIslandsRate;
    }

    @Override
    protected void generateIslandInChunk(long seed, World world, int chunkX, int chunkZ) {
        int z;
        Random random = new Random(seed);
        int y = 31;
        int x = chunkX * 16 + 4 + random.nextInt(8);
        BlockPos pos = new BlockPos(x, y, z = chunkZ * 16 + 4 + random.nextInt(8));
        if (this.isLava(world, pos) && this.isLava(world, pos.func_177978_c()) && this.isLava(world, pos.func_177974_f()) && this.isLava(world, pos.func_177968_d()) && this.isLava(world, pos.func_177976_e())) {
            this.generateIsland(random, world, x, z, y + 1, this.dirtMagma, this.grassMagma, null, this.lakeGenMagma, this.treeGenMagma, this.plantGenMagma);
        }
    }

    private boolean isLava(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l;
    }
}

