/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.AbstractMessage;
import com.ldtteam.structurize.util.ScanToolOperation;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ReplaceBlockMessage
extends AbstractMessage<ReplaceBlockMessage, IMessage> {
    private BlockPos from;
    private BlockPos to;
    private ItemStack blockFrom;
    private ItemStack blockTo;

    public ReplaceBlockMessage() {
    }

    public ReplaceBlockMessage(@NotNull BlockPos pos1, @NotNull BlockPos pos2, @NotNull ItemStack blockFrom, @NotNull ItemStack blockTo) {
        this.from = pos1;
        this.to = pos2;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.from = BlockPosUtil.readFromByteBuf(buf);
        this.to = BlockPosUtil.readFromByteBuf(buf);
        this.blockTo = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.blockFrom = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.from);
        BlockPosUtil.writeToByteBuf(buf, this.to);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.blockTo);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.blockFrom);
    }

    @Override
    public void messageOnServerThread(ReplaceBlockMessage message, EntityPlayerMP player) {
        if (!player.field_71075_bZ.field_75098_d) {
            return;
        }
        Manager.addToQueue(new ScanToolOperation(ScanToolOperation.OperationType.REPLACE_BLOCK, message.from, message.to, (EntityPlayer)player, message.blockFrom, message.blockTo));
    }
}

