/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.management.linksession.ChannelsEnum;
import com.ldtteam.structurize.management.linksession.LinkSessionManager;
import com.ldtteam.structurize.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class LSStructureDisplayerMessage
extends AbstractMessage<LSStructureDisplayerMessage, IMessage> {
    private ByteBuf settings;
    private boolean show;

    public LSStructureDisplayerMessage() {
    }

    public LSStructureDisplayerMessage(@NotNull ByteBuf settings, @NotNull boolean show) {
        this.settings = settings;
        this.show = show;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.show = buf.readBoolean();
        if (this.show) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            this.settings = Unpooled.wrappedBuffer((byte[])bytes);
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeBoolean(this.show);
        if (this.show) {
            buf.writeBytes(this.settings);
        }
    }

    @Override
    protected void messageOnClientThread(LSStructureDisplayerMessage message, MessageContext ctx) {
        if (message.show) {
            Settings.instance.fromBytes(message.settings);
            if (Settings.instance.getStructureName() == null && Settings.instance.getStaticSchematicName() == null) {
                WindowShapeTool.commonStructureUpdate();
            } else {
                WindowBuildTool.commonStructureUpdate();
            }
        } else {
            Settings.instance.reset();
        }
    }

    @Override
    public void messageOnServerThread(LSStructureDisplayerMessage message, EntityPlayerMP player) {
        if (LinkSessionManager.INSTANCE.getMuteState(player.func_110124_au(), ChannelsEnum.STRUCTURE_DISPLAYER)) {
            return;
        }
        Set<UUID> targets = LinkSessionManager.INSTANCE.execute(player.func_110124_au(), ChannelsEnum.STRUCTURE_DISPLAYER);
        targets.remove(player.func_110124_au());
        for (UUID target : targets) {
            if (!(player.func_184102_h().func_175576_a(target) instanceof EntityPlayerMP)) continue;
            Structurize.getNetwork().sendTo((IMessage)new LSStructureDisplayerMessage(message.settings, message.show), (EntityPlayerMP)player.func_184102_h().func_175576_a(target));
        }
    }
}

