/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.management.linksession.ChannelsEnum;
import com.ldtteam.structurize.management.linksession.LinkSessionManager;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.server.command.CommandTreeBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkSessionCommand
extends CommandTreeBase {
    protected static final String NAME = "linksession";

    public LinkSessionCommand() {
        super.addSubcommand((ICommand)new AboutMe());
        super.addSubcommand((ICommand)new AcceptInvite());
        super.addSubcommand((ICommand)new AddPlayer());
        super.addSubcommand((ICommand)new Create());
        super.addSubcommand((ICommand)new Destroy());
        super.addSubcommand((ICommand)new MuteChannel());
        super.addSubcommand((ICommand)new Leave());
        super.addSubcommand((ICommand)new RemovePlayer());
        super.addSubcommand((ICommand)new SendMessage());
    }

    @NotNull
    public String func_71517_b() {
        return NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        StringBuilder usage = new StringBuilder();
        usage.append("/");
        usage.append("structurize");
        usage.append(" ");
        usage.append(NAME);
        usage.append(" <");
        for (String sub : super.getCommandMap().keySet()) {
            usage.append(sub);
            usage.append(" | ");
        }
        usage.delete(usage.length() - 3, usage.length());
        usage.append(">");
        return usage.toString();
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("Can be only used from clients.", new Object[0]);
        }
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        super.func_184881_a(server, sender, args);
    }

    private class Leave
    extends CommandBase {
        protected static final String NAME = "leave";

        private Leave() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession leave <nickname>";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public boolean func_82358_a(String[] args, int index) {
            return true;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return Leave.func_175762_a((String[])args, LinkSessionManager.INSTANCE.getSessionNamesOf(sender.func_174793_f().func_110124_au()));
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID senderUUID = sender.func_174793_f().func_110124_au();
            for (String name : args) {
                if (server.func_184103_al().func_152612_a(name) == null) continue;
                LinkSessionManager.INSTANCE.removeMemberOfSession(server.func_184103_al().func_152612_a(name).func_110124_au(), senderUUID);
                sender.func_145747_a((ITextComponent)new TextComponentString("Leaving a session owned by \"" + name + "\"."));
            }
        }
    }

    private class AcceptInvite
    extends CommandBase {
        protected static final String NAME = "acceptinvite";

        private AcceptInvite() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession acceptinvite";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID senderUUID = sender.func_174793_f().func_110124_au();
            String ownerName = null;
            if (args.length > 0) {
                try {
                    ownerName = LinkSessionManager.INSTANCE.consumeInviteWithCheck(senderUUID, sender.func_174793_f().func_70005_c_(), UUID.fromString(args[0]));
                }
                catch (IllegalArgumentException e) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                if (ownerName == null) {
                    throw new CommandException("This invite does not exist anymore.", new Object[0]);
                }
            } else {
                ownerName = LinkSessionManager.INSTANCE.consumeInvite(senderUUID, sender.func_174793_f().func_70005_c_());
                if (ownerName == null) {
                    throw new CommandException("You have no open invite.", new Object[0]);
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("You have successfully joined to " + ownerName + "'s linksession."));
        }
    }

    private class MuteChannel
    extends CommandBase {
        protected static final String NAME = "mutechannel";

        private MuteChannel() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession mutechannel";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return Stream.of(ChannelsEnum.values()).map(ch -> ch.getCommandName()).collect(Collectors.toList());
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID senderUUID = sender.func_174793_f().func_110124_au();
            for (String arg : args) {
                ChannelsEnum ch = ChannelsEnum.getEnumByCommandName(arg);
                if (ch == null) continue;
                LinkSessionManager.INSTANCE.setMuteState(senderUUID, ch, !LinkSessionManager.INSTANCE.getMuteState(senderUUID, ch));
            }
        }
    }

    private class AboutMe
    extends CommandBase {
        protected static final String NAME = "aboutme";

        private AboutMe() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession aboutme";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 0) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID senderUUID = sender.func_174793_f().func_110124_au();
            List<String> ownerSession = LinkSessionManager.INSTANCE.getMembersNamesOf(senderUUID);
            sender.func_145747_a((ITextComponent)new TextComponentString("Info about \"" + sender.func_70005_c_() + "\":"));
            String ownerName = LinkSessionManager.INSTANCE.hasInvite(senderUUID);
            if (ownerName == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("  \u00a7cYou have no open invite."));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("  \u00a7aYou have an open invite from " + ownerName + "."));
            }
            if (ownerSession == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("  \u00a7cYou don't have your own session."));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("  \u00a7aYou own a session with:"));
                for (String name : ownerSession) {
                    if (!name.equals("null")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("    \u00a77" + name));
                        continue;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("    \u00a77Unknown name"));
                }
            }
            ownerSession = LinkSessionManager.INSTANCE.getSessionNamesOf(senderUUID);
            if (ownerSession == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("  \u00a7cYou are not a part of other sessions."));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("  \u00a7aYou are in sessions owned by:"));
                for (String name : ownerSession) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("    \u00a77" + name));
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("  \u00a7aChannels:"));
            for (ChannelsEnum ch : ChannelsEnum.values()) {
                if (LinkSessionManager.INSTANCE.getMuteState(senderUUID, ch)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(String.format("    \u00a77%s:\u00a7r \u00a7c%s", ch.getCommandName(), "muted")));
                    continue;
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("    \u00a77%s:\u00a7r \u00a7a%s", ch.getCommandName(), "unmuted")));
            }
        }
    }

    private class SendMessage
    extends CommandBase {
        protected static final String NAME = "sendmessage";

        private SendMessage() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession sendmessage <message>";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID senderUUID = sender.func_174793_f().func_110124_au();
            Set<UUID> uniqueMembers = LinkSessionManager.INSTANCE.execute(senderUUID, ChannelsEnum.COMMAND_MESSAGE);
            TextComponentTranslation msgWithHead = new TextComponentTranslation("commands.message.display.incoming", new Object[]{"Structurize Session Message " + sender.func_70005_c_(), SendMessage.func_147176_a((ICommandSender)sender, (String[])args, (int)0, (boolean)true)});
            if (LinkSessionManager.INSTANCE.getMuteState(senderUUID, ChannelsEnum.COMMAND_MESSAGE)) {
                throw new CommandException("You have messages channel muted.", new Object[0]);
            }
            if (uniqueMembers.size() == 1) {
                throw new CommandException("You are not a part of any session or every other players have messages channel muted.", new Object[0]);
            }
            msgWithHead.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true));
            uniqueMembers.forEach(member -> {
                if (server.func_175576_a(member) != null) {
                    server.func_175576_a(member).func_145747_a((ITextComponent)msgWithHead);
                }
            });
        }
    }

    private class RemovePlayer
    extends CommandBase {
        protected static final String NAME = "removeplayer";

        private RemovePlayer() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession removeplayer <nickname>";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public boolean func_82358_a(String[] args, int index) {
            return true;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return RemovePlayer.func_71530_a((String[])args, (String[])server.func_71213_z());
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID ownerUUID = sender.func_174793_f().func_110124_au();
            if (LinkSessionManager.INSTANCE.getMembersOf(ownerUUID) == null) {
                throw new CommandException("You don't have a session created.", new Object[0]);
            }
            for (String name : args) {
                if (server.func_184103_al().func_152612_a(name) == null) continue;
                LinkSessionManager.INSTANCE.removeMemberOfSession(ownerUUID, server.func_184103_al().func_152612_a(name).func_110124_au());
                sender.func_145747_a((ITextComponent)new TextComponentString("Removing player \"" + name + "\" of " + sender.func_70005_c_() + "'s session."));
            }
        }
    }

    private class AddPlayer
    extends CommandBase {
        protected static final String NAME = "addplayer";

        private AddPlayer() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession addplayer <nickname>";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public boolean func_82358_a(String[] args, int index) {
            return true;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return AddPlayer.func_71530_a((String[])args, (String[])server.func_71213_z());
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID ownerUUID = sender.func_174793_f().func_110124_au();
            TextComponentString acceptButton = new TextComponentString("ACCEPT");
            TextComponentString inviteMsg = new TextComponentString("You have been invited to " + sender.func_174793_f().func_70005_c_() + "'s session, click the button to ");
            acceptButton.func_150256_b().func_150238_a(TextFormatting.DARK_RED).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, new AcceptInvite().func_71518_a(sender) + " " + ownerUUID.toString()));
            inviteMsg.func_150257_a((ITextComponent)acceptButton);
            if (LinkSessionManager.INSTANCE.getMembersOf(ownerUUID) == null) {
                throw new CommandException("You don't have a session created.", new Object[0]);
            }
            for (String name : args) {
                if (server.func_184103_al().func_152612_a(name) == null) continue;
                LinkSessionManager.INSTANCE.createInvite(server.func_184103_al().func_152612_a(name).func_110124_au(), ownerUUID);
                server.func_184103_al().func_152612_a(name).func_145747_a((ITextComponent)inviteMsg);
                sender.func_145747_a((ITextComponent)new TextComponentString("Inviting player \"" + name + "\" to " + sender.func_70005_c_() + "'s session."));
            }
        }
    }

    private class Destroy
    extends CommandBase {
        protected static final String NAME = "destroy";

        private Destroy() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession destroy";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 0) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID ownerUUID = sender.func_174793_f().func_110124_au();
            if (!LinkSessionManager.INSTANCE.destroySession(ownerUUID)) {
                throw new CommandException("You don't have a session created.", new Object[0]);
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Destroying session of player: " + sender.func_70005_c_()));
        }
    }

    private class Create
    extends CommandBase {
        protected static final String NAME = "create";

        private Create() {
        }

        @NotNull
        public String func_71517_b() {
            return NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/structurize linksession create";
        }

        public int func_82362_a() {
            return 0;
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length > 0) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            UUID ownerUUID = sender.func_174793_f().func_110124_au();
            if (LinkSessionManager.INSTANCE.getMembersOf(ownerUUID) != null) {
                throw new CommandException("You have already created a session.", new Object[0]);
            }
            LinkSessionManager.INSTANCE.createSession(ownerUUID);
            LinkSessionManager.INSTANCE.addOrUpdateMemberInSession(ownerUUID, ownerUUID, sender.func_70005_c_());
            sender.func_145747_a((ITextComponent)new TextComponentString("Created session for player: " + sender.func_70005_c_()));
        }
    }
}

