/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.util;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class BlockPosUtil {
    private BlockPosUtil() {
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound, String name, @NotNull BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74768_a("x", pos.func_177958_n());
        coordsCompound.func_74768_a("y", pos.func_177956_o());
        coordsCompound.func_74768_a("z", pos.func_177952_p());
        compound.func_74782_a(name, (NBTBase)coordsCompound);
    }

    @NotNull
    public static BlockPos readFromNBT(@NotNull NBTTagCompound compound, String name) {
        NBTTagCompound coordsCompound = compound.func_74775_l(name);
        int x = coordsCompound.func_74762_e("x");
        int y = coordsCompound.func_74762_e("y");
        int z = coordsCompound.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToNBTTagList(@NotNull NBTTagList tagList, @NotNull BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74768_a("x", pos.func_177958_n());
        coordsCompound.func_74768_a("y", pos.func_177956_o());
        coordsCompound.func_74768_a("z", pos.func_177952_p());
        tagList.func_74742_a((NBTBase)coordsCompound);
    }

    public static void writeToByteBuf(@NotNull ByteBuf buf, @NotNull BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    @NotNull
    public static BlockPos readFromByteBuf(@NotNull ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        return new BlockPos(x, y, z);
    }

    public static boolean isPositionSafe(@NotNull ICommandSender sender, BlockPos blockPos) {
        return sender.func_130014_f_().func_180495_p(blockPos).func_177230_c() != Blocks.field_150350_a && !sender.func_130014_f_().func_180495_p(blockPos).func_185904_a().func_76224_d() && !sender.func_130014_f_().func_180495_p(blockPos.func_177984_a()).func_185904_a().func_76224_d();
    }

    public static long getDistanceSquared(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.func_177958_n() - (long)block2.func_177958_n();
        long result = xDiff * xDiff + (yDiff = (long)block1.func_177956_o() - (long)block2.func_177956_o()) * yDiff + (zDiff = (long)block1.func_177952_p() - (long)block2.func_177952_p()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static Block getBlock(@NotNull World world, @NotNull BlockPos coords) {
        return world.func_180495_p(coords).func_177230_c();
    }

    public static IBlockState getBlockState(@NotNull World world, @NotNull BlockPos coords) {
        return world.func_180495_p(coords);
    }

    public static boolean setBlock(@NotNull World worldIn, @NotNull BlockPos coords, IBlockState state, int flag) {
        return worldIn.func_180501_a(coords, state, flag);
    }

    public static void set(@NotNull BlockPos.MutableBlockPos pos, @NotNull BlockPos newPos) {
        pos.func_181079_c(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
    }

    public static boolean isEqual(@NotNull BlockPos coords, int x, int y, int z) {
        return coords.func_177958_n() == x && coords.func_177956_o() == y && coords.func_177952_p() == z;
    }

    public static Rotation getRotationFromRotations(int rotations) {
        switch (rotations) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }
}

