/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import com.ldtteam.structurize.compat.optifine.OptifineCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.VertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class BlueprintTessellator {
    private static final int VERTEX_COMPONENT_SIZE = 3;
    private static final int COLOR_COMPONENT_SIZE = 4;
    private static final int TEX_COORD_COMPONENT_SIZE = 2;
    private static final int LIGHT_TEX_COORD_COMPONENT_SIZE = 2;
    private static final int VERTEX_SIZE = 28;
    private static final int VERTEX_COMPONENT_OFFSET = 0;
    private static final int COLOR_COMPONENT_OFFSET = 12;
    private static final int TEX_COORD_COMPONENT_OFFSET = 16;
    private static final int LIGHT_TEXT_COORD_COMPONENT_OFFSET = 24;
    private static final int DEFAULT_BUFFER_SIZE = 0x200000;
    private final BufferBuilder builder;
    private final VertexBuffer buffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
    private final VertexBufferUploader vboUploader = new VertexBufferUploader();
    private boolean isReadOnly = false;

    public BlueprintTessellator() {
        this.builder = new BufferBuilder(0x200000);
        this.vboUploader.func_178178_a(this.buffer);
    }

    public void draw() {
        GlStateManager.func_179094_E();
        this.buffer.func_177359_a();
        BlueprintTessellator.preBlueprintDraw();
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        this.buffer.func_177358_a(7);
        this.postBlueprintDraw();
        this.buffer.func_177361_b();
        GlStateManager.func_179121_F();
    }

    private static void preBlueprintDraw() {
        OptifineCompat.getInstance().preBlueprintDraw();
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
        if (OptifineCompat.getInstance().setupArrayPointers()) {
            return;
        }
        GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
        GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
        GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179129_p();
    }

    private void postBlueprintDraw() {
        GlStateManager.func_179089_o();
        for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
            VertexFormatElement.EnumUsage vfeUsage = vertexformatelement.func_177375_c();
            int formatIndex = vertexformatelement.func_177369_e();
            switch (vfeUsage) {
                case POSITION: {
                    GlStateManager.func_187429_p((int)32884);
                    break;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + formatIndex));
                    GlStateManager.func_187429_p((int)32888);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                    break;
                }
                case COLOR: {
                    GlStateManager.func_187429_p((int)32886);
                    GlStateManager.func_179117_G();
                    break;
                }
            }
        }
        OptifineCompat.getInstance().postBlueprintDraw();
    }

    public void startBuilding() {
        if (this.isReadOnly) {
            throw new IllegalStateException("Tessellator already build before");
        }
        this.builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
    }

    public void finishBuilding() {
        if (this.isReadOnly) {
            throw new IllegalStateException("Tessellator already build before");
        }
        this.builder.func_178977_d();
        OptifineCompat.getInstance().beforeBuilderUpload(this);
        this.vboUploader.func_181679_a(this.builder);
        this.isReadOnly = true;
    }

    public BufferBuilder getBuilder() {
        if (this.isReadOnly) {
            throw new IllegalStateException("Cannot retrieve BufferBuilder when Tessellator is in readonly.");
        }
        return this.builder;
    }

    public VertexBuffer getBuffer() {
        return this.buffer;
    }
}

