/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.blueprints.v1;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Blueprint {
    private final List<String> requiredMods;
    private short sizeX;
    private short sizeY;
    private short sizeZ;
    private short palleteSize;
    private List<IBlockState> palette;
    private String name;
    private String[] architects;
    private String[] missingMods;
    private short[][][] structure;
    private NBTTagCompound[][][] tileEntities;
    private NBTTagCompound[] entities = new NBTTagCompound[0];

    protected Blueprint(short sizeX, short sizeY, short sizeZ, short palleteSize, List<IBlockState> pallete, short[][][] structure, NBTTagCompound[] tileEntities, List<String> requiredMods) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.palleteSize = palleteSize;
        this.palette = pallete;
        this.structure = structure;
        this.tileEntities = new NBTTagCompound[sizeY][sizeZ][sizeX];
        for (NBTTagCompound te : tileEntities) {
            if (te == null) continue;
            this.tileEntities[te.func_74765_d((String)"y")][te.func_74765_d((String)"z")][te.func_74765_d((String)"x")] = te;
        }
        this.requiredMods = requiredMods;
    }

    public Blueprint(short sizeX, short sizeY, short sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.structure = new short[sizeY][sizeZ][sizeX];
        this.tileEntities = new NBTTagCompound[sizeY][sizeZ][sizeX];
        this.requiredMods = new ArrayList<String>();
        this.palette = new ArrayList<IBlockState>();
        this.palette.add(0, ModBlocks.blockSubstitution.func_176223_P());
    }

    public short getSizeX() {
        return this.sizeX;
    }

    public short getSizeY() {
        return this.sizeY;
    }

    public short getSizeZ() {
        return this.sizeZ;
    }

    public short getPalleteSize() {
        return this.palleteSize;
    }

    public IBlockState[] getPalette() {
        return this.palette.toArray(new IBlockState[0]);
    }

    public void addBlockState(BlockPos pos, IBlockState state) {
        int index = -1;
        for (int i = 0; i < this.palette.size(); ++i) {
            if (!this.palette.get(i).equals(state)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = this.palleteSize + 1;
            this.palleteSize = (short)(this.palleteSize + 1);
            this.palette.add(state);
        }
        this.structure[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()] = (short)index;
    }

    public short[][][] getStructure() {
        return this.structure;
    }

    public NBTTagCompound[][][] getTileEntities() {
        return this.tileEntities;
    }

    public NBTTagCompound[] getEntities() {
        return this.entities;
    }

    public void setEntities(NBTTagCompound[] entities) {
        this.entities = entities;
    }

    public List<String> getRequiredMods() {
        return this.requiredMods;
    }

    public String getName() {
        return this.name;
    }

    public Blueprint setName(String name) {
        this.name = name;
        return this;
    }

    public String[] getArchitects() {
        return this.architects;
    }

    public Blueprint setArchitects(String[] architects) {
        this.architects = architects;
        return this;
    }

    public String[] getMissingMods() {
        return this.missingMods;
    }

    public Blueprint setMissingMods(String ... missingMods) {
        this.missingMods = missingMods;
        return this;
    }

    public final List<NBTTagCompound> getEntitiesAsList() {
        return Arrays.stream(this.entities).collect(Collectors.toList());
    }

    public final List<BlockInfo> getBlockInfoAsList() {
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
            for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
                for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                    BlockPos tempPos = new BlockPos((int)x, (int)y, (int)z);
                    short value = this.structure[y][z][x];
                    IBlockState state = this.palette.get(value & 0xFFFF);
                    list.add(new BlockInfo(tempPos, state, this.tileEntities[y][z][x]));
                }
            }
        }
        return list;
    }

    public BlockPos rotateWithMirror(Rotation rotation, BlockPos pos, Mirror mirror, World world) {
        BlockPos temp;
        BlockPos resultSize = Blueprint.transformedSize(new BlockPos((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ), rotation);
        short newSizeX = (short)resultSize.func_177958_n();
        short newSizeY = (short)resultSize.func_177956_o();
        short newSizeZ = (short)resultSize.func_177952_p();
        short[][][] newStructure = new short[newSizeY][newSizeZ][newSizeX];
        NBTTagCompound[] newEntities = new NBTTagCompound[this.entities.length];
        NBTTagCompound[][][] newTileEntities = new NBTTagCompound[newSizeY][newSizeZ][newSizeX];
        ArrayList<IBlockState> palette = new ArrayList<IBlockState>();
        for (int i = 0; i < this.palette.size(); ++i) {
            palette.add(i, this.palette.get(i).func_185902_a(mirror).func_185907_a(rotation));
        }
        BlockPos extremes = Blueprint.transformedBlockPos(this.sizeX, this.sizeY, this.sizeZ, mirror, rotation);
        int minX = extremes.func_177958_n() < 0 ? -extremes.func_177958_n() - 1 : 0;
        int minY = extremes.func_177956_o() < 0 ? -extremes.func_177956_o() - 1 : 0;
        int minZ = extremes.func_177952_p() < 0 ? -extremes.func_177952_p() - 1 : 0;
        this.palette = palette;
        boolean foundAnchor = false;
        BlockPos offset = pos;
        for (short x = 0; x < this.sizeX; x = (short)(x + 1)) {
            for (short y = 0; y < this.sizeY; y = (short)(y + 1)) {
                for (short z = 0; z < this.sizeZ; z = (short)(z + 1)) {
                    BlockPos tempPos = Blueprint.transformedBlockPos(x, y, z, mirror, rotation).func_177982_a(minX, minY, minZ);
                    short value = this.structure[y][z][x];
                    IBlockState state = (IBlockState)palette.get(value & 0xFFFF);
                    if (state.func_177230_c() == Blocks.field_189881_dj) continue;
                    if (state.func_177230_c() instanceof IAnchorBlock) {
                        offset = tempPos;
                        foundAnchor = true;
                    }
                    newStructure[tempPos.func_177956_o()][tempPos.func_177952_p()][tempPos.func_177958_n()] = value;
                    NBTTagCompound compound = this.tileEntities[y][z][x];
                    if (compound != null) {
                        compound.func_74768_a("x", tempPos.func_177958_n());
                        compound.func_74768_a("y", tempPos.func_177956_o());
                        compound.func_74768_a("z", tempPos.func_177952_p());
                    }
                    newTileEntities[tempPos.func_177956_o()][tempPos.func_177952_p()][tempPos.func_177958_n()] = compound;
                }
            }
        }
        for (int i = 0; i < this.entities.length; ++i) {
            NBTTagCompound entitiesCompound = this.entities[i];
            if (entitiesCompound == null) continue;
            newEntities[i] = this.transformEntityInfoWithSettings(entitiesCompound, world, new BlockPos(minX, minY, minZ), rotation, mirror);
        }
        if (rotation.equals((Object)Rotation.CLOCKWISE_90) || rotation.equals((Object)Rotation.COUNTERCLOCKWISE_90) || mirror.equals((Object)Mirror.FRONT_BACK)) {
            temp = minX == minZ ? new BlockPos(resultSize.func_177958_n(), resultSize.func_177956_o(), minZ > 0 ? -resultSize.func_177952_p() : resultSize.func_177952_p()) : new BlockPos(minX > 0 ? -resultSize.func_177958_n() : resultSize.func_177958_n(), resultSize.func_177956_o(), minZ > 0 ? -resultSize.func_177952_p() : resultSize.func_177952_p());
            Rotation theRotation = rotation;
            if (rotation == Rotation.CLOCKWISE_90) {
                theRotation = Rotation.COUNTERCLOCKWISE_90;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                theRotation = Rotation.CLOCKWISE_90;
            }
            temp = temp.func_190942_a(theRotation);
        } else {
            temp = resultSize;
        }
        if (!foundAnchor) {
            BlockPos tempSize = new BlockPos(temp.func_177958_n(), 0, temp.func_177952_p());
            if (rotation == Rotation.CLOCKWISE_90) {
                tempSize = new BlockPos(-temp.func_177952_p(), 0, temp.func_177958_n());
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                tempSize = new BlockPos(-temp.func_177958_n(), 0, -temp.func_177952_p());
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                tempSize = new BlockPos(temp.func_177952_p(), 0, -temp.func_177958_n());
            }
            offset = new BlockPos(tempSize.func_177958_n() / 2, 0, tempSize.func_177952_p() / 2).func_177982_a(minX, minY, minZ);
        }
        this.sizeX = newSizeX;
        this.sizeY = newSizeY;
        this.sizeZ = newSizeZ;
        this.structure = newStructure;
        this.entities = newEntities;
        this.tileEntities = newTileEntities;
        return offset;
    }

    public static BlockPos transformedSize(BlockPos pos, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
        }
        return pos;
    }

    public static BlockPos transformedBlockPos(int xIn, int y, int zIn, Mirror mirror, Rotation rotation) {
        int x = xIn;
        int z = zIn;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -zIn;
                break;
            }
            case FRONT_BACK: {
                x = -xIn;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z, y, -x);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-z, y, x);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x, y, -z);
            }
        }
        return flag ? new BlockPos(x, y, z) : new BlockPos(xIn, y, zIn);
    }

    private NBTTagCompound transformEntityInfoWithSettings(NBTTagCompound entityInfo, World world, BlockPos pos, Rotation rotation, Mirror mirror) {
        Entity finalEntity = EntityList.func_75615_a((NBTTagCompound)entityInfo, (World)world);
        if (finalEntity != null) {
            Vec3d entityVec = Blueprint.transformedVec3d(rotation, mirror, finalEntity.func_174791_d()).func_178787_e(new Vec3d((Vec3i)pos));
            finalEntity.field_70126_B = (float)((double)finalEntity.func_184217_a(mirror) - 90.0);
            double rotationYaw = (double)finalEntity.func_184217_a(mirror) + ((double)finalEntity.func_184217_a(mirror) - (double)finalEntity.func_184229_a(rotation));
            if (finalEntity instanceof EntityHanging) {
                BlockPos currentPos = ((EntityHanging)finalEntity).func_174857_n();
                BlockPos entityPos = Blueprint.transformedBlockPos(currentPos.func_177958_n(), currentPos.func_177956_o(), currentPos.func_177952_p(), mirror, rotation).func_177971_a((Vec3i)pos);
                finalEntity.field_70165_t = entityVec.field_72450_a;
                finalEntity.field_70163_u = entityVec.field_72448_b;
                finalEntity.field_70161_v = entityVec.field_72449_c;
                finalEntity.func_70107_b((double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p());
            } else {
                finalEntity.func_70012_b(entityVec.field_72450_a, entityVec.field_72448_b, entityVec.field_72449_c, (float)rotationYaw, finalEntity.field_70125_A);
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            finalEntity.func_70039_c(nbttagcompound);
            return nbttagcompound;
        }
        return null;
    }

    private static Vec3d transformedVec3d(Rotation rotation, Mirror mirror, Vec3d vec) {
        double xCoord = vec.field_72450_a;
        double zCoord = vec.field_72449_c;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(zCoord, vec.field_72448_b, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - zCoord, vec.field_72448_b, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - xCoord, vec.field_72448_b, 1.0 - zCoord);
            }
        }
        return flag ? new Vec3d(xCoord, vec.field_72448_b, zCoord) : vec;
    }
}

