/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.tileentity;

import com.tattyseal.compactstorage.ConfigurationHandler;
import com.tattyseal.compactstorage.api.IChest;
import com.tattyseal.compactstorage.block.BlockChest;
import com.tattyseal.compactstorage.util.StorageInfo;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityChest
extends TileEntity
implements IInventory,
IChest,
ITickable {
    public EnumFacing direction = EnumFacing.NORTH;
    public Color color;
    public StorageInfo info;
    public int invX;
    public int invY;
    public boolean init;
    public float lidAngle;
    public float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private boolean retaining = false;
    public ItemStack[] items = new ItemStack[this.func_70302_i_()];
    private String customName;

    public TileEntityChest() {
        this.info = new StorageInfo(this.getInvX(), this.getInvY(), 180, StorageInfo.Type.CHEST);
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = ItemStack.field_190927_a;
        }
    }

    public int func_70302_i_() {
        return this.invX * this.invY;
    }

    public boolean func_191420_l() {
        return false;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (slot < this.items.length && this.items[slot] != null && !this.items[slot].func_190926_b()) {
            return this.items[slot];
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != ItemStack.field_190927_a) {
            if (stack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                this.func_70296_d();
                return stack.func_77946_l();
            }
            ItemStack stack2 = stack.func_77979_a(amount);
            this.func_70296_d();
            return stack2.func_77946_l();
        }
        return stack;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        this.items[index] = ItemStack.field_190927_a;
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        if (this.items != null && slot < this.items.length) {
            this.items[slot] = stack;
            this.func_70296_d();
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "compactChest.inv";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockChest) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void func_70296_d() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        super.func_70296_d();
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("facing")) {
            this.direction = EnumFacing.func_82600_a((int)tag.func_74762_e("facing"));
        }
        boolean bl = this.retaining = tag.func_74764_b("retaining") && tag.func_74767_n("retaining");
        if (tag.func_74764_b("hue")) {
            this.info.setHue(tag.func_74762_e("hue"));
            this.color = this.getHue() == -1 ? Color.white : Color.getHSBColor((float)this.info.getHue() / 360.0f, 0.5f, 0.5f);
        } else if (tag.func_74764_b("color")) {
            String color = tag.func_74781_a("color") instanceof NBTTagInt ? String.format("#%06X", 0xFFFFFF & tag.func_74762_e("color")) : tag.func_74779_i("color");
            System.out.println("color: " + color);
            if (color.startsWith("0x")) {
                color = "#" + color.substring(2, color.length());
            }
            if (!color.isEmpty()) {
                float[] hsbVals = new float[3];
                this.color = Color.decode(color);
                hsbVals = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), hsbVals);
                this.info.setHue((int)(hsbVals[0] * 360.0f));
                tag.func_82580_o("color");
            } else {
                this.color = Color.white;
                this.info.setHue(180);
                tag.func_82580_o("color");
            }
        }
        this.invX = tag.func_74762_e("invX");
        this.invY = tag.func_74762_e("invY");
        NBTTagList nbtTagList = tag.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int slot = 0; slot < nbtTagList.func_74745_c(); ++slot) {
            NBTTagCompound item = nbtTagList.func_150305_b(slot);
            int i = item.func_74762_e("Slot");
            if (i < 0 || i >= this.func_70302_i_()) continue;
            this.items[i] = new ItemStack(item);
        }
        if (tag.func_150297_b("Name", 8)) {
            this.customName = tag.func_74779_i("Name");
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.direction != null) {
            tag.func_74768_a("facing", this.direction.ordinal());
        }
        tag.func_74768_a("hue", this.info.getHue());
        tag.func_74768_a("invX", this.invX);
        tag.func_74768_a("invY", this.invY);
        tag.func_74757_a("retaining", this.retaining);
        NBTTagList nbtTagList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (slot >= this.items.length || this.items[slot] == null || this.items[slot].func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", slot);
            this.items[slot].func_77955_b(item);
            nbtTagList.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)nbtTagList);
        if (this.func_145818_k_()) {
            tag.func_74778_a("Name", this.customName);
        }
        return tag;
    }

    @Nonnull
    public NBTTagCompound getTileData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateBlock() {
        this.func_70296_d();
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).func_90010_a((IInventory)this))) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            this.field_145850_b.func_184148_a(null, d1, (double)j + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                double d3 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                this.field_145850_b.func_184148_a(null, d3, (double)j + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    public int getInvX() {
        return this.invX;
    }

    @Override
    public int getInvY() {
        return this.invY;
    }

    @Override
    public StorageInfo getInfo() {
        return this.info;
    }

    @Override
    public int getColor() {
        return 0;
    }

    @Override
    public boolean shouldConnectToNetwork() {
        return ConfigurationHandler.shouldConnect;
    }

    @Override
    public boolean getRetaining() {
        return this.retaining;
    }

    @Override
    public void setRetaining(boolean retaining) {
        this.retaining = retaining;
    }

    @Override
    public int getHue() {
        return this.info.getHue();
    }

    @Override
    public void setHue(int hue) {
        this.info.setHue(hue);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

