/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.tileentity;

import com.tattyseal.compactstorage.tileentity.IBarrel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBarrelFluid
extends TileEntity
implements IBarrel,
ITickable {
    public static final int CAPACITY = 32000;
    public FluidTank tank = new FluidTank(32000);
    public int hue = 128;
    public int lastAmount;

    @Override
    public ItemStack dropItems(EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack insertItems(@Nonnull ItemStack stack, EntityPlayer player) {
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)this.tank, null, (int)this.tank.getCapacity(), (EntityPlayer)player);
        if (res.isSuccess()) {
            return res.result;
        }
        res = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)this.tank, null, (int)this.tank.getCapacity(), (EntityPlayer)player);
        if (res.isSuccess()) {
            return res.result;
        }
        this.func_70296_d();
        return stack;
    }

    @Override
    public int color() {
        return this.hue;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("fluid", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("hue", this.hue);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.tank = new FluidTank(32000);
        this.tank.readFromNBT(compound.func_74775_l("fluid"));
        this.hue = compound.func_74762_e("hue");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public void func_70296_d() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        super.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.tank != null) {
            if (this.tank.getFluid() != null && this.lastAmount != this.tank.getFluidAmount()) {
                this.func_70296_d();
            }
            this.lastAmount = this.tank.getFluid() == null ? 0 : this.tank.getFluidAmount();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getText() {
        if (this.tank == null || this.tank.getFluid() == null || this.tank.getFluidAmount() == 0) {
            return "Empty";
        }
        return this.tank.getFluidAmount() + "/" + 32000 + "mB";
    }
}

