/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.util.TypeHelper;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.infinityraider.agricraft.api.v1.util.MethodResult;
import com.infinityraider.agricraft.utility.NBTHelper;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class StackHelper {
    public static final boolean isValid(@Nullable ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() != null;
    }

    public static final boolean isValid(ItemStack stack, Class<?> itemClass) {
        return stack != null && !stack.func_190926_b() && TypeHelper.isType(stack.func_77973_b(), itemClass);
    }

    public static final boolean isValid(ItemStack stack, Class<?> ... itemClasses) {
        return StackHelper.isValid(stack) && TypeHelper.isAllTypes(stack.func_77973_b(), (Class[])itemClasses);
    }

    public static final boolean areEqual(@Nullable ItemStack a, @Nullable ItemStack b) {
        return ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    public static final boolean areCompatible(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        Preconditions.checkNotNull((Object)a);
        Preconditions.checkNotNull((Object)b);
        if (a.func_190926_b() || b.func_190926_b() || a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (!a.func_77985_e()) {
            return false;
        }
        if (a.func_77981_g() && a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        if (a.func_77942_o() != b.func_77942_o()) {
            return false;
        }
        return (!a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p())) && a.areCapsCompatible(b);
    }

    public static final boolean areItemsEqual(@Nullable ItemStack a, @Nullable ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b);
    }

    public static final boolean areItemsEqualIgnoringMeta(@Nullable ItemStack a, @Nullable ItemStack b) {
        return ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
    }

    public static final boolean hasTag(@Nullable ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77978_p() != null;
    }

    public static final boolean hasKey(@Nullable ItemStack stack, String ... keys) {
        return stack != null && !stack.func_190926_b() && NBTHelper.hasKey(stack.func_77978_p(), keys);
    }

    @Nonnull
    public static final NBTTagCompound getTag(@Nonnull ItemStack stack) {
        Preconditions.checkNotNull((Object)stack, (Object)"The stack to fetch the NBTTagCompound from must not be null!");
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    @Nonnull
    public static final List<ItemStack> fitToMaxSize(@Nonnull ItemStack stack) {
        ItemStack partial;
        if (stack.func_190926_b()) {
            return Collections.EMPTY_LIST;
        }
        int stackSize = stack.func_190916_E();
        int maxSize = stack.func_77976_d();
        if (stack.func_190916_E() <= maxSize) {
            Arrays.asList(stack);
        }
        int totalStackCount = IntMath.divide((int)stackSize, (int)maxSize, (RoundingMode)RoundingMode.UP);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(totalStackCount);
        while (stackSize > maxSize) {
            partial = stack.func_77946_l();
            partial.func_190920_e(maxSize);
            stackSize -= maxSize;
            stacks.add(partial);
        }
        if (stackSize > 0) {
            partial = stack.func_77946_l();
            partial.func_190920_e(stackSize);
            stacks.add(partial);
        }
        return stacks;
    }

    @Nonnull
    public static final MethodResult decreaseStackSize(@Nullable EntityPlayer player, @Nonnull ItemStack stack, @Nonnegative int amount) {
        Preconditions.checkNotNull((Object)stack, (Object)"Null Itemstack Detected!");
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (String)"Cannot decrease ItemStack size by a negative amount! %d", (int)amount);
        if (stack.func_190926_b()) {
            return MethodResult.FAIL;
        }
        if (amount < 0) {
            throw new IllegalArgumentException("" + amount + " is not valid!");
        }
        if (player != null && player.func_184812_l_()) {
            return MethodResult.PASS;
        }
        if (stack.func_190916_E() - amount < 0) {
            return MethodResult.FAIL;
        }
        stack.func_190920_e(stack.func_190916_E() - amount);
        return MethodResult.PASS;
    }

    private StackHelper() {
    }
}

