/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.mutation;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.mutation.IAgriCrossStrategy;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutation;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.seed.IAgriSeedProvider;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MutateStrategy
implements IAgriCrossStrategy {
    @Override
    public double getRollChance() {
        return AgriCraftConfig.mutationChance;
    }

    @Override
    public Optional<AgriSeed> executeStrategy(IAgriCrop crop, Random rand) {
        Objects.requireNonNull(crop, "You cannot execute a mutation on a null crop!");
        Objects.requireNonNull(rand, "The random passed to a mutation strategy should not be null!");
        List neighbors = WorldHelper.getTileNeighbors((World)crop.getCropWorld(), (BlockPos)crop.getCropPos(), IAgriCrop.class);
        List parents = neighbors.stream().filter(IAgriCrop::isMature).map(IAgriSeedProvider::getSeed).filter(Objects::nonNull).map(AgriSeed::getPlant).collect(Collectors.toList());
        if (parents.size() < 2) {
            return Optional.empty();
        }
        List mutations = AgriApi.getMutationRegistry().stream().filter(m -> m.areParentsIn(parents)).filter(m -> crop.isFertile(m.getChild())).collect(Collectors.toList());
        if (mutations.isEmpty()) {
            return Optional.empty();
        }
        int index = rand.nextInt(mutations.size());
        IAgriMutation mutation = (IAgriMutation)mutations.get(index);
        if (mutation.getChance() <= rand.nextDouble()) {
            return Optional.empty();
        }
        Optional<IAgriStat> stat = AgriApi.getStatCalculatorRegistry().valueOf(mutation.getChild()).map(c -> c.calculateMutationStats(mutation, neighbors));
        return stat.map(s -> new AgriSeed(mutation.getChild(), (IAgriStat)s));
    }
}

