/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.google.common.collect.ImmutableMap;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.InfuseStorage;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.proxy.IConversionProxy;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;

@RegPEIPlugin(modid="mekanism")
public class PluginMekanism
extends PEIPlugin {
    private final Map<Gas, Object> GAS_MAP = new HashMap<Gas, Object>();
    private final Map<InfuseType, Object> INFUSE_MAP = new HashMap<InfuseType, Object>();

    public PluginMekanism(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            Object obj = new Object();
            this.GAS_MAP.put(gas, obj);
        }
        IConversionProxy proxy = ProjectEAPI.getConversionProxy();
        for (Map.Entry entry : InfuseRegistry.getObjectMap().entrySet()) {
            ItemStack item = (ItemStack)entry.getKey();
            InfuseObject infuse = (InfuseObject)entry.getValue();
            Object obj = new Object();
            if (this.INFUSE_MAP.containsKey(infuse.type)) {
                obj = this.INFUSE_MAP.get(infuse.type);
            } else {
                this.INFUSE_MAP.put(infuse.type, obj);
            }
            proxy.addConversion(infuse.stored, obj, (Map)ImmutableMap.of((Object)item, (Object)item.func_190916_E()));
        }
        if (BlockStateMachine.MachineType.ENRICHMENT_CHAMBER.isEnabled()) {
            this.addMapper(new BasicMachineMapper(RecipeHandler.Recipe.ENRICHMENT_CHAMBER));
        }
        if (BlockStateMachine.MachineType.CRUSHER.isEnabled()) {
            this.addMapper(new BasicMachineMapper(RecipeHandler.Recipe.CRUSHER));
        }
        if (BlockStateMachine.MachineType.COMBINER.isEnabled()) {
            this.addMapper(new DoubleMachineMapper(RecipeHandler.Recipe.COMBINER));
        }
        if (BlockStateMachine.MachineType.PURIFICATION_CHAMBER.isEnabled()) {
            this.addMapper(new AdvancedMachineMapper(RecipeHandler.Recipe.PURIFICATION_CHAMBER));
        }
        if (BlockStateMachine.MachineType.OSMIUM_COMPRESSOR.isEnabled()) {
            this.addMapper(new AdvancedMachineMapper(RecipeHandler.Recipe.OSMIUM_COMPRESSOR));
        }
        if (BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.isEnabled()) {
            this.addMapper(new AdvancedMachineMapper(RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER));
        }
        if (BlockStateMachine.MachineType.PRECISION_SAWMILL.isEnabled()) {
            this.addMapper(new ChanceMachineMapper(RecipeHandler.Recipe.PRECISION_SAWMILL));
        }
        if (BlockStateMachine.MachineType.METALLURGIC_INFUSER.isEnabled()) {
            this.addMapper(new MetallurgicInfuserMapper());
        }
        if (BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER.isEnabled()) {
            this.addMapper(new CrystallizerMapper());
        }
        if (BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.isEnabled()) {
            this.addMapper(new DissolutionMapper());
        }
        if (BlockStateMachine.MachineType.CHEMICAL_INFUSER.isEnabled()) {
            this.addMapper(new ChemicalInfuserMapper());
        }
        if (BlockStateMachine.MachineType.CHEMICAL_OXIDIZER.isEnabled()) {
            this.addMapper(new ChemicalOxidizerMapper());
        }
        if (BlockStateMachine.MachineType.CHEMICAL_WASHER.isEnabled()) {
            this.addMapper(new ChemicalWasherMapper());
        }
        if (BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR.isEnabled()) {
            this.addMapper(new SolarNeutronActivatorMapper());
        }
        if (BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR.isEnabled()) {
            this.addMapper(new ElectrolyticSeparatorMapper());
        }
        this.addMapper(new ThermalEvaporationMapper());
        if (BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER.isEnabled()) {
            this.addMapper(new PressurizedReactionChamberMapper());
        }
        if (BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR.isEnabled()) {
            this.addMapper(new RotaryCondensentratorMapper());
        }
        if (BlockStateMachine.MachineType.ENERGIZED_SMELTER.isEnabled()) {
            this.addMapper(new BasicMachineMapper(RecipeHandler.Recipe.ENERGIZED_SMELTER));
        }
        this.GAS_MAP.clear();
        this.INFUSE_MAP.clear();
    }

    private class RotaryCondensentratorMapper
    extends MekanismMapper {
        public RotaryCondensentratorMapper() {
            super("Rotary Condensentrator");
        }

        @Override
        public void setup() {
            for (Gas gas : GasRegistry.getRegisteredGasses()) {
                if (!gas.hasFluid() || !PluginMekanism.this.GAS_MAP.containsKey(gas)) continue;
                this.addConversion(new GasStack(gas, 1), (Map<Object, Integer>)ImmutableMap.of((Object)gas.getFluid(), (Object)1));
                this.addConversion(new FluidStack(gas.getFluid(), 1), (Map<Object, Integer>)ImmutableMap.of(PluginMekanism.this.GAS_MAP.get(gas), (Object)1));
            }
        }
    }

    private class PressurizedReactionChamberMapper
    extends MekanismMapper {
        public PressurizedReactionChamberMapper() {
            super("Pressurized Reaction Chamber");
        }

        @Override
        public void setup() {
            for (PressurizedRecipe recipe : RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.get().values()) {
                PressurizedInput input = (PressurizedInput)recipe.getInput();
                PressurizedOutput output = (PressurizedOutput)recipe.getOutput();
                HashMap<Object, Integer> ingredients = new HashMap<Object, Integer>();
                ingredients.put(input.getFluid(), input.getFluid().amount);
                ingredients.put(input.getSolid(), input.getSolid().func_190916_E());
                if (PluginMekanism.this.GAS_MAP.containsKey(input.getGas().getGas())) {
                    ingredients.put(PluginMekanism.this.GAS_MAP.get(input.getGas().getGas()), input.getGas().amount);
                }
                if (PluginMekanism.this.GAS_MAP.containsKey(output.getGasOutput().getGas())) {
                    this.addConversion(output.getGasOutput(), ingredients);
                }
                this.addConversion(output.getItemOutput(), ingredients);
            }
        }
    }

    private class ThermalEvaporationMapper
    extends PEIMapper {
        public ThermalEvaporationMapper() {
            super("Thermal Evaporation");
        }

        @Override
        public void setup() {
            for (ThermalEvaporationRecipe recipe : RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.get().values()) {
                FluidStack input = ((FluidInput)recipe.recipeInput).ingredient;
                this.addConversion(((FluidOutput)recipe.getOutput()).output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.amount));
            }
        }
    }

    private class ElectrolyticSeparatorMapper
    extends MekanismMapper {
        public ElectrolyticSeparatorMapper() {
            super("Electrolytic Separator");
        }

        @Override
        public void setup() {
            for (SeparatorRecipe recipe : RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get().values()) {
                FluidStack input = ((FluidInput)recipe.recipeInput).ingredient;
                this.addConversion(((ChemicalPairOutput)recipe.getOutput()).leftGas, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.amount));
                this.addConversion(((ChemicalPairOutput)recipe.getOutput()).rightGas, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.amount));
            }
        }
    }

    private class SolarNeutronActivatorMapper
    extends MekanismMapper {
        public SolarNeutronActivatorMapper() {
            super("Solar Neutron Activator");
        }

        @Override
        public void setup() {
            for (SolarNeutronRecipe recipe : RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.get().values()) {
                this.addConversion(((GasOutput)recipe.getOutput()).output, ((GasInput)recipe.getInput()).ingredient);
            }
        }
    }

    private class ChemicalWasherMapper
    extends MekanismMapper {
        public ChemicalWasherMapper() {
            super("Chemical Washer");
        }

        @Override
        public void setup() {
            for (WasherRecipe recipe : RecipeHandler.Recipe.CHEMICAL_WASHER.get().values()) {
                GasStack gas_input = ((GasInput)recipe.getInput()).ingredient;
                FluidStack fluid_input = recipe.waterInput.ingredient;
                if (!PluginMekanism.this.GAS_MAP.containsKey(gas_input.getGas())) continue;
                this.addConversion(((GasOutput)recipe.getOutput()).output, (Map<Object, Integer>)ImmutableMap.of(PluginMekanism.this.GAS_MAP.get(gas_input.getGas()), (Object)gas_input.amount, (Object)fluid_input, (Object)fluid_input.amount));
            }
        }
    }

    private class ChemicalOxidizerMapper
    extends MekanismMapper {
        public ChemicalOxidizerMapper() {
            super("Chemical Oxidizer");
        }

        @Override
        public void setup() {
            for (OxidationRecipe recipe : RecipeHandler.Recipe.CHEMICAL_OXIDIZER.get().values()) {
                ItemStack input = ((ItemStackInput)recipe.getInput()).ingredient;
                this.addConversion(((GasOutput)recipe.getOutput()).output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.func_190916_E()));
            }
        }
    }

    private class ChemicalInfuserMapper
    extends MekanismMapper {
        public ChemicalInfuserMapper() {
            super("Chemical Infuser");
        }

        @Override
        public void setup() {
            for (ChemicalInfuserRecipe recipe : RecipeHandler.Recipe.CHEMICAL_INFUSER.get().values()) {
                ChemicalPairInput input = (ChemicalPairInput)recipe.getInput();
                this.addConversion(((GasOutput)recipe.getOutput()).output, input.leftGas, input.rightGas);
            }
        }
    }

    private class DissolutionMapper
    extends MekanismMapper {
        public DissolutionMapper() {
            super("Dissolution");
        }

        @Override
        public void setup() {
            for (DissolutionRecipe recipe : RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get().values()) {
                ItemStack input = ((ItemStackInput)recipe.getInput()).ingredient;
                this.addConversion(((GasOutput)recipe.getOutput()).output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.func_190916_E()));
            }
        }
    }

    public abstract class MekanismMapper
    extends PEIMapper {
        public MekanismMapper(String name) {
            super(name);
        }

        protected void addConversion(GasStack gas, Map<Object, Integer> map) {
            if (!PluginMekanism.this.GAS_MAP.containsKey(gas.getGas())) {
                return;
            }
            this.addConversion(gas.amount, PluginMekanism.this.GAS_MAP.get(gas.getGas()), map);
        }

        protected void addConversion(GasStack output, GasStack ... inputs) {
            if (inputs.length == 0) {
                return;
            }
            IngredientMap ingredients = new IngredientMap();
            for (GasStack input : inputs) {
                if (!PluginMekanism.this.GAS_MAP.containsKey(input.getGas())) continue;
                ingredients.addIngredient(PluginMekanism.this.GAS_MAP.get(input.getGas()), input.amount);
            }
            this.addConversion(output, (Map<Object, Integer>)ingredients.getMap());
        }
    }

    private class CrystallizerMapper
    extends PEIMapper {
        public CrystallizerMapper() {
            super("Crystallizer");
        }

        @Override
        public void setup() {
            for (CrystallizerRecipe recipe : RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get().values()) {
                GasStack input = ((GasInput)recipe.getInput()).ingredient;
                if (!PluginMekanism.this.GAS_MAP.containsKey(input.getGas())) continue;
                this.addConversion(((ItemStackOutput)recipe.getOutput()).output.func_77946_l(), (Map<Object, Integer>)ImmutableMap.of(PluginMekanism.this.GAS_MAP.get(input.getGas()), (Object)input.amount));
            }
        }
    }

    private class MetallurgicInfuserMapper
    extends PEIMapper {
        public MetallurgicInfuserMapper() {
            super("Metallurgic Infuser");
        }

        @Override
        public void setup() {
            for (MetallurgicInfuserRecipe recipe : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().values()) {
                ItemStack output = ((ItemStackOutput)recipe.getOutput()).output.func_77946_l();
                ItemStack input = ((InfusionInput)recipe.getInput()).inputStack.func_77946_l();
                InfuseStorage infuse = ((InfusionInput)recipe.getInput()).infuse;
                if (PluginMekanism.this.INFUSE_MAP.containsKey(infuse.getType())) {
                    this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.func_190916_E(), PluginMekanism.this.INFUSE_MAP.get(infuse.getType()), (Object)infuse.getAmount()));
                    continue;
                }
                this.addRecipe(output, input);
            }
        }
    }

    private class ChanceMachineMapper
    extends PEIMapper {
        private final RecipeHandler.Recipe<?, ?, ? extends ChanceMachineRecipe<?>> recipe_type;

        public ChanceMachineMapper(RecipeHandler.Recipe<?, ?, ? extends ChanceMachineRecipe<?>> recipe_type) {
            super(recipe_type.getRecipeName());
            this.recipe_type = recipe_type;
        }

        @Override
        public void setup() {
            for (ChanceMachineRecipe recipe : this.recipe_type.get().values()) {
                ChanceOutput output = (ChanceOutput)recipe.getOutput();
                ArrayList<Object> outputs = new ArrayList<Object>();
                if (output.hasPrimary()) {
                    outputs.add(output.primaryOutput);
                }
                if (output.hasSecondary() && output.secondaryChance >= 100.0) {
                    outputs.add(output.secondaryOutput);
                }
                this.addRecipe(outputs, ((ItemStackInput)recipe.getInput()).ingredient);
            }
        }
    }

    private class AdvancedMachineMapper
    extends PEIMapper {
        private final RecipeHandler.Recipe<?, ?, ? extends AdvancedMachineRecipe<?>> recipe_type;

        public AdvancedMachineMapper(RecipeHandler.Recipe<?, ?, ? extends AdvancedMachineRecipe<?>> recipe_type) {
            super(recipe_type.getRecipeName());
            this.recipe_type = recipe_type;
        }

        @Override
        public void setup() {
            for (AdvancedMachineRecipe recipe : this.recipe_type.get().values()) {
                if (PluginMekanism.this.GAS_MAP.containsKey(((AdvancedMachineInput)recipe.getInput()).gasType)) {
                    this.addRecipe(((ItemStackOutput)recipe.getOutput()).output, ((AdvancedMachineInput)recipe.getInput()).itemStack, PluginMekanism.this.GAS_MAP.get(((AdvancedMachineInput)recipe.getInput()).gasType));
                    continue;
                }
                this.addRecipe(((ItemStackOutput)recipe.getOutput()).output, ((AdvancedMachineInput)recipe.getInput()).itemStack);
            }
        }
    }

    private class DoubleMachineMapper
    extends PEIMapper {
        private final RecipeHandler.Recipe<?, ?, ? extends DoubleMachineRecipe<?>> recipe_type;

        public DoubleMachineMapper(RecipeHandler.Recipe<?, ?, ? extends DoubleMachineRecipe<?>> recipe_type) {
            super(recipe_type.getRecipeName());
            this.recipe_type = recipe_type;
        }

        @Override
        public void setup() {
            for (DoubleMachineRecipe recipe : this.recipe_type.get().values()) {
                this.addRecipe(((ItemStackOutput)recipe.getOutput()).output, ((DoubleMachineInput)recipe.getInput()).itemStack, ((DoubleMachineInput)recipe.getInput()).extraStack);
            }
        }
    }

    private class BasicMachineMapper
    extends PEIMapper {
        private final RecipeHandler.Recipe<?, ?, ? extends BasicMachineRecipe<?>> recipe_type;

        public BasicMachineMapper(RecipeHandler.Recipe<?, ?, ? extends BasicMachineRecipe<?>> recipe_type) {
            super(recipe_type.getRecipeName());
            this.recipe_type = recipe_type;
        }

        @Override
        public void setup() {
            for (BasicMachineRecipe recipe : this.recipe_type.get().values()) {
                this.addRecipe(((ItemStackOutput)recipe.getOutput()).output, ((ItemStackInput)recipe.getInput()).ingredient);
            }
        }
    }
}

