/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import com.google.common.collect.ImmutableMap;
import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.ClassUtils;

@RegPEIPlugin(modid="immersiveengineering")
public class PluginImmersiveEngineering
extends PEIPlugin {
    public PluginImmersiveEngineering(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addMapper(new BlastFurnaceMapper());
        this.addMapper(new CokeOvenMapper());
        this.addMapper(new CrusherMapper());
        this.addMapper(new EnginnerWorkbenchMapper());
        this.addMapper(new KilnMapper());
        this.addMapper(new MetalPressMapper());
    }

    private class MetalPressMapper
    extends MultiblockRecipeMapper {
        public MetalPressMapper() {
            super("Metal Press");
        }

        @Override
        public void setup() {
            for (MetalPressRecipe recipe : MetalPressRecipe.recipeList.values()) {
                this.addRecipe((MultiblockRecipe)recipe);
            }
        }
    }

    private class EnginnerWorkbenchMapper
    extends MultiblockRecipeMapper {
        public EnginnerWorkbenchMapper() {
            super("Enginner Workbench");
        }

        @Override
        public void setup() {
            for (BlueprintCraftingRecipe recipe : BlueprintCraftingRecipe.recipeList.values()) {
                this.addRecipe((MultiblockRecipe)recipe);
            }
        }
    }

    private class CrusherMapper
    extends MultiblockRecipeMapper {
        public CrusherMapper() {
            super("Crusher");
        }

        @Override
        public void setup() {
            for (CrusherRecipe recipe : CrusherRecipe.recipeList) {
                this.addRecipe((MultiblockRecipe)recipe);
            }
        }
    }

    private abstract class MultiblockRecipeMapper
    extends PEIMapper {
        public MultiblockRecipeMapper(String name) {
            super(name);
        }

        protected void addRecipe(MultiblockRecipe recipe) {
            Map input_map;
            ArrayList item_inputs = new ArrayList();
            recipe.getItemInputs().forEach(r -> item_inputs.add(r.toRecipeIngredient()));
            List fluid_inputs = recipe.getFluidInputs();
            NonNullList item_outputs = recipe.getItemOutputs();
            List fluid_outputs = recipe.getFluidOutputs();
            IngredientMap ingredients = new IngredientMap();
            if (item_inputs != null && !item_inputs.isEmpty()) {
                for (Ingredient input : item_inputs) {
                    if (input == null || input == Ingredient.field_193370_a) continue;
                    ingredients.addIngredient(PEIApi.getIngredient(input), 1);
                }
            }
            if (fluid_inputs != null && !fluid_inputs.isEmpty()) {
                for (Ingredient input : fluid_inputs) {
                    if (input.amount <= 0) continue;
                    ingredients.addIngredient((Object)input, input.amount);
                }
            }
            if ((input_map = ingredients.getMap()) == null || input_map.isEmpty()) {
                return;
            }
            ArrayList<Object> outputs = new ArrayList<Object>();
            if (item_outputs != null && !item_outputs.isEmpty()) {
                for (ItemStack output : item_outputs) {
                    if (output == null || output.func_190926_b()) continue;
                    outputs.add(output);
                }
            }
            if (fluid_outputs != null && !fluid_outputs.isEmpty()) {
                for (ItemStack output : fluid_outputs) {
                    if (output == null || output.amount <= 0) continue;
                    outputs.add(output);
                }
            }
            this.addConversion(outputs, (Map<Object, Integer>)input_map);
        }
    }

    private class KilnMapper
    extends PEIMapper {
        public KilnMapper() {
            super("Kiln");
        }

        @Override
        public void setup() {
            for (AlloyRecipe recipe : AlloyRecipe.recipeList) {
                IngredientStack input2;
                IngredientStack input1;
                ItemStack output = recipe.output;
                if (output != null && !output.func_190926_b() && (input1 = recipe.input0) != null && input1.inputSize > 0 && (input2 = recipe.input1) != null && input2.inputSize > 0) continue;
            }
        }
    }

    private class CokeOvenMapper
    extends PEIMapper {
        public CokeOvenMapper() {
            super("Coke Oven");
        }

        @Override
        public void setup() {
            for (CokeOvenRecipe recipe : CokeOvenRecipe.recipeList) {
                Object input;
                ItemStack output = recipe.output;
                if (output == null || output.func_190926_b() || (input = recipe.input) == null) continue;
                if (input instanceof ItemStack) {
                    if (((ItemStack)input).func_190926_b()) {
                        continue;
                    }
                } else if (!(input instanceof String || input instanceof Item || input instanceof Block)) {
                    if (input instanceof Ingredient) {
                        input = PEIApi.getIngredient((Ingredient)input);
                    } else if (input instanceof List) {
                        input = PEIApi.getList((List)input);
                    } else {
                        PEIApi.LOG.debug("Coke Oven Mapper: Unknown Input: {}, ({})", input, (Object)ClassUtils.getPackageCanonicalName(input.getClass()));
                        continue;
                    }
                }
                if (recipe.creosoteOutput > 0) {
                    this.addRecipe(recipe.creosoteOutput, (Object)IEContent.fluidCreosote, ImmutableMap.of((Object)input, (Object)1));
                }
                PEIApi.LOG.debug("Coke Oven Input: {}", (Object)ClassUtils.getPackageCanonicalName(input.getClass()));
                this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)1));
            }
        }
    }

    private class BlastFurnaceMapper
    extends PEIMapper {
        public BlastFurnaceMapper() {
            super("Blast Furnace");
        }

        @Override
        public void setup() {
            for (BlastFurnaceRecipe recipe : BlastFurnaceRecipe.recipeList) {
                Object input;
                ItemStack output = recipe.output;
                if (output == null || output.func_190926_b() || (input = recipe.input) == null) continue;
                if (input instanceof List) {
                    input = PEIApi.getList((List)input);
                } else if (!(input instanceof ItemStack) && !(input instanceof String)) continue;
                this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)1));
                ItemStack slag = recipe.slag;
                if (slag == null || slag.func_190926_b()) continue;
                this.addConversion(slag, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)1));
            }
        }
    }
}

