/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.google.common.collect.ImmutableMap;
import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.recipe.IBasicMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.Recipes;
import ic2.core.recipe.AdvRecipe;
import ic2.core.recipe.AdvShapelessRecipe;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;

@RegPEIPlugin(modid="ic2")
public class PluginIC2
extends PEIPlugin {
    public PluginIC2(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addMapper(new MachineMapper(Recipes.compressor, "Compressor"));
        this.addMapper(new MachineMapper(Recipes.extractor, "Extractor"));
        this.addMapper(new MachineMapper(Recipes.macerator, "Macerator"));
        try {
            Class.forName("ic2.core.recipe.AdvRecipe");
            this.addMapper(new AdvanceRecipeMapper());
            this.addMapper(new MachineMapper(Recipes.blastfurnace, "Blast Furnace"));
            this.addMapper(new MachineMapper(Recipes.blockcutter, "Block Cutter"));
            this.addMapper(new MachineMapper(Recipes.centrifuge, "Centrifuge"));
            this.addMapper(new MachineMapper(Recipes.metalformerCutting, "Metal Former Cutting"));
            this.addMapper(new MachineMapper(Recipes.metalformerExtruding, "Metal Former Extruding"));
            this.addMapper(new MachineMapper(Recipes.metalformerRolling, "Metal Former Rolling"));
            this.addMapper(new MachineMapper(Recipes.oreWashing, "Ore Washing"));
        }
        catch (ClassNotFoundException e1) {
            PEIApi.LOG.info("IC2 Experimental not found, checking for IC2 Classic");
            try {
                Class.forName("ic2.api.classic.recipe.ClassicRecipes");
                this.addMapper(new ClassicRecipeMapper(ClassicRecipes.compressor, "Classic Compressor"));
                this.addMapper(new ClassicRecipeMapper(ClassicRecipes.extractor, "Classic Extractor"));
                this.addMapper(new ClassicRecipeMapper(ClassicRecipes.macerator, "Classic Macerator"));
                this.addMapper(new ClassicRecipeMapper(ClassicRecipes.sawMill, "Classic Saw Mill"));
                this.addMapper(new ClassicRecipeMapper(ClassicRecipes.furnace, "Classic Furnace"));
                this.addMapper(new ClassicRecipeMapper(ClassicRecipes.massfabAmplifier, "Classic Mass Fab Amplifier"));
            }
            catch (ClassNotFoundException e2) {
                PEIApi.LOG.error("IC2 Exp and IC2 Classic not found, this IC2 edition not recognised", (Throwable)e2);
            }
        }
    }

    private class ClassicRecipeMapper
    extends PEIMapper {
        private final IMachineRecipeList recipe_list;

        public ClassicRecipeMapper(IMachineRecipeList recipe_list, String name) {
            super(name);
            this.recipe_list = recipe_list;
        }

        @Override
        public void setup() {
            for (IMachineRecipeList.RecipeEntry recipe : this.recipe_list.getRecipeMap()) {
                recipe.getOutput();
                recipe.getInput().getInputs();
                this.addConversion((ItemStack)recipe.getOutput().getAllOutputs().get(0), (Map<Object, Integer>)ImmutableMap.of((Object)PEIApi.getIngredient(recipe.getInput().getIngredient()), (Object)recipe.getInput().getAmount()));
            }
        }
    }

    private class MachineMapper
    extends PEIMapper {
        private final IBasicMachineRecipeManager manager;

        public MachineMapper(IBasicMachineRecipeManager manager, String name) {
            super(name);
            this.manager = manager;
        }

        @Override
        public void setup() {
            for (MachineRecipe recipe : this.manager.getRecipes()) {
                PEIApi.LOG.debug("IC2 Recipe: {} from {}*{}", recipe.getOutput(), (Object)((IRecipeInput)recipe.getInput()).getInputs(), (Object)((IRecipeInput)recipe.getInput()).getAmount());
                this.addConversion(((Collection)recipe.getOutput()).stream().findFirst().orElse(ItemStack.field_190927_a), (Map<Object, Integer>)ImmutableMap.of((Object)PEIApi.getIngredient(((IRecipeInput)recipe.getInput()).getIngredient()), (Object)((IRecipeInput)recipe.getInput()).getAmount()));
            }
        }
    }

    private class AdvanceRecipeMapper
    extends PEIMapper {
        public AdvanceRecipeMapper() {
            super("Advance Recipe");
        }

        @Override
        public void setup() {
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                if (!(recipe instanceof AdvRecipe) && !(recipe instanceof AdvShapelessRecipe)) continue;
                this.addRecipe(recipe);
            }
        }
    }
}

