/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.OutputWeightPair;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktablesConfig;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.internal.input.SizedIngredient;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;

@RegPEIPlugin(modid="artisanworktables")
public class PluginArtisanWorktables
extends PEIPlugin {
    public PluginArtisanWorktables(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        for (EnumTier tier : EnumTier.values()) {
            if (ModuleWorktablesConfig.isTierEnabled((EnumTier)tier)) continue;
            for (String name : ArtisanAPI.getWorktableNames()) {
                this.addMapper(new WorktableMapper(name, tier));
            }
        }
    }

    private class WorktableMapper
    extends PEIMapper {
        private final String name;
        private final EnumTier tier;

        public WorktableMapper(String name, EnumTier tier) {
            super(name + '_' + tier.getName(), "Enable mapper for worktable " + name + ' ' + tier.getName() + '?');
            this.name = name;
            this.tier = tier;
        }

        @Override
        public void setup() {
            List recipe_list = new ArrayList();
            recipe_list = ArtisanAPI.getWorktableRecipeRegistry((String)this.name).getRecipeListByTier(this.tier, recipe_list);
            for (IArtisanRecipe recipe : recipe_list) {
                ArrayList ingredients = new ArrayList();
                recipe.getIngredientList().forEach(ing -> ingredients.add(new SizedIngredient(ing.getAmount(), ing.toIngredient())));
                recipe.getSecondaryIngredients().forEach(ing -> ingredients.add(new SizedIngredient(ing.getAmount(), ing.toIngredient())));
                FluidStack fluid_input = recipe.getFluidIngredient();
                ArrayList<Object> outputs = new ArrayList<Object>();
                for (OutputWeightPair output : recipe.getOutputWeightPairList()) {
                    outputs.add(output.getOutput().toItemStack());
                }
                if (recipe.getSecondaryOutputChance() >= 1.0f) {
                    outputs.add(recipe.getSecondaryOutput().toItemStack());
                }
                if (recipe.getTertiaryOutputChance() >= 1.0f) {
                    outputs.add(recipe.getTertiaryOutput().toItemStack());
                }
                if (recipe.getQuaternaryOutputChance() >= 1.0f) {
                    outputs.add(recipe.getQuaternaryOutput().toItemStack());
                }
                this.addRecipe(outputs, fluid_input, ingredients.toArray());
            }
        }
    }
}

