/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.sofodev.armorplus.api.crafting.IRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseCraftingManager;
import com.sofodev.armorplus.api.crafting.base.BaseShapedOreRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseShapedRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseShapelessOreRecipe;
import com.sofodev.armorplus.api.crafting.base.BaseShapelessRecipe;
import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;

@RegPEIPlugin(modid="armorplus")
public class PluginArmorPlus
extends PEIPlugin {
    public PluginArmorPlus(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addMapper(new BenchMapper(BaseCraftingManager.getWBInstance()));
        this.addMapper(new BenchMapper(BaseCraftingManager.getUTBInstance()));
        this.addMapper(new BenchMapper(BaseCraftingManager.getHTBInstance()));
        this.addMapper(new BenchMapper(BaseCraftingManager.getCBInstance()));
    }

    private static void addIngredientsFromNonNullList(NonNullList<ItemStack> input, IngredientMap<Object> ingredientMap) {
        for (ItemStack item : input) {
            if (item == null || item.func_190926_b()) continue;
            ingredientMap.addIngredient((Object)item, item.func_190916_E());
        }
    }

    private class BenchMapper
    extends PEIMapper {
        private final BaseCraftingManager bench;

        public BenchMapper(BaseCraftingManager bench) {
            super(bench.getName());
            this.bench = bench;
        }

        @Override
        public void setup() {
            for (IRecipe raw : this.bench.getRecipeList()) {
                NonNullList input;
                BaseShapedRecipe recipe;
                ItemStack output = raw.getRecipeOutput();
                if (output == null || output.func_190926_b()) continue;
                IngredientMap ingredients = new IngredientMap();
                boolean oreShaped = raw instanceof BaseShapedOreRecipe;
                boolean oreShapeless = raw instanceof BaseShapelessOreRecipe;
                if (oreShaped || oreShapeless) {
                    NonNullList input2 = NonNullList.func_191196_a();
                    if (oreShaped) {
                        for (Object in : ((BaseShapedOreRecipe)raw).getInput()) {
                            if (in == null) continue;
                            input2.add(in);
                        }
                    } else if (oreShapeless) {
                        input2 = ((BaseShapelessOreRecipe)raw).getInput();
                    }
                    for (Object i : input2) {
                        if (i instanceof NonNullList) {
                            ingredients.addIngredient(PEIApi.getList((List)i), 1);
                            continue;
                        }
                        ingredients.addIngredient(i, 1);
                    }
                } else if (raw instanceof BaseShapedRecipe) {
                    recipe = (BaseShapedRecipe)raw;
                    input = recipe.getInput();
                    PluginArmorPlus.addIngredientsFromNonNullList((NonNullList<ItemStack>)input, (IngredientMap<Object>)ingredients);
                } else {
                    if (!(raw instanceof BaseShapelessRecipe)) continue;
                    recipe = (BaseShapelessRecipe)raw;
                    input = recipe.getInput();
                    PluginArmorPlus.addIngredientsFromNonNullList((NonNullList<ItemStack>)input, (IngredientMap<Object>)ingredients);
                }
                this.addConversion(output, (Map<Object, Integer>)ingredients.getMap());
            }
        }
    }
}

