/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration;

import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import com.tagnumelite.projecteintegration.api.utils.ConfigHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="projecteintegration", name="ProjectE Integration", version="1.12.2", dependencies="required-after:projecte@[PE1.4.0,);after:actuallyadditions;after:appliedenergistics2;after:armorplus;after:artisanworktables;after:astralsorcery;after:avaritia;after:bloodmagic;after:botania;after:calculator;after:compactmachines3;after:charset;after:draconicevolution;after:embers;after:enderio;after:extendedcrafting;after:extrabotany;after:forestry;after:ic2;after:immersiveengineering;after:libvulpes;after:mekanism@[1.12.2-1.0.0,1.12.2-1.2.0],[1.12.2-9.7.2.373,);after:modularmachinery;after:mysticalagriculture;after:nuclearcraft@[2.17b,);after:harvestcraft;after:psi;after:reborncore;after:sonarcore;after:tconstruct;after:techreborn;after:thaumcraft;after:thermalexpansion;after:woot;", certificateFingerprint="342c9251777bda1ef9b9f1cb1387c2bd4d06cd78", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class PEIntegration {
    public static Configuration config;
    private static boolean DISABLE;
    private static boolean LOADED;
    public static final Logger LOG;
    private static boolean MAPPER_ERRORED;
    private final List<PEIPlugin> PLUGINS = new ArrayList<PEIPlugin>();

    public boolean isLoaded() {
        return LOADED;
    }

    @Mod.EventHandler
    public void fingerprintViolation(FMLFingerprintViolationEvent event) {
        LOG.warn("Somebody has been tampering with ProjectE Integration jar!");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOG.info("Starting Phase: Pre Initialization");
        long startTime = System.currentTimeMillis();
        config = new Configuration(event.getSuggestedConfigurationFile());
        DISABLE = config.getBoolean("disable", "general", false, "Disable the mod outright? Why though?");
        if (DISABLE) {
            LOG.info("Finished Phase: Pre Initialization. Mod Disabled");
            return;
        }
        Set ASM_DATA_SET = event.getAsmData().getAll(RegPEIPlugin.class.getCanonicalName());
        for (ASMDataTable.ASMData asm_data : ASM_DATA_SET) {
            try {
                String modid;
                Class<?> asmClass = Class.forName(asm_data.getClassName());
                RegPEIPlugin plugin_register = asmClass.getAnnotation(RegPEIPlugin.class);
                if (plugin_register == null || !PEIPlugin.class.isAssignableFrom(asmClass) || !config.getBoolean("enable", ConfigHelper.getPluginCategory(modid = plugin_register.modid().toLowerCase()), true, "Enable the plugin") || !Loader.isModLoaded((String)modid)) continue;
                Class<PEIPlugin> asm_instance = asmClass.asSubclass(PEIPlugin.class);
                Constructor<PEIPlugin> plugin = asm_instance.getConstructor(String.class, Configuration.class);
                this.PLUGINS.add(plugin.newInstance(modid, config));
            }
            catch (Throwable t) {
                LOG.error("Failed to load: {}", (Object)asm_data.getClassName(), (Object)t);
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
        long endTime = System.currentTimeMillis();
        LOG.info("Finished Phase: Pre Initialization. Took {}ms", (Object)(endTime - startTime));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (DISABLE) {
            return;
        }
        LOG.info("Starting Phase: Post Initialization");
        long startTime = System.currentTimeMillis();
        for (PEIPlugin plugin : this.PLUGINS) {
            PEIApi.LOG.debug("Running Plugin for Mod: {}", (Object)plugin.modid);
            try {
                plugin.setup();
            }
            catch (Throwable t) {
                LOG.error("Failed to run Plugin for '{}': {}", (Object)plugin.modid, (Object)t);
                t.printStackTrace();
            }
        }
        PEIApi.registerEMCObjects();
        LOG.info("Added {} Mappers", (Object)PEIApi.getMappers().size());
        if (config.hasChanged()) {
            config.save();
        }
        long endTime = System.currentTimeMillis();
        LOG.info("Finished Phase: Post Initialization. Took {}ms", (Object)(endTime - startTime));
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        if (DISABLE || LOADED) {
            return;
        }
        LOG.info("Starting Phase: Server About To Start");
        long startTime = System.currentTimeMillis();
        for (PEIMapper mapper : PEIApi.getMappers()) {
            PEIApi.LOG.debug("Running Mapper: {} ({})", (Object)mapper.name, (Object)mapper);
            try {
                mapper.setup();
            }
            catch (Throwable t) {
                MAPPER_ERRORED = true;
                LOG.error("Mapper '{}' ({}) Failed to run: {}", (Object)mapper.name, (Object)mapper, (Object)t);
                t.printStackTrace();
            }
        }
        LOG.info("Added {} Conversions", (Object)PEIApi.mapped_conversions);
        if (config.hasChanged()) {
            config.save();
        }
        PEIApi.clearCache();
        this.PLUGINS.clear();
        long endTime = System.currentTimeMillis();
        LOG.info("Finished Phase: Server About To Start. Took {}ms", (Object)(endTime - startTime));
        LOADED = true;
    }

    static {
        DISABLE = false;
        LOADED = false;
        LOG = LogManager.getLogger((String)"projecteintegration");
        MAPPER_ERRORED = false;
    }
}

