/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import forestry.arboriculture.TreeConfig;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    private static Species balsa;
    private static Species baobab;
    private static Species bullPine;
    private static Species cherry;
    private static Species chestnut;
    private static Species coastSequoia;
    private static Species cocobolo;
    private static Species desertAcacia;
    private static Species ebony;
    private static Species ipe;
    private static Species kapok;
    private static Species larch;
    private static Species lemon;
    private static Species mahoe;
    private static Species maple;
    private static Species mahogany;
    private static Species padauk;
    private static Species palm;
    private static Species papaya;
    private static Species plum;
    private static Species poplar;
    private static Species silverLime;
    private static Species greenheart;
    private static Species teak;
    private static Species walnut;
    private static Species wenge;
    private static Species willow;
    private static Species zebrawood;
    private float globalRarity;

    private static void createStaticAliases() {
        balsa = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "balsa"));
        baobab = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "baobab"));
        bullPine = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "bullpine"));
        cherry = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "cherry"));
        cocobolo = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "cocobolo"));
        desertAcacia = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "desertacacia"));
        ebony = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "ebony"));
        larch = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "larch"));
        maple = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "maple"));
        mahogany = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "meranti"));
        padauk = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "padauk"));
        palm = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "palm"));
        papaya = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "papaya"));
        plum = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "plum"));
        silverLime = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "silverlime"));
        greenheart = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "sipiri"));
        teak = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "teak"));
        wenge = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "wenge"));
        willow = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "willow"));
        zebrawood = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesforestry", "zebrawood"));
    }

    public void populate(BiomeDataBase dbase) {
        BiomeDataBasePopulator.createStaticAliases();
        TreeConfig.blacklistTreeDim(null, (int)0);
        this.globalRarity = TreeConfig.getSpawnRarity(null);
        if (this.globalRarity <= 0.0f) {
            return;
        }
        Biome.field_185377_q.forEach(biome -> {
            BiomePropertySelectors.RandomSpeciesSelector selector;
            if (biome == Biomes.field_76781_i && TreeConfig.isValidBiome((String)ModContent.getTreeUIDfromID("palm"), (Biome)biome)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(palm, this.getSpawnWeight("palm", (Biome)biome));
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.REPLACE);
                dbase.setChanceSelector(biome, (rand, species, radius) -> rand.nextFloat() < 0.1f ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL, BiomeDataBase.Operation.REPLACE);
                dbase.setDensitySelector(biome, (rand, noiseDensity) -> noiseDensity * 0.01, BiomeDataBase.Operation.REPLACE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(100).add(willow, this.getSpawnWeight("willow", (Biome)biome));
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(100).add(plum, this.getSpawnWeight("plum", (Biome)biome)).add(palm, this.getSpawnWeight("palm", (Biome)biome)).add(teak, this.getSpawnWeight("teak", (Biome)biome)).add(balsa, this.getSpawnWeight("balsa", (Biome)biome)).add(mahogany, this.getSpawnWeight("meranti", (Biome)biome)).add(papaya, this.getSpawnWeight("papaya", (Biome)biome)).add(zebrawood, this.getSpawnWeight("zebrawood", (Biome)biome)).add(greenheart, this.getSpawnWeight("sipiri", (Biome)biome)).add(ebony, this.getSpawnWeight("ebony", (Biome)biome)).add(cocobolo, this.getSpawnWeight("cocobolo", (Biome)biome)).add(wenge, this.getSpawnWeight("wenge", (Biome)biome)).add(padauk, this.getSpawnWeight("padauk", (Biome)biome));
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(100).add(bullPine, this.getSpawnWeight("bullpine", (Biome)biome)).add(larch, this.getSpawnWeight("larch", (Biome)biome));
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(100).add(cherry, this.getSpawnWeight("cherry", (Biome)biome)).add(maple, this.getSpawnWeight("maple", (Biome)biome)).add(silverLime, this.getSpawnWeight("silverlime", (Biome)biome));
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(100).add(desertAcacia, this.getSpawnWeight("desertacacia", (Biome)biome)).add(padauk, this.getSpawnWeight("padauk", (Biome)biome));
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                selector = new BiomePropertySelectors.RandomSpeciesSelector().add(500).add(baobab, this.getSpawnWeight("baobab", (Biome)biome)).add(ebony, this.getSpawnWeight("ebony", (Biome)biome));
                dbase.setSpeciesSelector(biome, (BiomePropertySelectors.ISpeciesSelector)selector, BiomeDataBase.Operation.SPLICE_BEFORE);
            }
        });
    }

    protected int getSpawnWeight(String tree, Biome biome) {
        if (TreeConfig.isValidBiome((String)ModContent.getTreeUIDfromID(tree), (Biome)biome)) {
            return (int)Math.ceil(10.0f * TreeConfig.getSpawnRarity((String)ModContent.getTreeUIDfromID(tree)) * this.globalRarity);
        }
        return 0;
    }
}

