/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees.vanilla;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SpeciesSpruce
extends Species {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 10;

    public SpeciesSpruce(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesforestry", "spruce"), treeFamily, ModContent.spruceLeavesProperties);
        ModContent.spruceLeavesProperties.setTree(treeFamily);
        this.setBasicGrowingParameters(0.6f, 18.0f, 1, 5, 0.9f);
        this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic(2.0f));
        this.setRequiresTileEntity(true);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
        this.envFactor(BiomeDictionary.Type.WET, 0.75f);
        this.generateSeed();
        this.setupStandardSeedDropping();
        this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
    }

    protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
        if (signal.isInTrunk()) {
            probMap[EnumFacing.UP.func_176745_a()] = 2;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                probMap[dir.func_176745_a()] = 2;
            }
        }
        probMap[signal.dir.func_176734_d().func_176745_a()] = 0;
        return probMap;
    }

    public boolean isBiomePerfect(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS);
    }
}

