/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees.vanilla;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.Random;
import maxhyper.dynamictreesforestry.ModContent;
import maxhyper.dynamictreesforestry.genfeatures.FeatureGenFruitLeaves;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SpeciesOak
extends Species {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 0;

    public SpeciesOak(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesforestry", "oak"), treeFamily, ModContent.oakLeavesProperties);
        ModContent.oakLeavesProperties.setTree(treeFamily);
        this.setBasicGrowingParameters(0.4f, 10.0f, 1, 4, 0.7f);
        this.setRequiresTileEntity(true);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
        this.generateSeed();
        ModContent.appleLeaves.setSpecies(this.getFamily().getCommonSpecies());
        this.addGenFeature((IGenFeature)new FeatureGenFruitLeaves(8, 10, ModContent.oakLeavesProperties.getDynamicLeavesState(), ModContent.fruitAppleLeavesProperties.getDynamicLeavesState(), 0.5f));
        this.addGenFeature((IGenFeature)new FeatureGenFruit(ModBlocks.blockApple).setRayDistance(4.0f));
    }

    public int getSeasonalTooltipFlags(int dimension) {
        return 2;
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesOak.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_76772_c});
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }
}

