/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesforestry.trees.vanilla;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenCocoa;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenUndergrowth;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import maxhyper.dynamictreesforestry.ModContent;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SpeciesJungle
extends Species {
    public static Block leavesBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry", "leaves.decorative.0"));
    public static int leavesMeta = 15;

    public SpeciesJungle(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesforestry", "jungle"), treeFamily, ModContent.jungleLeavesProperties);
        ModContent.jungleLeavesProperties.setTree(treeFamily);
        this.setBasicGrowingParameters(0.2f, 28.0f, 3, 2, 1.0f);
        this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"jungle"));
        this.setRequiresTileEntity(true);
        this.envFactor(BiomeDictionary.Type.COLD, 0.15f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.2f);
        this.envFactor(BiomeDictionary.Type.HOT, 1.1f);
        this.envFactor(BiomeDictionary.Type.WET, 1.1f);
        this.generateSeed();
        this.setupStandardSeedDropping();
        this.addGenFeature((IGenFeature)new FeatureGenCocoa());
        this.addGenFeature((IGenFeature)new FeatureGenVine().setQuantity(16).setMaxLength(16));
        this.addGenFeature((IGenFeature)new FeatureGenUndergrowth());
    }

    public boolean isBiomePerfect(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
    }
}

